/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class FadeInBackground
extends Background {
    private int targetArgbColor;
    private int currentColor;
    private long lastUpdateTime;
    private int lastX;
    private int lastY;
    private boolean animationRunning;
    private int[] xCoords;
    private int[] yCoords;
    private boolean restartOnShowNotify;
    private boolean restartOnTime;

    public FadeInBackground(int targetArgbColor, boolean restartOnTime, boolean restartOnShowNotify) {
        this.animationRunning = true;
        this.targetArgbColor = targetArgbColor;
        this.restartOnTime = restartOnTime;
        this.restartOnShowNotify = restartOnShowNotify;
        this.currentColor = 0xFFFFFF & targetArgbColor;
        this.xCoords = new int[4];
        this.xCoords[0] = Integer.MIN_VALUE;
        this.yCoords = new int[4];
        this.yCoords[0] = Integer.MIN_VALUE;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (x < 1) {
            width += x;
            x = 1;
        }
        if (this.lastX != x) {
            this.lastX = x;
            this.xCoords[0] = x;
            this.xCoords[1] = x + width;
            this.xCoords[2] = x + width;
            this.xCoords[3] = x;
        }
        if (y < 1) {
            height += y;
            y = 1;
        }
        if (this.lastY != y) {
            this.lastY = y;
            this.yCoords[0] = y;
            this.yCoords[1] = y;
            this.yCoords[2] = y + height;
            this.yCoords[3] = y + height;
        }
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        dg.fillPolygon(this.xCoords, 0, this.yCoords, 0, 4, this.currentColor);
        this.lastX = x;
        this.lastY = y;
    }

    public boolean animate() {
        if (!this.animationRunning) {
            return false;
        }
        if (this.restartOnTime) {
            this.lastUpdateTime = System.currentTimeMillis();
        }
        int currentTranslucency = this.currentColor >>> 24;
        int targetTranslucency = this.targetArgbColor >>> 24;
        if ((currentTranslucency += 20) > targetTranslucency) {
            currentTranslucency = targetTranslucency;
            this.animationRunning = false;
        }
        this.currentColor = 0xFFFFFF & this.targetArgbColor | currentTranslucency << 24;
        return true;
    }

    public void showNotify() {
        super.showNotify();
        boolean restart = false;
        if (this.restartOnShowNotify) {
            restart = true;
        } else if (this.restartOnTime) {
            long updateTime = System.currentTimeMillis();
            restart = updateTime - this.lastUpdateTime > 5000L;
            this.lastUpdateTime = updateTime;
        }
        if (restart) {
            this.currentColor = 0xFFFFFF & this.targetArgbColor;
            this.animationRunning = true;
            this.animate();
        }
    }

    public FadeInBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.animationRunning = dataInputStream.readBoolean();
        this.currentColor = dataInputStream.readInt();
        this.lastUpdateTime = dataInputStream.readLong();
        this.lastX = dataInputStream.readInt();
        this.lastY = dataInputStream.readInt();
        this.restartOnShowNotify = dataInputStream.readBoolean();
        this.restartOnTime = dataInputStream.readBoolean();
        this.targetArgbColor = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.xCoords = new int[n2];
            n = 0;
            while (n < n2) {
                this.xCoords[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.yCoords = new int[n2];
            n = 0;
            while (n < n2) {
                this.yCoords[n] = dataInputStream.readInt();
                ++n;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animationRunning);
        dataOutputStream.writeInt(this.currentColor);
        dataOutputStream.writeLong(this.lastUpdateTime);
        dataOutputStream.writeInt(this.lastX);
        dataOutputStream.writeInt(this.lastY);
        dataOutputStream.writeBoolean(this.restartOnShowNotify);
        dataOutputStream.writeBoolean(this.restartOnTime);
        dataOutputStream.writeInt(this.targetArgbColor);
        if (this.xCoords == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.xCoords.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.xCoords[n]);
                ++n;
            }
        }
        if (this.yCoords == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.yCoords.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.yCoords[n]);
                ++n;
            }
        }
    }
}

