/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class HorizontalSplitBackground
extends Background {
    private static final int SIDE_RIGHT = 1;
    private int leftColor;
    private int rightColor;
    private int splitPos;
    private boolean isPercent;
    private boolean isSplitRight;

    public HorizontalSplitBackground(int leftColor, int rightColor, int splitPos, int splitSide) {
        this.leftColor = leftColor;
        this.rightColor = rightColor;
        this.splitPos = splitPos < 0 ? -splitPos : splitPos;
        this.isPercent = splitPos < 0;
        this.isSplitRight = splitSide == 1;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int split = this.splitPos;
        if (this.isPercent) {
            split = width * split / 100;
        }
        if (split == 0) {
            split = Math.min(width, height);
        }
        if (this.isSplitRight) {
            split = width - split;
        }
        g.setColor(this.leftColor);
        g.fillRect(x, y, split + 1, height);
        g.setColor(this.rightColor);
        g.fillRect(x + split, y, width - split, height);
    }

    public HorizontalSplitBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.isPercent = dataInputStream.readBoolean();
        this.isSplitRight = dataInputStream.readBoolean();
        this.leftColor = dataInputStream.readInt();
        this.rightColor = dataInputStream.readInt();
        this.splitPos = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.isPercent);
        dataOutputStream.writeBoolean(this.isSplitRight);
        dataOutputStream.writeInt(this.leftColor);
        dataOutputStream.writeInt(this.rightColor);
        dataOutputStream.writeInt(this.splitPos);
    }
}

