/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageBackground
extends Background {
    private Image image;
    private int color;
    private boolean isLoaded;
    private String imageUrl;
    private int anchor;
    private boolean doCenter;
    private int xOffset;
    private int yOffset;

    public ImageBackground(int color, String imageUrl, int anchor) {
        this(color, imageUrl, anchor, 0, 0);
    }

    public ImageBackground(int color, String imageUrl, int anchor, int xOffset, int yOffset) {
        this.color = color;
        this.imageUrl = imageUrl;
        this.anchor = anchor;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.doCenter = anchor == 3;
        this.isLoaded = imageUrl == null;
    }

    public ImageBackground(int color, Image image, int anchor) {
        this(color, image, anchor, 0, 0);
    }

    public ImageBackground(int color, Image image, int anchor, int xOffset, int yOffset) {
        this.color = color;
        this.image = image;
        this.imageUrl = null;
        this.isLoaded = true;
        this.anchor = anchor;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.doCenter = anchor == 3;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (!this.isLoaded) {
            try {
                this.image = StyleSheet.getImage(this.imageUrl, this, false);
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.ui.backgrounds.ImageBackground", 168, (Object)("unable to load image [" + this.imageUrl + "]"), e);
            }
            this.isLoaded = true;
        }
        if (this.color != -1) {
            g.setColor(this.color);
            g.fillRect(x, y, width, height);
        }
        x += this.xOffset;
        y += this.yOffset;
        if (this.image != null) {
            if (this.doCenter) {
                int centerX = x + width / 2;
                int centerY = y + height / 2;
                g.drawImage(this.image, centerX, centerY, 3);
            } else {
                if ((this.anchor & 1) == 1) {
                    x += width / 2;
                } else if ((this.anchor & 8) == 8) {
                    x += width;
                }
                if ((this.anchor & 2) == 2) {
                    y += height / 2;
                } else if ((this.anchor & 0x20) == 32) {
                    y += height;
                }
                g.drawImage(this.image, x, y, this.anchor);
            }
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.isLoaded = image != null;
    }

    public Image getImage() {
        return this.image;
    }

    public void releaseResources() {
        if (this.imageUrl != null) {
            this.isLoaded = false;
            this.image = null;
        }
    }

    public ImageBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.anchor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.doCenter = dataInputStream.readBoolean();
        this.image = (Image)Serializer.deserialize(dataInputStream);
        this.imageUrl = (String)Serializer.deserialize(dataInputStream);
        this.isLoaded = dataInputStream.readBoolean();
        this.xOffset = dataInputStream.readInt();
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.anchor);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeBoolean(this.doCenter);
        Serializer.serialize(this.image, dataOutputStream);
        Serializer.serialize(this.imageUrl, dataOutputStream);
        dataOutputStream.writeBoolean(this.isLoaded);
        dataOutputStream.writeInt(this.xOffset);
        dataOutputStream.writeInt(this.yOffset);
    }
}

