/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class PulsatingCirclesBackground
extends Background {
    private int startColor;
    private int firstColor;
    private int secondColor;
    private short[] diameters;
    private int preciseMinDiameter;
    private int preciseMaxDiameter;
    private int[] preciseDiameters;
    private int diameterGrowth;

    public PulsatingCirclesBackground(int firstColor, int secondColor, int minDiameter, int maxDiameter, int numberOfCircles, int step) {
        this.startColor = firstColor;
        this.firstColor = firstColor;
        this.secondColor = secondColor;
        this.preciseMinDiameter = minDiameter << 8;
        this.preciseMaxDiameter = maxDiameter << 8;
        this.diameters = new short[numberOfCircles];
        this.preciseDiameters = new int[numberOfCircles];
        this.diameterGrowth = step <<= 8;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int centerX = x + (width >> 1);
        int centerY = y + (height >> 1);
        int color = this.startColor;
        for (int i = this.diameters.length - 1; i >= 0; --i) {
            short diameter = this.diameters[i];
            int offset = diameter >> 1;
            g.setColor(color);
            g.fillArc(centerX - offset, centerY - offset, (int)diameter, (int)diameter, 0, 360);
            color = color == this.firstColor ? this.secondColor : this.firstColor;
        }
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        int i = this.preciseDiameters.length - 1;
        int diameter = this.preciseDiameters[i] + this.diameterGrowth;
        if (diameter > this.preciseMaxDiameter) {
            while (i > 0) {
                this.preciseDiameters[i] = diameter = this.preciseDiameters[i - 1] + this.diameterGrowth;
                this.diameters[i] = (short)(diameter >>> 8);
                --i;
            }
            this.preciseDiameters[0] = this.preciseMinDiameter;
            this.diameters[0] = (short)(this.preciseMinDiameter >>> 8);
            this.startColor = this.startColor == this.firstColor ? this.secondColor : this.firstColor;
        } else {
            while (i >= 0) {
                this.preciseDiameters[i] = diameter = this.preciseDiameters[i] + this.diameterGrowth;
                this.diameters[i] = (short)(diameter >>> 8);
                --i;
            }
        }
        if (parent != null) {
            int w = parent.getBackgroundWidth();
            int h = parent.getBackgroundHeight();
            diameter = this.preciseMaxDiameter >>> 8;
            int x = w - diameter >> 1;
            int y = h - diameter >> 1;
            parent.addRelativeToBackgroundRegion(this, null, repaintRegion, x, y, diameter, diameter);
        } else {
            repaintRegion.addRegion(0, 0, screen.getWidth(), screen.getScreenHeight());
        }
    }

    public void showNotify() {
        super.showNotify();
        int numberOfCircles = this.diameters.length;
        int difference = (this.preciseMaxDiameter - this.preciseMinDiameter) / numberOfCircles;
        while (numberOfCircles > 0) {
            int diameter = difference * numberOfCircles;
            this.diameters[--numberOfCircles] = (short)(diameter >>> 8);
            this.preciseDiameters[numberOfCircles] = diameter;
        }
        this.startColor = this.firstColor;
    }

    public PulsatingCirclesBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.diameterGrowth = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.diameters = new short[n2];
            n = 0;
            while (n < n2) {
                this.diameters[n] = dataInputStream.readShort();
                ++n;
            }
        }
        this.firstColor = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.preciseDiameters = new int[n2];
            n = 0;
            while (n < n2) {
                this.preciseDiameters[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.preciseMaxDiameter = dataInputStream.readInt();
        this.preciseMinDiameter = dataInputStream.readInt();
        this.secondColor = dataInputStream.readInt();
        this.startColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.diameterGrowth);
        if (this.diameters == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.diameters.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeShort(this.diameters[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.firstColor);
        if (this.preciseDiameters == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.preciseDiameters.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.preciseDiameters[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.preciseMaxDiameter);
        dataOutputStream.writeInt(this.preciseMinDiameter);
        dataOutputStream.writeInt(this.secondColor);
        dataOutputStream.writeInt(this.startColor);
    }
}

