/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.backgrounds.DoubleGradientVerticalBackground;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RoundRectDoubleGradientVerticalBackground
extends DoubleGradientVerticalBackground {
    private int arcWidth;
    private int arcHeight;
    private int borderColor;
    private int[] buffer;
    private int lastWidth;
    private int lastHeight;

    public RoundRectDoubleGradientVerticalBackground(int firstTopColor, int firstBottomColor, int secondTopColor, int secondBottomColor, int stroke, int start, int end, boolean isPercent, int arcWidth, int arcHeight, int borderColor, int borderWidth) {
        super(firstBottomColor, firstBottomColor, secondTopColor, secondBottomColor, stroke, start, end, isPercent);
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int border;
        if (this.buffer == null || width != this.lastWidth || height != this.lastHeight) {
            if (width < this.arcWidth || height < this.arcHeight || height < 2) {
                return;
            }
            Image image = Image.createImage((int)width, (int)height);
            Graphics imageG = image.getGraphics();
            super.paint(0, 0, width, height, imageG);
            if (this.borderWidth > 0) {
                imageG.setColor(this.borderColor);
                for (int b = this.borderWidth; b > 0; --b) {
                    imageG.drawRoundRect(b, b, width - (b << 1), height - (b << 1), this.arcWidth, this.arcHeight);
                }
            }
            int[] gradientImageData = new int[width * height];
            image.getRGB(gradientImageData, 0, width, 0, 0, width, height);
            imageG.setColor(0);
            imageG.fillRoundRect(0, 0, width, height, this.arcWidth, this.arcHeight);
            int[] roundImageData = new int[width * height];
            image.getRGB(roundImageData, 0, width, 0, 0, width, height);
            int targetColor = roundImageData[width + (width >> 1)];
            boolean isLastPixelFullyTransparent = true;
            int halfTransparentColor = 0;
            for (int i = 0; i < roundImageData.length; ++i) {
                int col = roundImageData[i];
                if (col == targetColor) {
                    if (!isLastPixelFullyTransparent) continue;
                    gradientImageData[i] = halfTransparentColor;
                    isLastPixelFullyTransparent = false;
                    continue;
                }
                gradientImageData[i] = 0;
                if (isLastPixelFullyTransparent) continue;
                gradientImageData[i - 1] = halfTransparentColor;
                isLastPixelFullyTransparent = true;
            }
            this.buffer = gradientImageData;
            this.lastWidth = width;
            this.lastHeight = height;
        }
        DrawUtil.drawRgb(this.buffer, x, y, width, height, true, g);
        if (border > 0) {
            g.setColor(this.borderColor);
            g.drawRoundRect(x, y, width, height, this.arcWidth, this.arcHeight);
            for (border = this.borderWidth; border >= 0; --border) {
                g.drawRoundRect(x + border, y + border, width - 2 * border, height - 2 * border, this.arcWidth, this.arcHeight);
            }
        }
    }

    public RoundRectDoubleGradientVerticalBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.borderColor = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.buffer = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.buffer[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.lastHeight = dataInputStream.readInt();
        this.lastWidth = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeInt(this.borderColor);
        if (this.buffer == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.buffer.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.buffer[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.lastHeight);
        dataOutputStream.writeInt(this.lastWidth);
    }
}

