/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class SimpleBackground
extends Background {
    private int color;
    private Color colorObj;
    private boolean isInitialized;

    public SimpleBackground(int color) {
        this.color = color;
        this.isInitialized = true;
    }

    public SimpleBackground(Color color) {
        this.colorObj = color;
        this.isInitialized = false;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (!this.isInitialized) {
            this.color = this.colorObj.getColor();
            this.isInitialized = true;
            this.colorObj = null;
        }
        g.setColor(this.color);
        g.fillRect(x, y, width, height);
    }

    public int getColor() {
        if (!this.isInitialized) {
            this.color = this.colorObj.getColor();
            this.isInitialized = true;
            this.colorObj = null;
        }
        return this.color;
    }

    public SimpleBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.color = dataInputStream.readInt();
        this.colorObj = (Color)Serializer.deserialize(dataInputStream);
        this.isInitialized = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.color);
        Serializer.serialize(this.colorObj, dataOutputStream);
        dataOutputStream.writeBoolean(this.isInitialized);
    }
}

