/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TranslucentRoundRectBackground
extends Background {
    private int color;
    private int arcWidth;
    private int arcHeight;
    private int borderColor;
    private int[] buffer;
    private int lastWidth;
    private int lastHeight;

    public TranslucentRoundRectBackground(int color, int arcWidth, int arcHeight) {
        this(color, arcWidth, arcHeight, 0, 0);
    }

    public TranslucentRoundRectBackground(int color, int arcWidth, int arcHeight, int borderColor, int borderWidth) {
        this.color = color;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int border;
        if (this.buffer == null || width != this.lastWidth || height != this.lastHeight) {
            if (width < this.arcWidth || height < this.arcHeight) {
                return;
            }
            Image image = Image.createImage((int)width, (int)height);
            Graphics imageG = image.getGraphics();
            imageG.setColor(0);
            imageG.fillRoundRect(0, 0, width, height, this.arcWidth, this.arcHeight);
            int[] imageData = new int[width * height];
            image.getRGB(imageData, 0, width, 0, 0, width, height);
            int targetColor = imageData[width + width / 2];
            boolean isLastPixelFullyTransparent = true;
            int halfTransparentColor = (this.color >>> 1 | 0xFFFFFF) & (this.color | 0xFF000000);
            for (int i = 0; i < imageData.length; ++i) {
                int col = imageData[i];
                if (col == targetColor) {
                    if (isLastPixelFullyTransparent) {
                        imageData[i] = halfTransparentColor;
                        isLastPixelFullyTransparent = false;
                        continue;
                    }
                    imageData[i] = this.color;
                    continue;
                }
                imageData[i] = 0;
                if (isLastPixelFullyTransparent) continue;
                imageData[i - 1] = halfTransparentColor;
                isLastPixelFullyTransparent = true;
            }
            this.buffer = imageData;
            this.lastWidth = width;
            this.lastHeight = height;
        }
        DrawUtil.drawRgb(this.buffer, x, y, width, height, true, g);
        if (border > 0) {
            g.setColor(this.borderColor);
            g.drawRoundRect(x, y, width, height, this.arcWidth, this.arcHeight);
            for (border = this.borderWidth; border >= 0; --border) {
                g.drawRoundRect(x + border, y + border, width - 2 * border, height - 2 * border, this.arcWidth, this.arcHeight);
            }
        }
    }

    public TranslucentRoundRectBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.borderColor = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.buffer = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.buffer[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.color = dataInputStream.readInt();
        this.lastHeight = dataInputStream.readInt();
        this.lastWidth = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeInt(this.borderColor);
        if (this.buffer == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.buffer.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.buffer[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.lastHeight);
        dataOutputStream.writeInt(this.lastWidth);
    }
}

