/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.ui.Border;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class SquareSonarBorder
extends Border {
    protected int innerColor;
    protected int outerColor;
    protected int steps;
    protected int distance;
    protected int pause;
    protected int numSignals;
    protected int speed;
    protected boolean hasTranslucentColor;
    protected int[] distances;
    protected int[] colors;
    protected boolean[] activeSignals;
    protected long lastEmittingTime;
    protected int emittedSignals;
    protected boolean isOutbound;
    protected boolean isAnimationStopped;

    public SquareSonarBorder(int innerColor, int outerColor, int steps, int distance, int pause, int numSignals, int speed) {
        this.isOutbound = true;
        this.innerColor = innerColor;
        this.outerColor = outerColor;
        this.steps = steps;
        this.distance = distance;
        this.pause = pause;
        this.numSignals = numSignals;
        this.speed = speed;
        this.hasTranslucentColor = innerColor >>> 24 != 0 && innerColor >>> 24 != 255 || outerColor >>> 24 != 0 && outerColor >>> 24 != 255;
        this.distances = new int[steps];
        if (speed != -1) {
            for (int i = 0; i < steps; ++i) {
                this.distances[i] = i * speed;
            }
        } else {
            int amount;
            int i;
            int sum = 0;
            int dist = distance;
            for (i = 0; i < steps; ++i) {
                amount = dist / 3;
                sum += amount;
                dist -= amount;
            }
            dist = distance + (distance - sum);
            sum = 0;
            for (i = 0; i < steps; ++i) {
                this.distances[i] = sum;
                amount = dist / 3;
                sum += amount;
                dist -= amount;
            }
        }
        this.activeSignals = new boolean[steps];
        this.colors = DrawUtil.getGradient(innerColor, outerColor, steps);
        this.borderWidth = 0;
    }

    public void showNotify() {
        super.showNotify();
        for (int i = 0; i < this.steps; ++i) {
            this.activeSignals[i] = false;
        }
        this.emittedSignals = 0;
        this.isAnimationStopped = false;
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        if (parent == null || this.isAnimationStopped) {
            return;
        }
        int maxDist = 0;
        for (int i = this.steps - 1; i > 0; --i) {
            boolean active;
            this.activeSignals[i] = active = this.activeSignals[i - 1];
            if (!active || maxDist != 0) continue;
            maxDist = this.distances[i];
        }
        this.activeSignals[0] = false;
        if (currentTime - this.lastEmittingTime > (long)this.pause && (this.numSignals == -1 || this.emittedSignals < this.numSignals)) {
            this.activeSignals[0] = true;
            this.lastEmittingTime = currentTime;
            if (maxDist == 0) {
                maxDist = this.distances[0];
            }
            ++this.emittedSignals;
        }
        if (maxDist == 0 && this.numSignals != -1 && this.emittedSignals >= this.numSignals) {
            maxDist = this.distances[this.steps - 1];
            this.isAnimationStopped = true;
        }
        parent.addRelativeToBackgroundRegion(null, this, repaintRegion, -maxDist, -maxDist, parent.getBackgroundWidth() + (maxDist << 1), parent.getBackgroundHeight() + (maxDist << 1));
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        for (int i = 0; i < this.steps; ++i) {
            int dist = this.distances[i];
            if (!this.activeSignals[i]) continue;
            int color = this.colors[i];
            if (this.hasTranslucentColor) {
                DrawUtil.drawLine(color, x - dist, y - dist, x + width + dist, y - dist, g);
                DrawUtil.drawLine(color, x - dist, y + height + dist, x + width + dist, y + height + dist, g);
                DrawUtil.drawLine(color, x - dist, y - dist, x - dist, y + height + dist, g);
                DrawUtil.drawLine(color, x + width + dist, y - dist, x + width + dist, y + height + dist, g);
                continue;
            }
            g.setColor(color);
            g.drawRect(x - dist, y - dist, width + dist, height + dist);
        }
    }

    public SquareSonarBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.activeSignals = new boolean[n2];
            n = 0;
            while (n < n2) {
                this.activeSignals[n] = dataInputStream.readBoolean();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.colors = new int[n2];
            n = 0;
            while (n < n2) {
                this.colors[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.distance = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.distances = new int[n2];
            n = 0;
            while (n < n2) {
                this.distances[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.emittedSignals = dataInputStream.readInt();
        this.hasTranslucentColor = dataInputStream.readBoolean();
        this.innerColor = dataInputStream.readInt();
        this.isAnimationStopped = dataInputStream.readBoolean();
        this.isOutbound = dataInputStream.readBoolean();
        this.lastEmittingTime = dataInputStream.readLong();
        this.numSignals = dataInputStream.readInt();
        this.outerColor = dataInputStream.readInt();
        this.pause = dataInputStream.readInt();
        this.speed = dataInputStream.readInt();
        this.steps = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        if (this.activeSignals == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.activeSignals.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeBoolean(this.activeSignals[n]);
                ++n;
            }
        }
        if (this.colors == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.colors.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.colors[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.distance);
        if (this.distances == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.distances.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.distances[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.emittedSignals);
        dataOutputStream.writeBoolean(this.hasTranslucentColor);
        dataOutputStream.writeInt(this.innerColor);
        dataOutputStream.writeBoolean(this.isAnimationStopped);
        dataOutputStream.writeBoolean(this.isOutbound);
        dataOutputStream.writeLong(this.lastEmittingTime);
        dataOutputStream.writeInt(this.numSignals);
        dataOutputStream.writeInt(this.outerColor);
        dataOutputStream.writeInt(this.pause);
        dataOutputStream.writeInt(this.speed);
        dataOutputStream.writeInt(this.steps);
    }
}

