/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.chartviews;

import de.enough.polish.ui.ChartItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class VerticalBarChartView
extends ItemView {
    protected void initContent(Item parent, int firstLineWidth, int lineWidth) {
        this.initContentByParent(parent, firstLineWidth, lineWidth);
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        ChartItem chart = (ChartItem)parent;
        int[][] sequences = chart.getDataSequences();
        if (sequences == null) {
            return;
        }
        int[] inout_params = new int[]{x, y};
        int baseLineY = chart.paintGrid(x, y, leftBorder, rightBorder, inout_params, g);
        x = inout_params[0];
        y = inout_params[1];
        int[] colors = chart.getColors();
        int scaleFactorY = chart.getScaleFactorY();
        int length = sequences[0].length;
        int leftSpace = rightBorder - (x + length);
        int barWidth = Math.max(2, leftSpace / sequences[0].length);
        int barSpace = 1;
        for (int i = 0; i < sequences.length; ++i) {
            int color = colors[i];
            g.setColor(color);
            int[] dataRow = sequences[i];
            if (dataRow == null || dataRow.length == 0) continue;
            int datumX = x;
            for (int j = 0; j < dataRow.length; ++j) {
                int bottom;
                int top;
                int datum = dataRow[j];
                int datumY = baseLineY - datum * scaleFactorY / 100;
                if (baseLineY > datumY) {
                    top = datumY;
                    bottom = baseLineY;
                } else {
                    top = baseLineY;
                    bottom = datumY;
                }
                g.fillRect(datumX, top, barWidth, bottom - top);
                datumX += barWidth + barSpace;
            }
        }
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
    }
}

