/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.ui.containerviews.FishEyeContainerView;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class CarouselContainerView
extends FishEyeContainerView {
    private boolean isFocusedAtBottom = true;
    private int maximumHeight = -1;

    protected void initItemArrangement(int lineWidth, Item[] myItems, int length, int maxWidth, int maxHeight) {
        int processed;
        int lineHeight = 100;
        Screen scr = this.getScreen();
        if (scr != null) {
            lineHeight = scr.getScreenContentHeight() - 10;
        }
        if (this.maximumHeight != -1 && lineHeight > this.maximumHeight) {
            lineHeight = this.maximumHeight;
        }
        if (this.isRemoveText && !this.isShowTextInTitle) {
            if (this.focusedLabel == null && this.focusedStyle != null) {
                this.focusedLabel = new StringItem(null, "T");
                this.focusedLabel.setStyle(this.focusedStyle);
            }
            if (this.focusedItem != null) {
                if (this.focusedLabel.getText() == null) {
                    this.focusedLabel.setText("T");
                }
                lineHeight -= this.focusedLabel.getItemHeight(lineWidth, lineWidth);
            }
        }
        this.referenceXCenterPositions = new int[length];
        this.referenceYCenterPositions = new int[length];
        this.referenceXCenterPositions[this.focusedIndex] = lineWidth >> 1;
        this.referenceFocusedIndex = this.focusedIndex;
        if (this.focusedStyle != null && this.focusedItem != null) {
            UiAccess.focus(this.focusedItem, this.focusedDirection, this.focusedStyle);
            this.focusedWidth = this.focusedItem.getItemWidth(lineWidth, lineWidth);
            this.focusedItem.relativeX = lineWidth - this.focusedWidth >> 1;
        } else if (this.focusedWidth == 0) {
            this.focusedWidth = maxWidth;
        }
        if (this.focusedItem != null) {
            this.referenceYCenterPositions[this.focusedIndex] = this.isFocusedAtBottom ? lineHeight - (this.focusedItem.getItemHeight(lineWidth, lineWidth) >> 1) : this.focusedItem.getItemHeight(lineWidth, lineWidth) >> 1;
        }
        int availableWidth = lineWidth;
        int availableHeight = lineHeight;
        int halfLength = length - 1 >> 1;
        int availableWidthPerItem = (availableWidth << 8) / (halfLength + 1);
        int availableHeightPerItem = (availableHeight << 8) / (length - 1);
        int index = this.focusedIndex - 1;
        int x = lineWidth - maxWidth >> 1;
        int y = lineHeight - (maxHeight >> 1);
        boolean isDirectionSwitched = false;
        for (processed = 0; processed < halfLength; ++processed) {
            if (index < 0) {
                index = length - 1;
            }
            if ((x -= (availableWidthPerItem >> 8) * this.getScaleFactor(processed, length) / 100) <= maxWidth >> 1 || !isDirectionSwitched && processed + 1 >= halfLength >> 1) {
                x = maxWidth >> 1;
                availableWidthPerItem = -availableWidthPerItem;
                isDirectionSwitched = true;
            }
            this.referenceXCenterPositions[index] = x;
            this.referenceYCenterPositions[index] = y -= availableHeightPerItem >> 8;
            --index;
        }
        index = this.focusedIndex + 1;
        processed = 0;
        halfLength = length >> 1;
        x = lineWidth + maxWidth >> 1;
        y = lineHeight - (maxHeight >> 1);
        if (availableWidthPerItem > 0) {
            availableWidthPerItem = -availableWidthPerItem;
        }
        isDirectionSwitched = false;
        while (processed < halfLength) {
            if (index >= length) {
                index = 0;
            }
            if ((x -= (availableWidthPerItem >> 8) * this.getScaleFactor(processed, length) / 100) >= lineWidth - (maxWidth >> 1) || !isDirectionSwitched && processed + 1 >= halfLength >> 1) {
                x = lineWidth - (maxWidth >> 1);
                availableWidthPerItem = -availableWidthPerItem;
                isDirectionSwitched = true;
            }
            this.referenceXCenterPositions[index] = x;
            this.referenceYCenterPositions[index] = y -= availableHeightPerItem >> 8;
            ++index;
            ++processed;
        }
    }

    protected void initContent(Item parentContainerItem, int firstLineWidth, int lineWidth) {
        super.initContent(parentContainerItem, firstLineWidth, lineWidth);
        int lineHeight = 100;
        Screen scr = this.getScreen();
        if (scr != null) {
            lineHeight = scr.getScreenContentHeight() - 10;
        }
        if (this.maximumHeight != -1 && lineHeight > this.maximumHeight) {
            lineHeight = this.maximumHeight;
        }
        this.contentHeight = lineHeight;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
        Integer maxHeightInt = style.getIntProperty(145);
        if (maxHeightInt != null) {
            this.maximumHeight = maxHeightInt;
        }
    }

    protected void paintItem(Item item, int index, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        super.paintItem(item, index, x, y - 5, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.isFocusedAtBottom = dataInputStream.readBoolean();
        this.maximumHeight = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.isFocusedAtBottom);
        dataOutputStream.writeInt(this.maximumHeight);
    }
}

