/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CenterNavigationContainerView
extends ContainerView {
    static transient ImageItem leftItem;
    static transient ImageItem rightItem;
    int grayOffset = 0;
    private transient int[][] inactiveIcons = null;
    boolean animateItems = false;
    Style originalStyle;

    public CenterNavigationContainerView() {
        this.allowsAutoTraversal = false;
        this.isHorizontal = true;
        this.isVertical = false;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
        Integer grayOffsetObj = style.getIntProperty(347);
        if (grayOffsetObj != null) {
            this.grayOffset = grayOffsetObj;
        }
    }

    protected void initContent(Item parentItm, int firstLineWidth, int lineWidth) {
        int height = 0;
        Item[] items = this.parentContainer.getItems();
        this.inactiveIcons = new int[items.length][];
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            int itemHeight = item.getItemHeight(lineWidth, lineWidth);
            int itemWidth = item.itemWidth;
            if (itemWidth == 0) {
                this.inactiveIcons[i] = new int[0];
                continue;
            }
            if (itemHeight > height) {
                height = itemHeight;
            }
            if (item.isFocused) {
                item.setStyle(this.originalStyle);
            }
            int[] rgbData = UiAccess.getRgbData(item);
            if (item.isFocused) {
                item.setStyle(item.getFocusedStyle());
            }
            this.convertToGrayScale(rgbData, this.grayOffset);
            this.inactiveIcons[i] = rgbData;
        }
        this.contentHeight = height;
        this.contentWidth = lineWidth;
    }

    public Style focusItem(int index, Item item, int direction, Style focusedStyle) {
        this.originalStyle = super.focusItem(index, item, direction, focusedStyle);
        return this.originalStyle;
    }

    protected void convertToGrayScale(int[] rgbData, int grayOffset) {
        for (int i = 0; i < rgbData.length; ++i) {
            int color = rgbData[i];
            int alpha = 0xFF000000 & color;
            int red = 0xFF & color >>> 16;
            int green = 0xFF & color >>> 8;
            int blue = color & 0xFF;
            int brightness = (red + green + blue) / 3 & 0xFF;
            if ((brightness += grayOffset) > 255) {
                brightness = 255;
            }
            color = brightness << 0 | brightness << 8 | brightness << 16;
            rgbData[i] = color |= alpha;
        }
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int originalLeftBorder = leftBorder;
        int originalRightBorder = rightBorder;
        int width = rightBorder - leftBorder;
        int leftWidth = leftItem.getItemWidth(width, width);
        int rightWidth = rightItem.getItemWidth(width, width);
        leftBorder += leftWidth;
        rightBorder -= rightWidth;
        int center = width / 2;
        int itemWidth = myItems[0].getItemWidth(width, width);
        int offset = center - this.focusedIndex * itemWidth - itemWidth / 2;
        for (int i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            int xOffset = x + offset;
            if (xOffset > leftBorder && xOffset + itemWidth < rightBorder) {
                if (item == this.focusedItem) {
                    item.paint(xOffset, y, leftBorder, rightBorder, g);
                } else {
                    int[] rgbData = this.inactiveIcons[i];
                    DrawUtil.drawRgb(rgbData, xOffset, y, item.itemWidth, item.itemHeight, true, g);
                }
            }
            offset += itemWidth;
        }
        leftBorder = originalLeftBorder;
        rightBorder = originalRightBorder;
        if (myItems.length != 0) {
            if (this.focusedIndex != 0) {
                leftItem.paint(leftBorder, y, leftBorder, rightBorder, g);
            }
            if (this.focusedIndex != myItems.length - 1) {
                rightItem.paint(rightBorder - rightWidth, y, leftBorder, rightBorder, g);
            }
        }
    }

    protected boolean isValid(Item parent, Style style) {
        return super.isValid(parent, style);
    }

    static {
        try {
            leftItem = new ImageItem(null, Image.createImage((String)"/arrow_left.png"), 1, null);
            rightItem = new ImageItem(null, Image.createImage((String)"/arrow_right.png"), 2, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animateItems = dataInputStream.readBoolean();
        this.grayOffset = dataInputStream.readInt();
        this.originalStyle = (Style)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animateItems);
        dataOutputStream.writeInt(this.grayOffset);
        Serializer.serialize(this.originalStyle, dataOutputStream);
    }
}

