/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.Debug;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.ImageUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class CoverFlowContainerView
extends ContainerView {
    protected int scaleFactorWidth = 60;
    protected int scaleFactorOuterHeight = 90;
    protected int scaleFactorInnerHeight = 60;
    private int minSpeed = 2;
    private int maxSpeed = -1;
    protected int[] targetXCenterPositions;
    protected int[] referenceXCenterPositions;
    protected int[] targetYCenterPositions;
    protected int[] referenceYCenterPositions;
    protected boolean isRemoveText = true;
    protected boolean includeAllItems = true;
    protected String[] labels;
    protected transient StringItem focusedLabel;
    protected transient int[][] originalRgbData;
    protected int[] originalRgbDataWidths;
    protected transient int[][] shownRgbData;
    protected int[] shownRgbDataWidths;
    protected int[] shownRgbDataHeights;
    protected int referenceFocusedIndex;
    protected transient Background focusedBackground;
    protected Border focusedBorder;
    protected Style focusedStyle;
    protected int focusedDirection;
    protected int focusedWidth;
    protected int maxItemHeight;
    protected boolean isShowTextInTitle;
    private Object lock = new Object();

    public CoverFlowContainerView() {
        this.allowsAutoTraversal = false;
        this.allowsDirectSelectionByPointerEvent = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.shownRgbDataWidths == null) {
                    Debug.debug("warn", "de.enough.polish.ui.containerviews.CoverFlowContainerView", 140, "CoverFlowContainerView is animated before initContent has been called");
                    return;
                }
                boolean animated = false;
                if (this.targetXCenterPositions != null) {
                    Item[] myItems = this.parentContainer.getItems();
                    int length = myItems.length;
                    for (int i = 0; i < length; ++i) {
                        int newHeightOuter;
                        int newHeightInner;
                        int target = this.targetXCenterPositions[i];
                        Item item = myItems[i];
                        int halfItemWidth = item.itemWidth >> 1;
                        int distance = CoverFlowContainerView.getDistance(i, this.focusedIndex, length);
                        if (distance != 0) {
                            --distance;
                        }
                        int factor = this.scaleFactorWidth;
                        if (i != this.focusedIndex) {
                            halfItemWidth = halfItemWidth * factor / 100;
                        }
                        int current = item.relativeX + halfItemWidth;
                        boolean scaleInAnyCase = false;
                        if (current != target) {
                            if (Math.abs(current - target) > item.itemWidth) {
                                scaleInAnyCase = true;
                            }
                            animated = true;
                            item.relativeX = this.calculateCurrent(current, target) - halfItemWidth;
                        }
                        if (this.targetYCenterPositions != null) {
                            int halfItemHeight = item.itemHeight >> 1;
                            if (i != this.focusedIndex) {
                                halfItemHeight = halfItemHeight * factor / 100;
                            }
                            if ((current = item.relativeY + halfItemHeight) != (target = this.targetYCenterPositions[i])) {
                                animated = true;
                                item.relativeY = this.calculateCurrent(current, target) - halfItemHeight;
                            }
                        }
                        boolean isLeft = current < target;
                        current = this.shownRgbDataWidths[i];
                        target = i == this.focusedIndex ? this.originalRgbDataWidths[i] : this.originalRgbDataWidths[i] * factor / 100;
                        if (current == target && !scaleInAnyCase) continue;
                        animated = true;
                        int[] data = this.originalRgbData[i];
                        int originalWidth = this.originalRgbDataWidths[i];
                        int newWidth = this.calculateCurrent(current, target);
                        int height = item.itemHeight;
                        if (i == this.focusedIndex) {
                            newHeightInner = height * (this.scaleFactorInnerHeight + current * (100 - this.scaleFactorInnerHeight) / target) / 100;
                            newHeightOuter = height * (this.scaleFactorOuterHeight + current * (100 - this.scaleFactorOuterHeight) / target) / 100;
                        } else {
                            newHeightInner = height * (100 - current * (100 - this.scaleFactorInnerHeight) / target) / 100;
                            newHeightOuter = height * (100 - current * (100 - this.scaleFactorOuterHeight) / target) / 100;
                        }
                        if (newHeightInner > height) {
                            newHeightInner = height;
                        }
                        if (newHeightOuter > height) {
                            newHeightOuter = height;
                        }
                        this.shownRgbDataWidths[i] = newWidth;
                        if (i == this.focusedIndex && isLeft || this.isLeftOfFocus(i, this.focusedIndex, length)) {
                            ImageUtil.perspectiveShear(data, this.shownRgbData[i], originalWidth, newWidth, newHeightOuter, newHeightInner, 255, 0);
                            continue;
                        }
                        ImageUtil.perspectiveShear(data, this.shownRgbData[i], originalWidth, newWidth, newHeightInner, newHeightOuter, 255, 0);
                    }
                }
                if (this.isRemoveText && this.focusedLabel != null) {
                    animated |= this.focusedLabel.animate();
                }
                if (this.focusedBackground != null) {
                    animated |= this.focusedBackground.animate();
                }
                if (animated && repaintRegion != null) {
                    repaintRegion.addRegion(this.parentContainer.getAbsoluteX() - 10, this.parentContainer.getAbsoluteY() - 10, this.parentContainer.itemWidth + 20, this.parentContainer.itemHeight + 20);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static int getDistance(int i, int focused, int length) {
        int left;
        int right;
        if (i == focused) {
            return 0;
        }
        if (focused > i) {
            right = focused;
            left = i;
        } else {
            right = i;
            left = focused;
        }
        return Math.min(length - right + left, right - left);
    }

    protected int calculateCurrent(int current, int target) {
        int speed = Math.max(this.minSpeed, Math.abs(current - target) / 3);
        if (this.maxSpeed != -1 && speed > this.maxSpeed) {
            speed = this.maxSpeed;
        }
        if (current < target) {
            if ((current += speed) > target) {
                current = target;
            }
        } else if ((current -= speed) < target) {
            current = target;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initContent(Item parentContainerItem, int firstLineWidth, int lineWidth) {
        try {
            Object object = this.lock;
            synchronized (object) {
                Item item;
                int i;
                Container parent;
                this.isVertical = false;
                this.isHorizontal = true;
                this.parentContainer = parent = (Container)parentContainerItem;
                Item[] myItems = parent.getItems();
                int length = myItems.length;
                if (this.focusedIndex == -1 && length != 0) {
                    this.focusedIndex = parent.focusedIndex != -1 ? parent.focusedIndex : 0;
                    this.focusedItem = myItems[this.focusedIndex];
                    this.focusedStyle = this.focusedItem.getFocusedStyle();
                }
                if (this.referenceXCenterPositions != null && this.referenceXCenterPositions.length == length) {
                    return;
                }
                if (this.isRemoveText && this.focusedLabel == null) {
                    this.focusedLabel = new StringItem(null, null);
                }
                if (this.isRemoveText && (this.labels == null || this.labels.length != length)) {
                    this.labels = new String[length];
                }
                int maxWidth = 0;
                int maxHeight = 0;
                boolean hasFocusableItem = false;
                this.originalRgbData = new int[length][];
                this.originalRgbDataWidths = new int[length];
                this.shownRgbData = new int[length][];
                this.shownRgbDataWidths = new int[length];
                this.shownRgbDataHeights = new int[length];
                for (i = 0; i < length; ++i) {
                    item = myItems[i];
                    if (this.isRemoveText) {
                        IconItem iconItem;
                        String text = item.getLabel();
                        if (text != null) {
                            this.labels[i] = text;
                            item.setLabel(null);
                        } else if (item instanceof IconItem && (text = (iconItem = (IconItem)item).getText()) != null) {
                            this.labels[i] = text;
                            iconItem.setTextVisible(false);
                        }
                    }
                    int width = item.getItemWidth(firstLineWidth, lineWidth);
                    int height = item.getItemHeight(firstLineWidth, lineWidth);
                    int[] data = UiAccess.getRgbData(item);
                    this.originalRgbData[i] = data;
                    this.originalRgbDataWidths[i] = width;
                    if (this.scaleFactorWidth == 100) {
                        this.shownRgbData[i] = data;
                        this.shownRgbDataWidths[i] = width;
                        this.shownRgbDataHeights[i] = height;
                    } else {
                        int newWidth = width * this.scaleFactorWidth / 100;
                        int newHeightInner = height * this.scaleFactorInnerHeight / 100;
                        int newHeightOuter = height * this.scaleFactorOuterHeight / 100;
                        this.shownRgbData[i] = new int[data.length];
                        if (this.isLeftOfFocus(i, this.focusedIndex, length)) {
                            ImageUtil.perspectiveShear(data, this.shownRgbData[i], width, newWidth, newHeightOuter, newHeightInner, 255, 0);
                        } else {
                            ImageUtil.perspectiveShear(data, this.shownRgbData[i], width, newWidth, newHeightInner, newHeightOuter, 255, 0);
                        }
                        this.shownRgbDataWidths[i] = newWidth;
                        this.shownRgbDataHeights[i] = height;
                    }
                    if (item.appearanceMode != 0) {
                        hasFocusableItem = true;
                    }
                    if (width > maxWidth) {
                        maxWidth = width;
                    }
                    if (height <= maxHeight) continue;
                    maxHeight = height;
                }
                this.maxItemHeight = maxHeight;
                this.appearanceMode = hasFocusableItem ? 3 : 0;
                this.initItemArrangement(lineWidth, myItems, length, maxWidth, maxHeight);
                for (i = 0; i < length; ++i) {
                    item = myItems[i];
                    int distance = CoverFlowContainerView.getDistance(i, this.focusedIndex, length);
                    if (distance != 0) {
                        --distance;
                    }
                    int halfItemWidth = item.getItemWidth(lineWidth, lineWidth) >> 1;
                    int halfItemHeight = item.getItemHeight(lineWidth, lineWidth) >> 1;
                    if (i != this.focusedIndex) {
                        int factor = this.getScaleFactor(distance, length);
                        halfItemWidth = halfItemWidth * factor / 100;
                        halfItemHeight = halfItemHeight * factor / 100;
                    }
                    item.relativeX = this.referenceXCenterPositions[i] - halfItemWidth;
                    if (this.referenceYCenterPositions == null) continue;
                    item.relativeY = this.referenceYCenterPositions[i] - halfItemHeight;
                }
                if (this.focusedStyle != null) {
                    this.focusItem(this.focusedIndex, this.focusedItem, this.focusedDirection, this.focusedStyle);
                    this.focusedItem.relativeX = this.referenceXCenterPositions[this.focusedIndex] - (this.focusedItem.getItemWidth(lineWidth, lineWidth) >> 1);
                    if (this.referenceYCenterPositions != null) {
                        this.focusedItem.relativeY = this.referenceYCenterPositions[this.focusedIndex] - (this.focusedItem.getItemHeight(lineWidth, lineWidth) >> 1);
                    }
                    this.focusedStyle = null;
                }
                this.contentWidth = lineWidth;
                int n = this.contentHeight = this.focusedLabel == null ? maxHeight : maxHeight + this.focusedLabel.getItemHeight(lineWidth, lineWidth);
                if (!this.isFocused) {
                    AnimationThread.addAnimationItem(parent);
                }
                this.animate(System.currentTimeMillis(), null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isLeftOfFocus(int i, int focIndex, int length) {
        int leftBorder = focIndex - (length >> 1);
        if (leftBorder >= 0) {
            return i < focIndex && i >= leftBorder;
        }
        return i < focIndex || i >= length + leftBorder;
    }

    protected void initItemArrangement(int lineWidth, Item[] myItems, int length, int maxWidth, int maxHeight) {
        int processed;
        this.referenceXCenterPositions = new int[length];
        this.referenceXCenterPositions[this.focusedIndex] = lineWidth >> 1;
        this.referenceFocusedIndex = this.focusedIndex;
        int completeWidth = maxWidth + maxWidth * this.scaleFactorWidth / 100 * (length - 1) + (length - 1) * this.paddingHorizontal;
        if (this.focusedStyle != null && this.focusedItem != null) {
            UiAccess.focus(this.focusedItem, this.focusedDirection, this.focusedStyle);
            this.focusedWidth = this.focusedItem.getItemWidth(lineWidth, lineWidth);
            this.focusedItem.relativeX = lineWidth - this.focusedWidth >> 1;
        } else if (this.focusedWidth == 0) {
            this.focusedWidth = maxWidth;
        }
        int availableWidth = completeWidth > lineWidth && this.includeAllItems || completeWidth < lineWidth && this.isLayoutExpand() ? (lineWidth - this.focusedWidth >> 1) - this.paddingHorizontal : (completeWidth - this.focusedWidth >> 1) - this.paddingHorizontal;
        int availableWidthPerItem = (availableWidth << 8) / (length - 1);
        int index = this.focusedIndex - 1;
        int halfLength = length - 1 >> 1;
        int startX = availableWidth;
        for (processed = 0; processed < halfLength; ++processed) {
            if (index < 0) {
                index = length - 1;
            }
            this.referenceXCenterPositions[index] = startX - (processed * availableWidthPerItem >>> 8) - processed * this.paddingHorizontal;
            --index;
        }
        index = this.focusedIndex + 1;
        halfLength = length >> 1;
        startX = lineWidth - availableWidth - (this.paddingHorizontal >> 1);
        for (processed = 0; processed < halfLength; ++processed) {
            if (index >= length) {
                index = 0;
            }
            this.referenceXCenterPositions[index] = startX + (processed * availableWidthPerItem >>> 8) + processed * this.paddingHorizontal;
            ++index;
        }
    }

    protected int getScaleFactor(int distance, int length) {
        int factor = 100;
        factor = this.scaleFactorWidth;
        return factor;
    }

    protected void defocus(Style originalStyle) {
        super.defocus(originalStyle);
        AnimationThread.addAnimationItem(this.parentItem);
    }

    public void focus(Style focusstyle, int direction) {
        super.focus(focusstyle, direction);
        AnimationThread.removeAnimationItem(this.parentItem);
    }

    public Style focusItem(int focIndex, Item item, int direction, Style focStyle) {
        int[] targetXPositions;
        if (this.referenceXCenterPositions == null || this.referenceXCenterPositions.length != this.parentContainer.size()) {
            this.focusedStyle = focStyle;
            this.focusedDirection = direction;
            this.focusedIndex = focIndex;
            this.focusedItem = item;
            return item.getStyle();
        }
        int difference = this.referenceFocusedIndex - focIndex;
        Item[] myItems = this.parentContainer.getItems();
        int[] targetYPositions = null;
        if (this.targetXCenterPositions == null || this.targetXCenterPositions.length != myItems.length) {
            targetXPositions = new int[myItems.length];
            if (this.referenceYCenterPositions != null) {
                targetYPositions = new int[myItems.length];
            }
        } else {
            targetXPositions = this.targetXCenterPositions;
            if (this.referenceYCenterPositions != null) {
                targetYPositions = this.targetYCenterPositions;
            }
        }
        if (this.referenceXCenterPositions.length != targetXPositions.length) {
            return item.getStyle();
        }
        for (int i = 0; i < myItems.length; ++i) {
            int nextIndex = i + difference;
            if (nextIndex < 0) {
                nextIndex = myItems.length + nextIndex;
            } else if (nextIndex >= myItems.length) {
                nextIndex -= myItems.length;
            }
            targetXPositions[i] = this.referenceXCenterPositions[nextIndex];
            if (targetYPositions == null) continue;
            targetYPositions[i] = this.referenceYCenterPositions[nextIndex];
        }
        this.targetXCenterPositions = targetXPositions;
        if (targetYPositions != null) {
            this.targetYCenterPositions = targetYPositions;
        }
        Style itemStyle = !item.isFocused ? super.focusItem(focIndex, item, direction, focStyle) : item.getStyle();
        this.focusedBackground = this.removeItemBackground(item);
        this.focusedBorder = this.removeItemBorder(item);
        if (this.isRemoveText) {
            if (this.isShowTextInTitle) {
                Screen scr = this.getScreen();
                if (scr != null) {
                    scr.setTitle(this.labels[focIndex]);
                }
            } else if (this.focusedLabel != null) {
                this.focusedLabel.setText(this.labels[focIndex]);
                if (this.focusedLabel.getStyle() != item.getStyle()) {
                    this.focusedLabel.setStyle(item.getStyle());
                    this.removeItemBackground(this.focusedLabel);
                    this.removeItemBorder(this.focusedLabel);
                }
            }
        }
        return itemStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        Object object = this.lock;
        synchronized (object) {
            int itemY;
            Item item;
            int processed;
            int index;
            int lineWidth = rightBorder - leftBorder;
            int itemLabelDiff = 0;
            if (this.isRemoveText && this.focusedLabel != null) {
                Style labelStyle = this.focusedLabel.getStyle();
                itemLabelDiff = labelStyle.paddingVertical - labelStyle.paddingBottom - labelStyle.paddingTop - labelStyle.marginBottom - labelStyle.marginTop;
            }
            if (this.focusedItem != null && (this.focusedBackground != null || this.focusedBorder != null)) {
                int backgroundHeight;
                int backgroundWidth;
                Item item2 = this.focusedItem;
                if (this.isRemoveText && this.focusedLabel != null) {
                    backgroundWidth = Math.max(item2.itemWidth, this.focusedLabel.getItemWidth(lineWidth, lineWidth));
                    backgroundHeight = item2.itemHeight + this.focusedLabel.itemHeight + itemLabelDiff;
                } else {
                    backgroundWidth = item2.itemWidth;
                    backgroundHeight = item2.itemHeight;
                }
                int backgroundX = x + (rightBorder - leftBorder >> 1) - (backgroundWidth >> 1);
                if (this.focusedBackground != null) {
                    this.focusedBackground.paint(backgroundX, y, backgroundWidth, backgroundHeight, g);
                }
                if (this.focusedBorder != null) {
                    this.focusedBorder.paint(backgroundX, y, backgroundWidth, backgroundHeight, g);
                }
            }
            if ((index = this.focusedIndex - (processed = myItems.length - 1 >> 1)) < 0) {
                index += myItems.length;
            }
            while (processed > 0) {
                item = myItems[index];
                int itemX = x + item.relativeX;
                itemY = y + item.relativeY;
                this.paintItem(item, index, itemX, itemY, itemX, itemX + item.itemWidth, clipX, clipY, clipWidth, clipHeight, g);
                --processed;
                if (++index != myItems.length) continue;
                index = 0;
            }
            index = (this.focusedIndex + (myItems.length >> 1)) % myItems.length;
            for (processed = myItems.length >> 1; processed > 0; --processed) {
                item = myItems[index];
                int itemX = x + item.relativeX;
                itemY = y + item.relativeY;
                this.paintItem(item, index, itemX, itemY, itemX, itemX + item.itemWidth, clipX, clipY, clipWidth, clipHeight, g);
                if (--index != -1) continue;
                index = myItems.length - 1;
            }
            item = this.focusedItem;
            if (item != null) {
                int itemX = x + item.relativeX;
                itemY = y + item.relativeY;
                this.paintItem(item, this.focusedIndex, itemX, itemY, itemX, itemX + item.itemWidth, clipX, clipY, clipWidth, clipHeight, g);
                if (this.isRemoveText && this.focusedLabel != null) {
                    int labelX = x + (rightBorder - leftBorder >> 1) - (this.focusedLabel.getItemWidth(lineWidth, lineWidth) >> 1);
                    int labelY = y + this.contentHeight - this.focusedLabel.itemHeight;
                    this.focusedLabel.paint(labelX, labelY, labelX, labelX + this.focusedLabel.itemWidth, g);
                }
            }
        }
    }

    protected void paintItem(Item item, int index, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int width = this.shownRgbDataWidths[index];
        if (index == this.focusedIndex && width == this.originalRgbDataWidths[index]) {
            super.paintItem(item, index, x, y, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
            return;
        }
        int height = this.shownRgbDataHeights[index];
        int[] data = this.shownRgbData[index];
        int itemLayout = item.getLayout();
        if ((itemLayout & 0x30) == 48) {
            y += this.maxItemHeight - height >> 1;
        } else if ((itemLayout & 0x20) == 32) {
            y += this.maxItemHeight - height;
        }
        DrawUtil.drawRgb(data, x, y, width, height, true, g);
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources() {
        super.releaseResources();
        Object object = this.lock;
        synchronized (object) {
            this.originalRgbData = null;
            this.originalRgbDataWidths = null;
            this.shownRgbData = null;
            this.shownRgbDataWidths = null;
            this.shownRgbDataHeights = null;
            this.referenceXCenterPositions = null;
            this.referenceYCenterPositions = null;
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.focusedBorder = (Border)Serializer.deserialize(dataInputStream);
        this.focusedDirection = dataInputStream.readInt();
        this.focusedStyle = (Style)Serializer.deserialize(dataInputStream);
        this.focusedWidth = dataInputStream.readInt();
        this.includeAllItems = dataInputStream.readBoolean();
        this.isRemoveText = dataInputStream.readBoolean();
        this.isShowTextInTitle = dataInputStream.readBoolean();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.labels = new String[n2];
            n = 0;
            while (n < n2) {
                this.labels[n] = (String)Serializer.deserialize(dataInputStream);
                ++n;
            }
        }
        this.lock = Serializer.deserialize(dataInputStream);
        this.maxItemHeight = dataInputStream.readInt();
        this.maxSpeed = dataInputStream.readInt();
        this.minSpeed = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.originalRgbDataWidths = new int[n2];
            n = 0;
            while (n < n2) {
                this.originalRgbDataWidths[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.referenceFocusedIndex = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.referenceXCenterPositions = new int[n2];
            n = 0;
            while (n < n2) {
                this.referenceXCenterPositions[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.referenceYCenterPositions = new int[n2];
            n = 0;
            while (n < n2) {
                this.referenceYCenterPositions[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.scaleFactorInnerHeight = dataInputStream.readInt();
        this.scaleFactorOuterHeight = dataInputStream.readInt();
        this.scaleFactorWidth = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.shownRgbDataHeights = new int[n2];
            n = 0;
            while (n < n2) {
                this.shownRgbDataHeights[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.shownRgbDataWidths = new int[n2];
            n = 0;
            while (n < n2) {
                this.shownRgbDataWidths[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.targetXCenterPositions = new int[n2];
            n = 0;
            while (n < n2) {
                this.targetXCenterPositions[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.targetYCenterPositions = new int[n2];
            n = 0;
            while (n < n2) {
                this.targetYCenterPositions[n] = dataInputStream.readInt();
                ++n;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        Serializer.serialize(this.focusedBorder, dataOutputStream);
        dataOutputStream.writeInt(this.focusedDirection);
        Serializer.serialize(this.focusedStyle, dataOutputStream);
        dataOutputStream.writeInt(this.focusedWidth);
        dataOutputStream.writeBoolean(this.includeAllItems);
        dataOutputStream.writeBoolean(this.isRemoveText);
        dataOutputStream.writeBoolean(this.isShowTextInTitle);
        if (this.labels == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.labels.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                Serializer.serialize(this.labels[n], dataOutputStream);
                ++n;
            }
        }
        Serializer.serialize(this.lock, dataOutputStream);
        dataOutputStream.writeInt(this.maxItemHeight);
        dataOutputStream.writeInt(this.maxSpeed);
        dataOutputStream.writeInt(this.minSpeed);
        if (this.originalRgbDataWidths == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.originalRgbDataWidths.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.originalRgbDataWidths[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.referenceFocusedIndex);
        if (this.referenceXCenterPositions == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.referenceXCenterPositions.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.referenceXCenterPositions[n]);
                ++n;
            }
        }
        if (this.referenceYCenterPositions == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.referenceYCenterPositions.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.referenceYCenterPositions[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.scaleFactorInnerHeight);
        dataOutputStream.writeInt(this.scaleFactorOuterHeight);
        dataOutputStream.writeInt(this.scaleFactorWidth);
        if (this.shownRgbDataHeights == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.shownRgbDataHeights.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.shownRgbDataHeights[n]);
                ++n;
            }
        }
        if (this.shownRgbDataWidths == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.shownRgbDataWidths.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.shownRgbDataWidths[n]);
                ++n;
            }
        }
        if (this.targetXCenterPositions == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.targetXCenterPositions.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.targetXCenterPositions[n]);
                ++n;
            }
        }
        if (this.targetYCenterPositions == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.targetYCenterPositions.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.targetYCenterPositions[n]);
                ++n;
            }
        }
    }
}

