/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class ExclusiveSingleLineView
extends ContainerView {
    private static final int POSITION_BOTH_SIDES = 0;
    private static final int POSITION_RIGHT = 1;
    private static final int POSITION_LEFT = 2;
    private int arrowColor;
    private boolean allowRoundTrip;
    private int arrowWidth = 10;
    private int currentItemIndex;
    private transient ChoiceItem currentItem;
    private int leftArrowStartX;
    private int leftArrowEndX;
    private int rightArrowStartX;
    private int rightArrowEndX;

    public ExclusiveSingleLineView() {
        this.allowsAutoTraversal = false;
    }

    protected void initContent(Item parentItm, int firstLineWidth, int lineWidth) {
        Container parent = (Container)parentItm;
        int selectedItemIndex = ((ChoiceGroup)parent).getSelectedIndex();
        if (selectedItemIndex == -1) {
            selectedItemIndex = 0;
        }
        parent.focusedIndex = selectedItemIndex;
        int height = 0;
        int completeArrowWidth = this.arrowWidth + this.paddingHorizontal << 1;
        this.leftArrowStartX = 0;
        this.leftArrowEndX = this.arrowWidth;
        this.rightArrowStartX = lineWidth - this.arrowWidth;
        this.rightArrowEndX = lineWidth;
        lineWidth -= completeArrowWidth;
        int selectedItemHeight = 0;
        if (selectedItemIndex < parent.size()) {
            ChoiceItem selectedItem = (ChoiceItem)parent.get(selectedItemIndex);
            selectedItem.drawBox = false;
            selectedItemHeight = selectedItem.getItemHeight(lineWidth, lineWidth);
            this.contentWidth = selectedItem.getItemWidth(lineWidth, lineWidth) + completeArrowWidth;
            this.appearanceMode = 3;
            this.currentItem = selectedItem;
            this.currentItemIndex = selectedItemIndex;
        } else {
            this.appearanceMode = 0;
            this.contentWidth = this.isLayoutExpand() ? lineWidth + completeArrowWidth : this.paddingHorizontal + completeArrowWidth;
        }
        this.contentHeight = selectedItemHeight > height ? selectedItemHeight : height;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int startX;
        int modifiedX = x;
        modifiedX += this.arrowWidth + this.paddingHorizontal;
        leftBorder += this.arrowWidth + this.paddingHorizontal;
        rightBorder -= this.arrowWidth + this.paddingHorizontal;
        if (this.currentItem != null) {
            this.currentItem.paint(modifiedX, y, leftBorder, rightBorder, g);
        }
        g.setColor(this.arrowColor);
        if (this.currentItemIndex > 0) {
            startX = x + this.leftArrowStartX;
            if (startX >= rightBorder) {
                startX = rightBorder - (this.arrowWidth << 1);
            }
            g.fillTriangle(startX, y + this.contentHeight / 2, startX + this.arrowWidth, y, startX + this.arrowWidth, y + this.contentHeight);
        }
        if (this.currentItemIndex < this.parentContainer.size() - 1) {
            startX = x + this.rightArrowStartX;
            if (startX >= rightBorder) {
                startX = rightBorder;
            }
            g.fillTriangle(startX + this.arrowWidth, y + this.contentHeight / 2, startX, y, startX, y + this.contentHeight);
        }
    }

    protected Item getNextItem(int keyCode, int gameAction) {
        ChoiceGroup choiceGroup = (ChoiceGroup)this.parentContainer;
        Item[] items = this.parentContainer.getItems();
        if (this.currentItem == null) {
            Debug.debug("warn", "de.enough.polish.ui.containerviews.ExclusiveSingleLineView", 411, "ExclusiveSingleLineView: getNextItem(): no current item defined, it seems the initContent() has been skipped.");
            this.currentItemIndex = choiceGroup.getSelectedIndex();
            this.currentItem = (ChoiceItem)items[this.currentItemIndex];
        }
        ChoiceItem lastItem = this.currentItem;
        if (gameAction == 2 && this.currentItemIndex > 0) {
            this.currentItem.select(false);
            --this.currentItemIndex;
            this.currentItem = (ChoiceItem)items[this.currentItemIndex];
            this.currentItem.adjustProperties(lastItem);
            choiceGroup.setSelectedIndex(this.currentItemIndex, true);
            choiceGroup.notifyStateChanged();
            return this.currentItem;
        }
        if (gameAction == 5 && this.currentItemIndex < items.length - 1) {
            this.currentItem.select(false);
            ++this.currentItemIndex;
            this.currentItem = (ChoiceItem)items[this.currentItemIndex];
            this.currentItem.adjustProperties(lastItem);
            choiceGroup.setSelectedIndex(this.currentItemIndex, true);
            choiceGroup.notifyStateChanged();
            return this.currentItem;
        }
        return null;
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof ChoiceGroup;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.allowRoundTrip = dataInputStream.readBoolean();
        this.arrowColor = dataInputStream.readInt();
        this.arrowWidth = dataInputStream.readInt();
        this.currentItemIndex = dataInputStream.readInt();
        this.leftArrowEndX = dataInputStream.readInt();
        this.leftArrowStartX = dataInputStream.readInt();
        this.rightArrowEndX = dataInputStream.readInt();
        this.rightArrowStartX = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.allowRoundTrip);
        dataOutputStream.writeInt(this.arrowColor);
        dataOutputStream.writeInt(this.arrowWidth);
        dataOutputStream.writeInt(this.currentItemIndex);
        dataOutputStream.writeInt(this.leftArrowEndX);
        dataOutputStream.writeInt(this.leftArrowStartX);
        dataOutputStream.writeInt(this.rightArrowEndX);
        dataOutputStream.writeInt(this.rightArrowStartX);
    }
}

