/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.util.ArrayList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class MIDP2LayoutView
extends ContainerView {
    private static final int LAYOUT_HORIZONTAL = 3;
    private static final int LAYOUT_VERTICAL = 48;
    private ArrayList allRows;
    private ArrayList currentRow;
    private int rowWidth;
    private int rowHeight;
    private int horizontalOffset = -1;
    private int currentContentHeight;
    private boolean isExpandRightLayout;

    protected void initContent(Item parent, int firstLineWidth, int lineWidth) {
        Container parContainer;
        this.parentContainer = parContainer = (Container)parent;
        Item[] myItems = parContainer.getItems();
        this.allowCycling = parContainer.allowCycling;
        if (parent.getParent() instanceof Container && ((Container)parent.getParent()).getItems().length > 1) {
            this.allowCycling = false;
        }
        this.rowHeight = 0;
        this.rowWidth = 0;
        this.contentWidth = 0;
        this.contentHeight = 0;
        this.currentRow = new ArrayList();
        this.allRows = new ArrayList();
        boolean hasFocusableItem = false;
        this.currentContentHeight = 0;
        for (int i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            this.appendItemToRow(i, item, firstLineWidth, lineWidth);
            if (item.appearanceMode == 0) continue;
            hasFocusableItem = true;
        }
        this.rowBreak(lineWidth, 0);
        this.appearanceMode = hasFocusableItem ? 3 : 0;
        this.isExpandRightLayout = (parent.getLayout() & 2) == 2 && (parent.getLayout() & 0x800) == 2048;
    }

    void appendItemToRow(int index, Item item, int firstLineWidth, int lineWidth) {
        boolean isExpand;
        int itemLayout = item.getLayout();
        boolean bl = isExpand = (itemLayout & 0x800) == 2048;
        if (isExpand) {
            item.setLayout(itemLayout ^ 0x800);
        }
        item.getItemWidth(firstLineWidth, lineWidth);
        if (this.focusFirstElement && item.appearanceMode != 0) {
            this.focusItem(index, item);
            this.focusFirstElement = false;
        }
        int width = item.getItemWidth(firstLineWidth, lineWidth);
        int height = item.getItemHeight(firstLineWidth, lineWidth);
        if (isExpand) {
            item.setLayout(itemLayout);
        }
        if (256 == (itemLayout & 0x100) || this.rowWidth + this.paddingHorizontal + width > lineWidth) {
            this.rowBreak(lineWidth, itemLayout);
        }
        this.rowWidth += width;
        if (this.currentRow.size() == 0) {
            this.rowHeight = height;
        } else {
            if (this.rowHeight < height) {
                this.rowHeight = height;
            }
            this.rowWidth += this.paddingHorizontal;
        }
        this.currentRow.add(item);
        if (512 == (itemLayout & 0x200) || isExpand) {
            this.rowBreak(lineWidth, itemLayout);
        }
    }

    private void rowBreak(int lineWidth, int itemLayout) {
        if (this.currentRow.size() == 0) {
            return;
        }
        int remainingWidth = lineWidth - (this.currentRow.size() - 1) * this.paddingHorizontal;
        int top = this.currentContentHeight;
        this.currentContentHeight += this.rowHeight + this.paddingVertical;
        int currentWidth = 0;
        for (int i = 0; i < this.currentRow.size(); ++i) {
            Item rowItem = (Item)this.currentRow.get(i);
            rowItem.relativeY = top;
            rowItem.relativeX = currentWidth;
            if (2048 == (rowItem.getLayout() & 0x800)) {
                int availableWidth = lineWidth - this.rowWidth + rowItem.itemWidth;
                rowItem.getItemWidth(availableWidth, availableWidth);
            }
            currentWidth += rowItem.itemWidth;
            remainingWidth -= rowItem.itemWidth;
        }
        Item rowItem = (Item)this.currentRow.get(0);
        int rowHorizontalLayout = itemLayout & 3;
        int x = 0;
        switch (rowHorizontalLayout) {
            case 3: {
                x = remainingWidth >> 1;
                break;
            }
            case 2: {
                x = remainingWidth;
            }
        }
        block9: for (int i = 0; i < this.currentRow.size(); ++i) {
            rowItem = (Item)this.currentRow.get(i);
            rowItem.relativeX = x;
            x += rowItem.itemWidth + this.paddingHorizontal;
            if (8192 != (itemLayout & 0x2000)) continue;
            rowItem.relativeY = this.contentHeight;
            if (8192 == (itemLayout & 0x2000)) continue;
            switch (itemLayout &= 0x30) {
                case 48: {
                    rowItem.relativeY += this.rowHeight - rowItem.itemHeight >> 1;
                    continue block9;
                }
                case 32: {
                    rowItem.relativeY += this.rowHeight - rowItem.itemHeight;
                }
            }
        }
        this.contentHeight = this.allRows.size() == 0 ? (this.contentHeight += this.rowHeight) : (this.contentHeight += this.paddingVertical + this.rowHeight);
        if (this.rowWidth > this.contentWidth) {
            this.contentWidth = this.rowWidth;
        }
        this.allRows.add(this.currentRow);
        this.rowHeight = 0;
        this.rowWidth = 0;
        this.currentRow = new ArrayList();
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.isExpandRightLayout) {
            x = rightBorder - this.contentWidth;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        for (int i = 0; i < this.allRows.size(); ++i) {
            ArrayList row = (ArrayList)this.allRows.get(i);
            for (int j = 0; j < row.size(); ++j) {
                Item rowItem = (Item)row.get(j);
                int xItem = x + rowItem.relativeX;
                if (rowItem.itemWidth == 0) continue;
                this.paintItem(rowItem, i, xItem, y + rowItem.relativeY, Math.max(leftBorder, xItem), Math.min(rightBorder, xItem + rowItem.itemWidth), clipX, clipY, clipWidth, clipHeight, g);
            }
        }
    }

    protected Item getNextItem(int keyCode, int gameAction) {
        Item item;
        block21: {
            Item[] items;
            block22: {
                if (this.allRows.size() == 0) {
                    return null;
                }
                items = this.parentContainer.getItems();
                if (this.focusedIndex >= items.length || this.focusedIndex == -1) {
                    for (int i = 0; i < items.length; ++i) {
                        if (items[i].appearanceMode == 0) continue;
                        this.focusItem(i, items[i], gameAction);
                        return items[i];
                    }
                    return null;
                }
                Item focItem = items[this.focusedIndex];
                int rowIndex = 0;
                int xOffset = 0;
                block1: for (int i = 0; i < this.allRows.size(); ++i) {
                    ArrayList row = (ArrayList)this.allRows.get(i);
                    for (int j = 0; j < row.size(); ++j) {
                        Item rowItem = (Item)row.get(j);
                        if (rowItem != focItem) continue;
                        rowIndex = i;
                        xOffset = rowItem.relativeX + (rowItem.itemWidth >> 1);
                        i = 10000;
                        continue block1;
                    }
                }
                item = null;
                if (gameAction == 1 && keyCode != 50) {
                    if (this.horizontalOffset == -1) {
                        this.horizontalOffset = xOffset;
                    }
                    while (rowIndex > 0 && (item = this.getItemByHorizontalOffset((ArrayList)this.allRows.get(--rowIndex), this.horizontalOffset)) == null) {
                    }
                    if (item == null) {
                        // empty if block
                    }
                } else if (gameAction == 6 && keyCode != 56) {
                    if (this.horizontalOffset == -1) {
                        this.horizontalOffset = xOffset;
                    }
                    while (rowIndex < this.allRows.size() - 1 && (item = this.getItemByHorizontalOffset((ArrayList)this.allRows.get(++rowIndex), this.horizontalOffset)) == null) {
                    }
                    if (item == null) {
                        // empty if block
                    }
                } else if (gameAction == 5 && keyCode != 54) {
                    this.horizontalOffset = -1;
                    item = this.getNextFocusableItem(items, true, 1, false);
                } else if (gameAction == 2 && keyCode != 52) {
                    this.horizontalOffset = -1;
                    item = this.getNextFocusableItem(items, false, 1, false);
                }
                if (item == null) break block22;
                Screen screen = this.getScreen();
                if (screen != null && focItem != null && (gameAction == 6 || gameAction == 5) && item.relativeY - focItem.relativeY + (focItem.relativeY + this.parentContainer.getRelativeScrollYOffset()) > screen.getScreenContentHeight()) {
                    return null;
                }
                for (int i = 0; i < items.length; ++i) {
                    if (items[i] != item) continue;
                    this.focusItem(i, item, gameAction);
                    break block21;
                }
                break block21;
            }
            if (this.focusedIndex < items.length) break block21;
            for (int i = 0; i < items.length; ++i) {
                Item toBeFocused = items[i];
                if (toBeFocused.appearanceMode == 0) continue;
                this.focusItem(i, toBeFocused, gameAction);
                return toBeFocused;
            }
        }
        return item;
    }

    private Item getItemByHorizontalOffset(ArrayList row, int xOffset) {
        Item item = null;
        Item rowItem = null;
        int distance = 60000;
        int itemOffset = 0;
        int itemDistance = 0;
        for (int i = 0; i < row.size(); ++i) {
            rowItem = (Item)row.get(i);
            if (rowItem.appearanceMode == 0) continue;
            itemOffset = rowItem.relativeX + (rowItem.itemWidth >> 1);
            itemDistance = xOffset - itemOffset;
            if (itemDistance < 0) {
                itemDistance = -itemDistance;
            }
            if (itemDistance >= distance) continue;
            distance = itemDistance;
            item = rowItem;
        }
        return item;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.allRows = (ArrayList)Serializer.deserialize(dataInputStream);
        this.currentContentHeight = dataInputStream.readInt();
        this.currentRow = (ArrayList)Serializer.deserialize(dataInputStream);
        this.horizontalOffset = dataInputStream.readInt();
        this.isExpandRightLayout = dataInputStream.readBoolean();
        this.rowHeight = dataInputStream.readInt();
        this.rowWidth = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.allRows, dataOutputStream);
        dataOutputStream.writeInt(this.currentContentHeight);
        Serializer.serialize(this.currentRow, dataOutputStream);
        dataOutputStream.writeInt(this.horizontalOffset);
        dataOutputStream.writeBoolean(this.isExpandRightLayout);
        dataOutputStream.writeInt(this.rowHeight);
        dataOutputStream.writeInt(this.rowWidth);
    }
}

