/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ScrollBar;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class ScrollContainerView
extends ContainerView {
    private int height = -50;
    private transient ScrollBar scrollBar = new ScrollBar(StyleSheet.scrollbarStyle);
    private boolean showVerticalScrollBar;

    protected void initContent(Item p, int firstLineWidth, int lineWidth) {
        Container parent = (Container)p;
        int sWidth = this.scrollBar.getItemWidth(firstLineWidth, lineWidth);
        super.initContent(p, firstLineWidth -= sWidth, lineWidth -= sWidth);
        this.showVerticalScrollBar = false;
        if (this.height != Integer.MIN_VALUE) {
            int availHeight = parent.getScreen() != null ? parent.getScreen().getAvailableHeight() : 300;
            int h = this.height >= 0 ? this.height : this.height * availHeight / -100;
            this.showVerticalScrollBar = this.contentHeight > h;
            this.scrollBar.initScrollBar(lineWidth, h, this.contentHeight, parent.getScrollYOffset(), parent.getInternalY(), parent.getInternalHeight(), this.focusedIndex, parent.size());
            if (this.showVerticalScrollBar) {
                this.contentHeight = h;
                parent.setScrollHeight(h);
            }
            this.scrollBar.relativeX = lineWidth - sWidth;
        }
    }

    protected void paintContent(Item p, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        super.paintContent(p, x, y, leftBorder, rightBorder, g);
        if (!this.showVerticalScrollBar) {
            return;
        }
        Container parent = (Container)p;
        int realY = y - parent.getCurrentScrollYOffset();
        this.scrollBar.paint(x + this.scrollBar.relativeX, realY + this.scrollBar.relativeY, x + this.scrollBar.relativeX, rightBorder, g);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.height = dataInputStream.readInt();
        this.showVerticalScrollBar = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.height);
        dataOutputStream.writeBoolean(this.showVerticalScrollBar);
    }
}

