/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class SpringContainerView
extends ContainerView {
    private int minSpeed = 2;
    private int maxSpeed = -1;
    private int[] targetYPositions;

    public boolean animate() {
        boolean animated = super.animate();
        if (this.targetYPositions != null) {
            Item[] myItems = this.parentContainer.getItems();
            for (int i = 0; i < this.targetYPositions.length; ++i) {
                int target = this.targetYPositions[i];
                Item item = myItems[i];
                int current = item.relativeY;
                if (current == target) continue;
                animated = true;
                this.targetYPositions[i] = this.calculateCurrent(target, current);
            }
        }
        return animated;
    }

    private int calculateCurrent(int current, int target) {
        int speed = Math.max(this.minSpeed, Math.abs(current - target) / 3);
        if (this.maxSpeed != -1 && speed > this.maxSpeed) {
            speed = this.maxSpeed;
        }
        if (current < target) {
            if ((current += speed) > target) {
                current = target;
            }
        } else if ((current -= speed) < target) {
            current = target;
        }
        return current;
    }

    protected void initContent(Item parentContainerItem, int firstLineWidth, int lineWidth) {
        super.initContent(parentContainerItem, firstLineWidth, lineWidth);
        if (this.restartAnimation && this.focusedItem != null) {
            this.setTargets(this.focusedItem.relativeX, this.focusedItem.relativeY, this.parentContainer.getItems());
        }
    }

    private void setTargets(int startX, int startY, Item[] myItems) {
        int[] targetY = this.targetYPositions == null || this.targetYPositions.length != myItems.length ? new int[myItems.length] : this.targetYPositions;
        for (int i = 0; i < targetY.length; ++i) {
            targetY[i] = startY;
        }
        this.targetYPositions = targetY;
        this.restartAnimation = false;
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        if (this.restartAnimation && this.focusedItem != null) {
            this.setTargets(this.focusedItem.relativeX, this.focusedItem.relativeY, this.parentContainer.getItems());
        }
        super.paintContent(container, myItems, x, y, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
    }

    protected void paintItem(Item item, int index, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        if (this.targetYPositions != null) {
            y = this.targetYPositions[index] + y - item.relativeY;
        }
        super.paintItem(item, index, x, y, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.maxSpeed = dataInputStream.readInt();
        this.minSpeed = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.targetYPositions = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.targetYPositions[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.maxSpeed);
        dataOutputStream.writeInt(this.minSpeed);
        if (this.targetYPositions == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.targetYPositions.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.targetYPositions[n2]);
                ++n2;
            }
        }
    }
}

