/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.gaugeviews;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class HorizontalSpheresGaugeView
extends ItemView {
    private int sphereCount = 8;
    private int sphereColor = 0xFFFFFF;
    private int sphereHighlightCount = 3;
    private int sphereHighlightColor = 0xAAAAAA;
    private int sphereHighlightCenterColor = 0;
    private int sphereHighlightIndex = 0;
    private int sphereHighlightCenterIndex = -1;
    private int sphereHighlightCenterSpan = -1;
    private int sphereWidth = 0;
    private boolean isContinuousRunning;
    private int maxSpheres;
    private transient Gauge gauge;
    private long lastAnimationTime;
    private long interval = 0L;
    private boolean nextHighlight = false;

    protected void initContent(Item parent, int firstLineWidth, int lineWidth) {
        this.gauge = (Gauge)parent;
        boolean bl = this.isContinuousRunning = this.gauge.getMaxValue() == -1 && this.gauge.getValue() == 2;
        if (!this.isContinuousRunning) {
            this.maxSpheres = this.sphereCount - this.sphereHighlightCount;
        }
        this.contentWidth = lineWidth;
        if (this.sphereWidth == 0) {
            this.sphereWidth = (this.contentWidth - this.paddingHorizontal) / this.sphereCount;
        }
        this.contentHeight = this.sphereWidth;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        if (this.isContinuousRunning && currentTime - this.lastAnimationTime > this.interval) {
            this.nextHighlight = true;
            this.sphereHighlightIndex %= this.sphereCount;
            this.lastAnimationTime = currentTime;
            this.addFullRepaintRegion(this.parentItem, repaintRegion);
        }
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.nextHighlight) {
            ++this.sphereHighlightIndex;
            this.nextHighlight = false;
        }
        if (!this.isContinuousRunning) {
            this.sphereHighlightIndex = this.gauge.getValue() * 100 / this.gauge.getMaxValue() * this.maxSpheres / 100;
        }
        int stepX = this.contentWidth / this.sphereCount;
        int offsetX = 0;
        for (int i = 0; i < this.sphereCount; ++i) {
            this.setSphereColor(g, i);
            offsetX = stepX * i;
            g.fillArc(x + offsetX, y, this.sphereWidth, this.sphereWidth, 0, 360);
        }
    }

    private void setSphereColor(Graphics g, int i) {
        int startIndex = this.sphereHighlightIndex;
        int endIndex = (this.sphereHighlightIndex + this.sphereHighlightCount - 1) % this.sphereCount;
        if (startIndex <= endIndex) {
            if (i >= startIndex && i <= endIndex) {
                if (this.sphereHighlightCenterIndex != -1 && this.setCenterSphereColor(startIndex, g, i)) {
                    return;
                }
                g.setColor(this.sphereHighlightColor);
                return;
            }
        } else if (i >= startIndex || i <= endIndex) {
            if (this.sphereHighlightCenterIndex != -1 && this.setCenterSphereColor(startIndex, g, i)) {
                return;
            }
            g.setColor(this.sphereHighlightColor);
            return;
        }
        g.setColor(this.sphereColor);
    }

    public boolean setCenterSphereColor(int startIndex, Graphics g, int i) {
        int centerStartIndex = (startIndex + this.sphereHighlightCenterIndex) % this.sphereCount;
        int centerEndIndex = (startIndex + this.sphereHighlightCenterIndex + (this.sphereHighlightCenterSpan - 1)) % this.sphereCount;
        if (centerStartIndex <= centerEndIndex) {
            if (i >= centerStartIndex && i <= centerEndIndex) {
                g.setColor(this.sphereHighlightCenterColor);
                return true;
            }
        } else if (i >= centerStartIndex || i <= centerEndIndex) {
            g.setColor(this.sphereHighlightCenterColor);
            return true;
        }
        return false;
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof Gauge;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.interval = dataInputStream.readLong();
        this.isContinuousRunning = dataInputStream.readBoolean();
        this.lastAnimationTime = dataInputStream.readLong();
        this.maxSpheres = dataInputStream.readInt();
        this.nextHighlight = dataInputStream.readBoolean();
        this.sphereColor = dataInputStream.readInt();
        this.sphereCount = dataInputStream.readInt();
        this.sphereHighlightCenterColor = dataInputStream.readInt();
        this.sphereHighlightCenterIndex = dataInputStream.readInt();
        this.sphereHighlightCenterSpan = dataInputStream.readInt();
        this.sphereHighlightColor = dataInputStream.readInt();
        this.sphereHighlightCount = dataInputStream.readInt();
        this.sphereHighlightIndex = dataInputStream.readInt();
        this.sphereWidth = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeLong(this.interval);
        dataOutputStream.writeBoolean(this.isContinuousRunning);
        dataOutputStream.writeLong(this.lastAnimationTime);
        dataOutputStream.writeInt(this.maxSpheres);
        dataOutputStream.writeBoolean(this.nextHighlight);
        dataOutputStream.writeInt(this.sphereColor);
        dataOutputStream.writeInt(this.sphereCount);
        dataOutputStream.writeInt(this.sphereHighlightCenterColor);
        dataOutputStream.writeInt(this.sphereHighlightCenterIndex);
        dataOutputStream.writeInt(this.sphereHighlightCenterSpan);
        dataOutputStream.writeInt(this.sphereHighlightColor);
        dataOutputStream.writeInt(this.sphereHighlightCount);
        dataOutputStream.writeInt(this.sphereHighlightIndex);
        dataOutputStream.writeInt(this.sphereWidth);
    }
}

