/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.gaugeviews;

import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class RecLineGaugeView
extends ItemView {
    private int width = 5;
    private int height = 5;
    private int number = 4;
    private int selectedColor = 0xFF00FF;
    private int unSelectedColor = 0xFFFFFF;
    private int valuePosition = 0;
    private long animationInterval = 300L;
    private long lastAnimationTime;

    public boolean animate() {
        long time;
        boolean animated = super.animate();
        Gauge gauge = (Gauge)this.parentItem;
        if (gauge.getMaxValue() == -1 && gauge.getValue() == 2 && (time = System.currentTimeMillis()) - this.lastAnimationTime >= this.animationInterval) {
            this.lastAnimationTime = time;
            int position = this.valuePosition + 1;
            if (position >= this.number) {
                position = 0;
            }
            this.valuePosition = position;
            animated = true;
        }
        return animated;
    }

    protected void initContent(Item parent, int firstLineWidth, int lineWidth) {
        this.contentWidth = (this.width + this.paddingHorizontal) * this.number - this.paddingHorizontal;
        this.contentHeight = this.height;
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        Gauge gauge = (Gauge)parent;
        int position = this.valuePosition;
        if (gauge.getMaxValue() != -1) {
            int valuePercent = gauge.getValue() * 100 / gauge.getMaxValue();
            position = valuePercent * this.number / 100;
        }
        for (int i = 0; i < this.number; ++i) {
            if (i == position) {
                g.setColor(this.selectedColor);
            } else {
                g.setColor(this.unSelectedColor);
            }
            int newX = x + this.paddingHorizontal * i;
            g.fillRect(newX + this.width * i, y, this.width, this.height);
        }
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof Gauge;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animationInterval = dataInputStream.readLong();
        this.height = dataInputStream.readInt();
        this.lastAnimationTime = dataInputStream.readLong();
        this.number = dataInputStream.readInt();
        this.selectedColor = dataInputStream.readInt();
        this.unSelectedColor = dataInputStream.readInt();
        this.valuePosition = dataInputStream.readInt();
        this.width = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeLong(this.animationInterval);
        dataOutputStream.writeInt(this.height);
        dataOutputStream.writeLong(this.lastAnimationTime);
        dataOutputStream.writeInt(this.number);
        dataOutputStream.writeInt(this.selectedColor);
        dataOutputStream.writeInt(this.unSelectedColor);
        dataOutputStream.writeInt(this.valuePosition);
        dataOutputStream.writeInt(this.width);
    }
}

