/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.rgbeffects;

import de.enough.polish.ui.RgbEffect;
import de.enough.polish.util.ImageUtil;
import de.enough.polish.util.RgbImage;

public class RotateRgbEffect
extends RgbEffect {
    private int angle;
    private int referencePointXPercent;
    private int referencePointYPercent;

    public RotateRgbEffect() {
        this(-45, 50, 50);
    }

    public RotateRgbEffect(int angle) {
        this(angle, 50, 50);
    }

    public RotateRgbEffect(int angle, int referencePointXPercent, int referencePointYPercent) {
        this.angle = angle;
        this.referencePointXPercent = referencePointXPercent;
        this.referencePointYPercent = referencePointYPercent;
    }

    public void renderEffect(RgbImage image) {
        int referenceX = image.getWidth() * this.referencePointXPercent / 100;
        int referenceY = image.getHeight() * this.referencePointYPercent / 100;
        ImageUtil.rotate(image, this.angle, referenceX, referenceY);
    }
}

