/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class CubeScreenChangeAnimation
extends ScreenChangeAnimation {
    private Graphics3D graphics3d;
    private Camera camera;
    private Light light;
    private float angle = 0.0f;
    private float angle2 = 0.0f;
    private Background background = new Background();
    private VertexBuffer vbuffer;
    private IndexBuffer indexbuffer;
    private Appearance appearance;
    private Material material = new Material();
    private float fHeight;
    private float fWidth;

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        int i;
        float wPercent = (float)width / 256.0f;
        float hPercent = (float)height / 256.0f;
        this.fWidth = 5.0f * wPercent;
        this.fHeight = 5.0f * hPercent;
        this.graphics3d = Graphics3D.getInstance();
        this.camera = new Camera();
        this.camera.setPerspective(90.0f, (float)this.getWidth() / (float)this.getHeight(), 0.1f, 200.0f);
        this.light = new Light();
        this.light.setColor(0xFFFFFF);
        this.light.setMode(128);
        this.light.setIntensity(2.25f);
        short[] vert = new short[]{5, 5, 5, -5, 5, 5, 5, -5, 5, -5, -5, 5, -5, 5, 5, -5, 5, -5, -5, -5, 5, -5, -5, -5};
        VertexArray vertArray = new VertexArray(vert.length / 3, 3, 2);
        vertArray.set(0, vert.length / 3, vert);
        int[] indices = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        int[] stripLen = new int[]{4, 4};
        byte[] norm = new byte[]{0, 0, 127, 0, 0, 127, 0, 0, 127, 0, 0, 127, -127, 0, 0, -127, 0, 0, -127, 0, 0, -127, 0, 0};
        VertexArray normArray = new VertexArray(norm.length / 3, 3, 1);
        normArray.set(0, norm.length / 3, norm);
        short[] tex = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 256, 256, 256};
        VertexArray texArray = new VertexArray(tex.length / 2, 2, 2);
        texArray.set(0, tex.length / 2, tex);
        short[] lsttex = new short[]{256, 0, 0, 0, 256, 256, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0};
        VertexArray lsttexArray = new VertexArray(tex.length / 2, 2, 2);
        lsttexArray.set(0, tex.length / 2, lsttex);
        VertexBuffer vb = this.vbuffer = new VertexBuffer();
        vb.setPositions(vertArray, 1.0f, null);
        vb.setNormals(normArray);
        vb.setTexCoords(0, lsttexArray, 0.00390625f, null);
        vb.setTexCoords(1, texArray, 0.00390625f, null);
        this.indexbuffer = new TriangleStripArray(indices, stripLen);
        int[] rgbData = new int[65536];
        int[] lstrgbData = new int[65536];
        int[] rgbbuffer = new int[nxtScreenImage.getWidth() * nxtScreenImage.getHeight()];
        int[] lstrgbbuffer = new int[lstScreenImage.getWidth() * lstScreenImage.getHeight()];
        nxtScreenImage.getRGB(rgbbuffer, 0, width, 0, 0, width, height);
        lstScreenImage.getRGB(lstrgbbuffer, 0, width, 0, 0, width, height);
        int row = 0;
        int rgbCount = 0;
        for (i = 0; i < rgbData.length; ++i) {
            if (row < width && rgbCount < rgbbuffer.length) {
                rgbData[i] = rgbbuffer[rgbCount];
                ++rgbCount;
            }
            row = (row + 1) % 256;
        }
        rgbCount = 0;
        row = 0;
        for (i = 0; i < lstrgbData.length; ++i) {
            if (row < width && rgbCount < lstrgbbuffer.length) {
                lstrgbData[i] = lstrgbbuffer[rgbCount];
                ++rgbCount;
            }
            row = (row + 1) % 256;
        }
        Image image = Image.createRGBImage((int[])rgbData, (int)256, (int)256, (boolean)false);
        Image lstImage = Image.createRGBImage((int[])lstrgbData, (int)256, (int)256, (boolean)false);
        Image2D image2D = new Image2D(99, (Object)image);
        Image2D lstImage2D = new Image2D(99, (Object)lstImage);
        Texture2D texture = new Texture2D(lstImage2D);
        Texture2D lsttexture = new Texture2D(image2D);
        texture.setFiltering(210, 210);
        texture.setWrapping(240, 240);
        texture.setBlending(227);
        this.appearance = new Appearance();
        this.appearance.setTexture(0, lsttexture);
        this.appearance.setTexture(1, texture);
        this.appearance.setMaterial(this.material);
        this.material.setVertexColorTrackingEnable(true);
        this.material.setColor(2048, -52);
        this.material.setColor(8192, -52);
        this.material.setShininess(100.0f);
        this.background.setColor(-52);
        super.show(style, dsplay, width, height, lstScreenImage, nxtScreenImage, nxtCanvas, nxtDisplayable, isForward);
    }

    protected boolean animate() {
        return true;
    }

    public void paintAnimation(Graphics g) {
        this.graphics3d.bindTarget((Object)g, true, 12);
        this.graphics3d.clear(this.background);
        Transform transform = new Transform();
        transform.postTranslate(-(this.fWidth / 2.0f), 0.78f, this.fHeight * this.fHeight / 2.0f);
        transform.postTranslate(-(this.fWidth / 2.0f), this.fHeight / 2.0f, this.fHeight * this.fHeight / 2.0f);
        this.graphics3d.setCamera(this.camera, transform);
        this.graphics3d.resetLights();
        this.graphics3d.addLight(this.light, transform);
        this.angle += 0.5f;
        this.angle2 += 0.2f;
        transform.setIdentity();
        transform.postTranslate(0.0f, 0.0f, 0.0f);
        this.graphics3d.render(this.vbuffer, this.indexbuffer, this.appearance, transform);
        this.graphics3d.render(this.vbuffer, this.indexbuffer, this.appearance, transform);
        this.graphics3d.releaseTarget();
    }
}

