/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DiagonalScreenChangeAnimation
extends ScreenChangeAnimation {
    private int currentX;
    private int currentY;

    protected void setStyle(Style style) {
        super.setStyle(style);
        if (this.isForwardAnimation) {
            this.currentX = 0;
            this.currentY = 0;
        } else {
            this.currentX = this.screenWidth;
            this.currentY = this.screenHeight;
        }
    }

    protected boolean animate() {
        if (this.isForwardAnimation) {
            if (this.currentY < this.screenHeight) {
                int adjust = (this.screenHeight - this.currentY) / 3;
                if (adjust < 3) {
                    adjust = 3;
                }
                this.currentY += adjust;
                this.currentX = this.currentY * this.screenWidth / this.screenHeight;
                return true;
            }
        } else if (this.currentY > 0) {
            int adjust = (this.screenHeight - this.currentY) / 3;
            if (adjust < 3) {
                adjust = 3;
            }
            this.currentY -= adjust;
            this.currentX = this.currentY * this.screenWidth / this.screenHeight;
            return true;
        }
        return false;
    }

    public void paintAnimation(Graphics g) {
        Image second;
        Image first;
        int y = 0;
        int x = 0;
        if (this.isForwardAnimation) {
            first = this.lastCanvasImage;
            second = this.nextCanvasImage;
        } else {
            first = this.nextCanvasImage;
            second = this.lastCanvasImage;
        }
        g.drawImage(first, x, y, 20);
        g.drawImage(second, this.screenWidth - this.currentX, this.screenHeight - this.currentY, 20);
    }
}

