/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DisplayScreenChangeAnimation
extends ScreenChangeAnimation {
    private Image image;
    private boolean stillRun = true;
    private int row = 0;
    private int[] rgbData;
    private int[] rgbbuffer;
    private int[] lstrgbbuffer;
    private int[] scaler;
    private int lstScale = 0;
    private int width;
    private int height;
    private boolean first = true;
    private boolean letsGo = false;

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        int size = nxtScreenImage.getWidth() * nxtScreenImage.getHeight();
        this.height = height;
        this.width = width;
        this.lstScale = width;
        this.scaler = new int[width];
        for (int i = 0; i < this.scaler.length; ++i) {
            this.scaler[i] = height;
        }
        this.rgbbuffer = new int[size];
        this.lstrgbbuffer = new int[size];
        this.rgbData = new int[size];
        nxtScreenImage.getRGB(this.rgbbuffer, 0, width, 0, 0, width, height);
        lstScreenImage.getRGB(this.lstrgbbuffer, 0, width, 0, 0, width, height);
        super.show(style, dsplay, width, height, lstScreenImage, nxtScreenImage, nxtCanvas, nxtDisplayable, isForward);
    }

    protected boolean animate() {
        int row = 0;
        int column = 5;
        for (int i = 0; i < this.rgbData.length; ++i) {
            this.rgbData[i] = row < this.row ? (this.scaler[row] < column || this.height - this.scaler[row] > column ? 0 : this.rgbbuffer[i]) : (this.scaler[row] < column || this.height - this.scaler[row] > column ? 0 : this.lstrgbbuffer[i]);
            row = (row + 1) % this.width;
            if (row != 0) continue;
            ++column;
        }
        --this.lstScale;
        this.cubeEffect();
        return this.stillRun;
    }

    private void cubeEffect() {
        for (int i = this.width - 1; i > this.lstScale; --i) {
            if (this.scaler[i] > this.height - 60) {
                int n = i;
                this.scaler[n] = this.scaler[n] - 1;
                continue;
            }
            this.scaler[i] = 0;
        }
    }

    public void paintAnimation(Graphics g) {
        g.drawRGB(this.rgbData, 0, this.width, 0, 0, this.width, this.height, false);
    }
}

