/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FadeScreenChangeAnimation
extends ScreenChangeAnimation {
    private int steps = 6;
    private int currentStep;
    private int[] nextCanvasRgb;

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        if (this.nextCanvasRgb == null) {
            this.nextCanvasRgb = new int[width * height];
        }
        nxtScreenImage.getRGB(this.nextCanvasRgb, 0, width, 0, 0, width, height);
        this.addOpacity(255 / this.steps, this.nextCanvasRgb);
        this.currentStep = 0;
        super.show(style, dsplay, width, height, lstScreenImage, nxtScreenImage, nxtCanvas, nxtDisplayable, isForward);
    }

    protected boolean animate() {
        ++this.currentStep;
        if (this.currentStep >= this.steps) {
            this.currentStep = 0;
            this.nextCanvasRgb = null;
            return false;
        }
        int opacity = 255 * this.currentStep / this.steps;
        this.addOpacity(opacity, this.nextCanvasRgb);
        return true;
    }

    private void addOpacity(int opacity, int[] data) {
        opacity = opacity << 24 | 0xFFFFFF;
        for (int i = 0; i < data.length; ++i) {
            data[i] = (data[i] | 0xFF000000) & opacity;
        }
    }

    public void paintAnimation(Graphics g) {
        g.drawImage(this.lastCanvasImage, 0, 0, 20);
        g.drawRGB(this.nextCanvasRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, true);
    }
}

