/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FlashScreenChangeAnimation
extends ScreenChangeAnimation {
    private int currentX;
    private int currentSize;

    protected void setStyle(Style style) {
        super.setStyle(style);
        if (this.isForwardAnimation) {
            this.currentX = this.screenWidth / 2;
            this.currentSize = 0;
        } else {
            this.currentX = 0;
            this.currentSize = this.screenWidth;
        }
    }

    protected boolean animate() {
        int adjust = this.currentX / 3;
        if (adjust < 2) {
            adjust = 2;
        }
        if (this.isForwardAnimation) {
            if (this.currentX > 0) {
                this.currentX -= adjust;
                this.currentSize += adjust << 1;
                return true;
            }
        } else if (this.currentSize > 0) {
            this.currentX += adjust;
            this.currentSize -= adjust << 1;
            return true;
        }
        return false;
    }

    public void paintAnimation(Graphics g) {
        Image second;
        Image first;
        if (this.isForwardAnimation) {
            first = this.lastCanvasImage;
            second = this.nextCanvasImage;
        } else {
            first = this.nextCanvasImage;
            second = this.lastCanvasImage;
        }
        g.drawImage(first, 0, 0, 20);
        g.setColor(0);
        g.drawLine(this.currentX - 1, 0, this.currentX - 1, this.screenHeight);
        g.drawLine(this.currentX + this.currentSize, 0, this.currentX + this.currentSize, this.screenHeight);
        g.setClip(this.currentX, 0, this.currentSize, this.screenHeight);
        g.drawImage(second, 0, 0, 20);
    }
}

