/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SqueezeScreenChangeAnimation
extends ScreenChangeAnimation {
    private int[] scaledRgb;
    private int currentStep;
    private int steps = 5;
    private int currentHeight;

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        if (isForward) {
            this.useLastCanvasRgb = true;
            this.useNextCanvasRgb = false;
            this.currentStep = 0;
        } else {
            this.useLastCanvasRgb = false;
            this.useNextCanvasRgb = true;
            this.currentStep = this.steps;
        }
        super.show(style, dsplay, width, height, lstScreenImage, nxtScreenImage, nxtCanvas, nxtDisplayable, isForward);
        this.scaledRgb = new int[width * height];
        this.animate();
    }

    protected boolean animate() {
        int h;
        int[] original;
        if (this.isForwardAnimation) {
            ++this.currentStep;
            if (this.currentStep >= this.steps) {
                this.scaledRgb = null;
                return false;
            }
            original = this.lastCanvasRgb;
        } else {
            --this.currentStep;
            if (this.currentStep <= 0) {
                this.scaledRgb = null;
                return false;
            }
            original = this.nextCanvasRgb;
        }
        this.currentHeight = h = this.screenHeight * (this.steps - this.currentStep) / this.steps;
        ImageUtil.scale(original, this.screenWidth, h, this.screenWidth, this.screenHeight, this.scaledRgb);
        return true;
    }

    protected void paintAnimation(Graphics g) {
        Image canvasImage = this.isForwardAnimation ? this.nextCanvasImage : this.lastCanvasImage;
        g.drawImage(canvasImage, 0, 0, 20);
        g.drawRGB(this.scaledRgb, 0, this.screenWidth, 0, this.screenHeight - this.currentHeight, this.screenWidth, this.currentHeight, false);
    }
}

