/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ZoomBothScreenChangeAnimation
extends ScreenChangeAnimation {
    private int outerScaleFactor = 260;
    private int innerScaleFactor = 460;
    private int steps = 6;
    private int currentStep;
    private int[] nextCanvasScaledRgb;
    private int[] lastCanvasScaledRgb;
    private int currentMagnifyFactor;

    public ZoomBothScreenChangeAnimation() {
        this.useLastCanvasRgb = true;
        this.useNextCanvasRgb = true;
    }

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        int size = width * height;
        this.lastCanvasScaledRgb = new int[size];
        this.nextCanvasScaledRgb = new int[size];
        super.show(style, dsplay, width, height, lstScreenImage, nxtScreenImage, nxtCanvas, nxtDisplayable, isForward);
        if (isForward) {
            this.currentStep = 0;
            System.arraycopy(this.lastCanvasRgb, 0, this.lastCanvasScaledRgb, 0, width * height);
        } else {
            this.currentStep = this.steps;
            this.animate();
        }
    }

    protected boolean animate() {
        int[] secondScaled;
        int[] second;
        int[] firstScaled;
        int[] first;
        if (this.isForwardAnimation) {
            ++this.currentStep;
            if (this.currentStep >= this.steps) {
                this.lastCanvasScaledRgb = null;
                this.nextCanvasScaledRgb = null;
                return false;
            }
            first = this.lastCanvasRgb;
            firstScaled = this.lastCanvasScaledRgb;
            second = this.nextCanvasRgb;
            secondScaled = this.nextCanvasScaledRgb;
        } else {
            --this.currentStep;
            if (this.currentStep <= 0) {
                this.lastCanvasScaledRgb = null;
                this.nextCanvasScaledRgb = null;
                return false;
            }
            first = this.nextCanvasRgb;
            firstScaled = this.nextCanvasScaledRgb;
            second = this.lastCanvasRgb;
            secondScaled = this.lastCanvasScaledRgb;
        }
        int magnifyFactor = 100 + (this.outerScaleFactor - 100) * this.currentStep / this.steps;
        ImageUtil.scale(magnifyFactor, this.screenWidth, this.screenHeight, first, firstScaled);
        magnifyFactor = (100 + (this.innerScaleFactor - 100) * this.currentStep / this.steps) * 100 / this.innerScaleFactor;
        int opacity = magnifyFactor * 255 / 100;
        this.currentMagnifyFactor = magnifyFactor;
        ImageUtil.scale(opacity, magnifyFactor, this.screenWidth, this.screenHeight, second, secondScaled);
        return true;
    }

    public void paintAnimation(Graphics g) {
        int[] second;
        int[] first;
        if (this.isForwardAnimation) {
            first = this.lastCanvasScaledRgb;
            second = this.nextCanvasScaledRgb;
        } else {
            first = this.nextCanvasScaledRgb;
            second = this.lastCanvasScaledRgb;
        }
        g.drawRGB(first, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, true);
        if (!this.isForwardAnimation) {
            int w = this.screenWidth * this.currentMagnifyFactor / 100;
            int h = this.screenHeight * this.currentMagnifyFactor / 100;
            g.setClip((this.screenWidth >> 1) - (w >> 1), (this.screenHeight >> 1) - (h >> 1), w, h);
        }
        g.drawRGB(second, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, true);
    }
}

