/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ZoomInAndHideScreenChangeAnimation
extends ScreenChangeAnimation {
    private int scaleFactor = 260;
    private int steps = 10;
    private int currentStep;
    private int[] scaledScreenRgb;

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        if (isForward) {
            this.useLastCanvasRgb = true;
            this.useNextCanvasRgb = false;
            this.currentStep = 0;
        } else {
            this.useLastCanvasRgb = false;
            this.useNextCanvasRgb = true;
            this.currentStep = this.steps;
        }
        super.show(style, dsplay, width, height, lstScreenImage, nxtScreenImage, nxtCanvas, nxtDisplayable, isForward);
        this.scaledScreenRgb = new int[width * height];
        if (isForward) {
            System.arraycopy(this.lastCanvasRgb, 0, this.scaledScreenRgb, 0, width * height);
        } else {
            this.animate();
        }
    }

    protected boolean animate() {
        int[] rgb;
        if (this.isForwardAnimation) {
            ++this.currentStep;
            if (this.currentStep >= this.steps) {
                this.scaledScreenRgb = null;
                return false;
            }
            rgb = this.lastCanvasRgb;
        } else {
            --this.currentStep;
            if (this.currentStep <= 0) {
                this.scaledScreenRgb = null;
                return false;
            }
            rgb = this.nextCanvasRgb;
        }
        int factor = 100 + (this.scaleFactor - 100) * this.currentStep / this.steps;
        int opacity = 255 * (this.steps - this.currentStep) / this.steps;
        ImageUtil.scale(opacity, factor, this.screenWidth, this.screenHeight, rgb, this.scaledScreenRgb);
        return true;
    }

    public void paintAnimation(Graphics g) {
        Image canvasImage = this.isForwardAnimation ? this.nextCanvasImage : this.lastCanvasImage;
        g.drawImage(canvasImage, 0, 0, 20);
        g.drawRGB(this.scaledScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, true);
    }
}

