/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.ImageUtil;
import de.enough.polish.util.RgbImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class RotateTextEffect
extends TextEffect {
    private String lastText;
    private int angle = 10;
    private transient RgbImage rotatedImage;
    private int xPos;
    private int yPos;

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        if (text != this.lastText) {
            Font font = g.getFont();
            this.rotatedImage = RotateTextEffect.rotate(text, textColor, font, this.angle);
            this.lastText = text;
            this.xPos = this.getLeftX(x, orientation, this.rotatedImage.getWidth());
            this.yPos = this.getTopY(y, orientation, this.rotatedImage.getHeight(), font.getBaselinePosition() * this.rotatedImage.getHeight() / font.getHeight());
        }
        this.rotatedImage.paint(this.xPos, this.yPos, g);
    }

    public static RgbImage rotate(String text, int textColor, Font font, int angle) {
        int[] rgbData = RotateTextEffect.getRgbData(text, textColor, font);
        int height = font.getHeight();
        int width = rgbData.length / height;
        int referenceX = width / 2;
        int referenceY = height / 2;
        RgbImage image = new RgbImage(rgbData, width, true);
        ImageUtil.rotate(image, angle, referenceX, referenceY);
        return image;
    }

    public void releaseResources() {
        super.releaseResources();
        this.lastText = null;
        this.rotatedImage = null;
    }

    public void setAngle(int angle) {
        this.releaseResources();
        this.angle = angle;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.angle = dataInputStream.readInt();
        this.lastText = (String)Serializer.deserialize(dataInputStream);
        this.xPos = dataInputStream.readInt();
        this.yPos = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.angle);
        Serializer.serialize(this.lastText, dataOutputStream);
        dataOutputStream.writeInt(this.xPos);
        dataOutputStream.writeInt(this.yPos);
    }
}

