/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SmileyTextEffect
extends TextEffect {
    public static Smiley[] smileyList = null;
    protected Hashtable smileyMap;
    protected String currentSmiley;
    private int smileyWidth;
    private int smileyHeight;
    private boolean isInitialized;

    public SmileyTextEffect() {
        smileyList = new Smiley[0];
    }

    protected void init() {
        this.smileyMap = new Hashtable();
        this.smileyWidth = SmileyTextEffect.smileyList[0].image.getWidth();
        this.smileyHeight = SmileyTextEffect.smileyList[0].image.getHeight();
        for (int i = 0; i < smileyList.length; ++i) {
            Smiley smiley = smileyList[i];
            for (int j = 0; j < smiley.smileys.length; ++j) {
                this.smileyMap.put(smiley.smileys[j], smiley.image);
            }
        }
        this.isInitialized = true;
    }

    public int stringWidth(String str) {
        if (!this.isInitialized) {
            this.init();
        }
        int position = 0;
        int stringWidth = 0;
        while (str.length() > 0) {
            position = this.getSmiley(str);
            String linePart = str.substring(0, position);
            stringWidth += super.stringWidth(linePart);
            if (this.currentSmiley != null) {
                stringWidth += this.smileyWidth;
                position += this.currentSmiley.length();
            }
            str = str.substring(position, str.length());
        }
        return stringWidth;
    }

    public int getFontHeight() {
        int fontHeight;
        if (!this.isInitialized) {
            this.init();
        }
        if ((fontHeight = super.getFontHeight()) > this.smileyHeight) {
            return fontHeight;
        }
        return this.smileyHeight;
    }

    public String[] wrap(String text, Font font, int firstLineWidth, int lineWidth) {
        if (!this.isInitialized) {
            this.init();
        }
        if (firstLineWidth <= 0 || lineWidth <= 0) {
            Debug.debug("error", "de.enough.polish.ui.texteffects.SmileyTextEffect", 188, "INVALID LINE WIDTH FOR SPLITTING " + firstLineWidth + " / " + lineWidth + " ( for string " + text + ")");
            new RuntimeException().printStackTrace();
            return new String[]{text};
        }
        boolean hasLineBreaks = text.indexOf(10) != -1;
        int completeWidth = this.stringWidth(text);
        if (completeWidth <= firstLineWidth && !hasLineBreaks) {
            return new String[]{text};
        }
        ArrayList lines = new ArrayList();
        if (!hasLineBreaks) {
            this.wrap(text, font, completeWidth, firstLineWidth, lineWidth, lines);
        } else {
            char[] valueChars = text.toCharArray();
            int lastIndex = 0;
            int c = 32;
            for (int i = 0; i < valueChars.length; ++i) {
                c = valueChars[i];
                if (c != 10 && i != valueChars.length - 1) continue;
                String line = null;
                line = i == valueChars.length - 1 ? new String(valueChars, lastIndex, i + 1 - lastIndex) : new String(valueChars, lastIndex, i - lastIndex);
                completeWidth = this.stringWidth(line);
                if (completeWidth <= firstLineWidth) {
                    lines.add(line);
                } else {
                    this.wrap(line, font, completeWidth, firstLineWidth, lineWidth, lines);
                }
                lastIndex = i + 1;
                firstLineWidth = lineWidth;
            }
            if (c == 10) {
                lines.add("");
            }
        }
        return (String[])lines.toArray(new String[lines.size()]);
    }

    public void wrap(String value, Font font, int completeWidth, int firstLineWidth, int lineWidth, ArrayList list) {
        if (!this.isInitialized) {
            this.init();
        }
        char[] valueChars = value.toCharArray();
        int startPos = 0;
        int lastSpacePos = -1;
        int lastSpacePosLength = 0;
        int currentLineWidth = 0;
        for (int i = 0; i < valueChars.length; ++i) {
            char c = valueChars[i];
            String smiley = this.isSmileyNext(valueChars, i);
            if (smiley == null) {
                currentLineWidth += font.charWidth(c);
            } else {
                Image img = (Image)this.smileyMap.get(smiley);
                currentLineWidth += img.getWidth();
                i += smiley.length() - 1;
            }
            if (c == '\n') {
                list.add(new String(valueChars, startPos, i - startPos));
                lastSpacePos = -1;
                startPos = i + 1;
                currentLineWidth = 0;
                firstLineWidth = lineWidth;
                i = startPos;
                continue;
            }
            if (currentLineWidth >= firstLineWidth && i > 0) {
                if (lastSpacePos == -1) {
                    list.add(new String(valueChars, startPos, --i - startPos));
                    startPos = i;
                    currentLineWidth = 0;
                } else {
                    currentLineWidth -= lastSpacePosLength;
                    list.add(new String(valueChars, startPos, lastSpacePos - startPos));
                    startPos = lastSpacePos + 1;
                    lastSpacePos = -1;
                }
                firstLineWidth = lineWidth;
                continue;
            }
            if (c != ' ' && c != '\t') continue;
            lastSpacePos = i;
            lastSpacePosLength = currentLineWidth;
        }
        list.add(new String(valueChars, startPos, valueChars.length - startPos));
    }

    private String isSmileyNext(char[] chars, int offset) {
        String smiley;
        Enumeration smileys = this.smileyMap.keys();
        while (smileys.hasMoreElements()) {
            smiley = (String)smileys.nextElement();
        }
        while (smileys.hasMoreElements()) {
            smiley = (String)smileys.nextElement();
            if (offset + smiley.length() > chars.length) continue;
            boolean isSmiley = true;
            for (int j = 0; j < smiley.length(); ++j) {
                if (chars[offset + j] == smiley.charAt(j)) continue;
                isSmiley = false;
                break;
            }
            if (!isSmiley) continue;
            return smiley;
        }
        return null;
    }

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        if (!this.isInitialized) {
            this.init();
        }
        int position = 0;
        int offset = 0;
        while (text.length() > 0) {
            position = this.getSmiley(text);
            String linePart = text.substring(0, position);
            g.drawString(linePart, x + offset, y, orientation);
            if (this.currentSmiley != null) {
                Image img = (Image)this.smileyMap.get(this.currentSmiley);
                g.drawImage(img, x + (offset += super.stringWidth(linePart)), y, orientation);
                offset += this.smileyWidth;
                position += this.currentSmiley.length();
            }
            text = text.substring(position, text.length());
        }
    }

    protected int getSmiley(String line) {
        Enumeration smileys = this.smileyMap.keys();
        int first = line.length();
        this.currentSmiley = null;
        while (smileys.hasMoreElements()) {
            String smiley = (String)smileys.nextElement();
            int position = 0;
            position = line.indexOf(smiley);
            if (position <= -1 || first <= position) continue;
            first = position;
            this.currentSmiley = smiley;
        }
        return first;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.currentSmiley = (String)Serializer.deserialize(dataInputStream);
        this.isInitialized = dataInputStream.readBoolean();
        this.smileyHeight = dataInputStream.readInt();
        this.smileyMap = (Hashtable)Serializer.deserialize(dataInputStream);
        this.smileyWidth = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.currentSmiley, dataOutputStream);
        dataOutputStream.writeBoolean(this.isInitialized);
        dataOutputStream.writeInt(this.smileyHeight);
        Serializer.serialize(this.smileyMap, dataOutputStream);
        dataOutputStream.writeInt(this.smileyWidth);
    }

    public class Smiley {
        public String[] smileys;
        public Image image;
        public String description;

        public Smiley(String[] smileys, String imageUrl) {
            this(smileys, imageUrl, null);
        }

        public Smiley(String[] smileys, String imageUrl, String description) {
            this.smileys = smileys;
            try {
                this.image = Image.createImage((String)imageUrl);
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.ui.texteffects.SmileyTextEffect", 86, (Object)"unable to load smiley image ", e);
            }
            this.description = description;
        }
    }
}

