/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class VerticalGradientTextEffect
extends TextEffect {
    private int[] colors;
    private String lastText;
    private Image nokiaImageBuffer;
    private boolean useTransparency;

    public VerticalGradientTextEffect() {
    }

    public VerticalGradientTextEffect(int startColor, int endColor, int steps) {
        this.colors = DrawUtil.getGradient(startColor, endColor, steps);
    }

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        if (this.colors == null) {
            g.drawString(text, x, y, orientation);
            return;
        }
        Font font = g.getFont();
        int height = font.getHeight();
        int width = font.stringWidth(text);
        int startX = this.getLeftX(x, orientation, width);
        int startY = this.getTopY(y, orientation, height, font.getBaselinePosition());
        if (this.nokiaImageBuffer == null || text != this.lastText) {
            this.nokiaImageBuffer = DirectUtils.createImage((int)width, (int)height, (int)0);
            Graphics bufferG = this.nokiaImageBuffer.getGraphics();
            DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
            bufferG.setFont(font);
            int j = 0;
            boolean increase = true;
            int maxJ = this.colors.length - 1;
            for (int i = 0; i < height; ++i) {
                int color = this.colors[j];
                bufferG.setClip(0, i, width, 1);
                if (this.useTransparency) {
                    dg.setARGBColor(color);
                } else {
                    bufferG.setColor(color);
                }
                bufferG.drawString(text, 0, 0, 20);
                if (increase) {
                    if (++j < maxJ) continue;
                    increase = false;
                    continue;
                }
                if (--j > 0) continue;
                increase = true;
            }
            dg.drawImage(this.nokiaImageBuffer, startX, startY, 20, 0);
            this.lastText = text;
        } else {
            DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
            dg.drawImage(this.nokiaImageBuffer, startX, startY, 20, 0);
        }
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        this.lastText = null;
        boolean styleDefined = false;
        int startColor = -1;
        int endColor = -16777216;
        this.useTransparency = (startColor & 0xFF000000) != 0 || (endColor & 0xFF000000) != 0;
        int steps = Font.getDefaultFont().getHeight();
        if (styleDefined || this.colors == null) {
            this.colors = DrawUtil.getGradient(startColor, endColor, steps);
        }
        this.lastText = null;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.colors = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.colors[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.lastText = (String)Serializer.deserialize(dataInputStream);
        this.nokiaImageBuffer = (Image)Serializer.deserialize(dataInputStream);
        this.useTransparency = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        if (this.colors == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.colors.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.colors[n2]);
                ++n2;
            }
        }
        Serializer.serialize(this.lastText, dataOutputStream);
        Serializer.serialize(this.nokiaImageBuffer, dataOutputStream);
        dataOutputStream.writeBoolean(this.useTransparency);
    }
}

