/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.ui.Color;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class VerticalSplitTextEffect
extends TextEffect {
    private int bottomColor = 0xCCCCCC;
    private int splitPos = 50;

    public void setStyle(Style style) {
        super.setStyle(style);
        Color bottomColorObj = style.getColorProperty(318);
        if (bottomColorObj != null) {
            this.bottomColor = bottomColorObj.getColor();
        }
    }

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        g.setColor(textColor);
        g.drawString(text, x, y, orientation);
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int split = g.getFont().getHeight() * this.splitPos / 100;
        if (orientation == 0) {
            g.clipRect(clipX, y + split, clipW, clipH);
        } else {
            int topY = this.getTopY(y, orientation, g.getFont());
            g.clipRect(clipX, topY + split, clipW, clipH);
        }
        g.setColor(this.bottomColor);
        g.drawString(text, x, y, orientation);
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.bottomColor = dataInputStream.readInt();
        this.splitPos = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.bottomColor);
        dataOutputStream.writeInt(this.splitPos);
    }
}

