/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.ui.StyleSheet;

public class DeviceControl
extends Thread {
    private static DeviceControl thread;
    private static Object lightsLock;
    private static Object vibrateLock;
    private boolean lightOff = false;

    private DeviceControl() {
    }

    public void run() {
        int displaytime = 10000;
        long sleeptime = displaytime * 90 / 100;
        boolean increaseAfterFirstLoop = true;
        while (!this.lightOff) {
            this.switchLightOnFor(displaytime);
            try {
                Thread.sleep(sleeptime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!increaseAfterFirstLoop) continue;
            increaseAfterFirstLoop = false;
            displaytime = 20000;
            sleeptime = 18000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchLightOnFor(int durationInMs) {
        Object object = lightsLock;
        synchronized (object) {
            com.nokia.mid.ui.DeviceControl.setLights((int)0, (int)0);
            com.nokia.mid.ui.DeviceControl.setLights((int)0, (int)100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchLightOff() {
        Object object = lightsLock;
        synchronized (object) {
            this.lightOff = true;
            StyleSheet.display.flashBacklight(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lightOn() {
        Object object = lightsLock;
        synchronized (object) {
            boolean success = false;
            if (thread == null && DeviceControl.isLightSupported()) {
                DeviceControl dc = new DeviceControl();
                dc.start();
                success = true;
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lightOff() {
        Object object = lightsLock;
        synchronized (object) {
            DeviceControl dc = thread;
            if (dc != null) {
                dc.switchLightOff();
                thread = null;
            }
        }
    }

    public static boolean isLightSupported() {
        boolean isSupported = false;
        isSupported = true;
        return isSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean vibrate(int duration) {
        Object object = vibrateLock;
        synchronized (object) {
            boolean success = false;
            success = StyleSheet.display.vibrate(duration);
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isVibrateSupported() {
        Object object = vibrateLock;
        synchronized (object) {
            boolean isSupported = false;
            try {
                com.nokia.mid.ui.DeviceControl.startVibra((int)0, (long)1L);
                isSupported = true;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return isSupported;
        }
    }

    static {
        lightsLock = new Object();
        vibrateLock = new Object();
    }
}

