/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.MathUtil;
import de.enough.polish.util.RgbImage;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class ImageUtil {
    private static final int INTMAX = 1024;
    private static final int PSEUDO_FLOAT = 10;
    private static final int PSEUDO_POW2 = 1024;
    private static final int PSEUDO_POW2M1 = 1023;
    private static final int SCALE_THRESHOLD_SHIFT = 3;
    public static final int EDGEDETECTION_MAP_HIGHEST_QUALITY = -1;
    public static final int EDGEDETECTION_MAP_HIGH_QUALITY = -16843010;
    public static final int EDGEDETECTION_MAP_MEDIUM = -253693728;
    public static final int EDGEDETECTION_MAP_FAST = -255803200;
    public static final int EDGEDETECTION_MAP_FAST_AND_SIMPLE = 0;

    private ImageUtil() {
    }

    public static void scale(int scaleFactor, int width, int height, int[] rgbData, int[] scaledRgbData) {
        if (scaleFactor < 100) {
            int yStart;
            int xStart = (width * 100 - width * scaleFactor) / 200;
            for (int y = yStart = (height * 100 - height * scaleFactor) / 200; y < height - yStart; ++y) {
                for (int x = xStart; x < width - xStart; ++x) {
                    int xTarget = x * scaleFactor / 100 + xStart;
                    int yTarget = y * scaleFactor / 100 + yStart;
                    scaledRgbData[yTarget * width + xTarget] = rgbData[y * width + x];
                }
            }
            return;
        }
        int xStart = (width - width * 100 / scaleFactor) / 2;
        int yStart = (height - height * 100 / scaleFactor) / 2 * width;
        for (int y = 0; y < height; ++y) {
            int c1 = y * width;
            int c2 = yStart + y * 100 / scaleFactor * width;
            for (int x = 0; x < width; ++x) {
                scaledRgbData[c1 + x] = rgbData[c2 + xStart + x * 100 / scaleFactor];
            }
        }
    }

    public static void particleScale(int factor, int width, int height, int[] sourceRgb, int[] targetRgb) {
        int distanceY;
        int distanceX;
        for (int i = 0; i < targetRgb.length; ++i) {
            targetRgb[i] = 0;
        }
        int centerX = width >> 1;
        int centerY = height >> 1;
        int startX = distanceX = width - width * 100 / factor >> 1;
        int endX = width - distanceX;
        int startY = distanceY = height - height * 100 / factor >> 1;
        int endY = height - distanceY;
        for (int y = startY; y < endY; ++y) {
            for (int x = startX; x < endX; ++x) {
                int targetY;
                distanceX = centerX - x;
                int targetX = centerX - distanceX * factor / 100;
                if (targetX < 0 || targetX >= width || (targetY = centerY - (distanceY = centerY - y) * factor / 100) < 0 || targetY >= height) continue;
                int sourceIndex = y * width + x;
                int targetIndex = targetY * width + targetX;
                targetRgb[targetIndex] = sourceRgb[sourceIndex];
            }
        }
    }

    public static void scale(int opacity, int scaleFactor, int width, int height, int[] rgbData, int[] scaledRgbData) {
        opacity = opacity << 24 | 0xFFFFFF;
        if (scaleFactor < 100) {
            int xStart = (width * 100 - width * scaleFactor) / 200;
            int yStart = (height * 100 - height * scaleFactor) / 200;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int xTarget = x * scaleFactor / 100 + xStart;
                    int yTarget = y * scaleFactor / 100 + yStart;
                    scaledRgbData[yTarget * width + xTarget] = (rgbData[y * width + x] | 0xFF000000) & opacity;
                }
            }
            return;
        }
        int yStart = (height - height * 100 / scaleFactor) / 2 * width;
        int xStart = (width - width * 100 / scaleFactor) / 2;
        for (int y = 0; y < height; ++y) {
            int c1 = y * width;
            int c2 = yStart + y * 100 / scaleFactor * width;
            for (int x = 0; x < width; ++x) {
                scaledRgbData[c1 + x] = (rgbData[c2 + xStart + x * 100 / scaleFactor] | 0xFF000000) & opacity;
            }
        }
    }

    public static int[] scale(int scaledWidth, int scaledHeight, int scanlength, int sourceWidth, int sourceHeight, int[] rgbData) {
        int[] scaledRgbData = new int[scaledWidth * scaledHeight];
        for (int y = 0; y < scaledHeight; ++y) {
            int c1 = y * scaledWidth;
            int c2 = y * sourceHeight / scaledHeight * scanlength;
            for (int x = 0; x < scaledWidth; ++x) {
                scaledRgbData[c1 + x] = rgbData[c2 + x * sourceWidth / scaledWidth];
            }
        }
        return scaledRgbData;
    }

    public static void scaleDownHq(int[] dest, int[] src, int srcWidth, int scaledWidth, int scaledHeight, int opacity, boolean SKIP_FRACTIONS) {
        ImageUtil.scaleDownHq(dest, src, srcWidth, 0, scaledWidth, scaledHeight, opacity, -16843010, SKIP_FRACTIONS);
    }

    public static void scaleDownHq(int[] dest, int[] src, int srcWidth, int scaleFactor, int scaledWidth, int scaledHeight, int opacity, int EDGEDETECTION_MAP, boolean SKIP_FRACTIONS) {
        int srcHeight = src.length / srcWidth;
        int scaleS = scaleFactor != 0 ? 102400 / scaleFactor : (scaledWidth != 0 ? (srcWidth << 10) / scaledWidth : (srcHeight << 10) / scaledHeight);
        if (scaleS == 1024) {
            System.arraycopy(src, 0, dest, 0, src.length);
            return;
        }
        if (scaleS < 1024) {
            throw new IllegalArgumentException();
        }
        if (scaleS > 5120) {
            throw new IllegalArgumentException(" scale >5 may lead to internal overflows use perspectiveShear instead");
        }
        if (scaledHeight == 0) {
            scaledHeight = (srcHeight << 10) / scaleS;
        }
        if (scaledHeight == 0) {
            scaledWidth = (srcWidth << 10) / scaleS;
        }
        int destPointer = 0;
        int[] tmp = new int[5];
        int srcXdetailed = 0;
        int srcYdetailed = 0;
        int srcYrounded = 0;
        int destPixelItensityMinimum = SKIP_FRACTIONS ? 1024 * scaleS * scaleS >> 20 : 0;
        if (EDGEDETECTION_MAP != -1) {
            ImageUtil.scale(src, scaledWidth, scaledHeight, srcWidth, srcHeight, dest);
        }
        int currentDestEdge = 0;
        for (int scaledY = 0; scaledY < scaledHeight; ++scaledY) {
            for (int scaledX = 0; scaledX < scaledWidth; ++scaledX) {
                destPointer = scaledY * scaledWidth + scaledX;
                currentDestEdge = dest[destPointer] & EDGEDETECTION_MAP;
                if (EDGEDETECTION_MAP == -1 || scaledY == scaledHeight - 1 || scaledY == 0 || (currentDestEdge ^ dest[destPointer + 1] & EDGEDETECTION_MAP) != 0 || (currentDestEdge ^ dest[destPointer - 1] & EDGEDETECTION_MAP) != 0 || (currentDestEdge ^ dest[destPointer + scaledWidth] & EDGEDETECTION_MAP) != 0 || (currentDestEdge ^ dest[destPointer - scaledWidth] & EDGEDETECTION_MAP) != 0) {
                    int smallY;
                    int yIntensityStart = 1024 - (srcYdetailed & 0x3FF);
                    int yIntensityEnd = srcYdetailed + scaleS & 0x3FF;
                    if (yIntensityEnd == 0) {
                        yIntensityEnd = 1024;
                    }
                    int xIntensityStart = 1024 - (srcXdetailed & 0x3FF);
                    int xIntensityEnd = srcXdetailed + scaleS & 0x3FF;
                    if (xIntensityEnd == 0) {
                        xIntensityEnd = 1024;
                    }
                    tmp[0] = 0;
                    tmp[1] = 0;
                    tmp[2] = 0;
                    tmp[3] = 0;
                    tmp[4] = 0;
                    tmp = ImageUtil.helpWithX(src, tmp, srcWidth, srcXdetailed, srcYdetailed >> 10, scaleS, yIntensityStart, xIntensityStart, xIntensityEnd, destPixelItensityMinimum);
                    for (smallY = srcYrounded + 1; smallY <= (srcYdetailed + scaleS >> 10) - 1; ++smallY) {
                        tmp = ImageUtil.helpWithX(src, tmp, srcWidth, srcXdetailed, smallY, scaleS, 1024, xIntensityStart, xIntensityEnd, destPixelItensityMinimum);
                    }
                    tmp = smallY < srcHeight ? ImageUtil.helpWithX(src, tmp, srcWidth, srcXdetailed, smallY, scaleS, yIntensityEnd, xIntensityStart, xIntensityEnd, destPixelItensityMinimum) : ImageUtil.mixPixelIn(tmp, 0, yIntensityEnd, destPixelItensityMinimum);
                    dest[destPointer] = tmp[1] == 0 ? 0 : tmp[1] * opacity / (255 * tmp[0]) << 24 | tmp[2] / tmp[1] << 16 | tmp[3] / tmp[1] << 8 | tmp[4] / tmp[1];
                }
                srcXdetailed += scaleS;
                srcYrounded = srcYdetailed >> 10;
            }
            srcXdetailed = 0;
            srcYrounded = (srcYdetailed += scaleS) >> 10;
        }
    }

    private static int[] helpWithX(int[] src, int[] tmp, int srcWidth, int srcXdetailed, int Yrounded, int scaleS, int yIntenstiy, int xIntensityStart, int xIntensityEnd, int destPixelItensityMinimum) {
        if (yIntenstiy < destPixelItensityMinimum >> 3) {
            return tmp;
        }
        int srcXrounded = srcXdetailed >> 10;
        int Y_srcWidth = Yrounded * srcWidth;
        tmp = ImageUtil.mixPixelIn(tmp, src[Y_srcWidth + srcXrounded], xIntensityStart * yIntenstiy >> 10, destPixelItensityMinimum);
        int smallX = 0;
        for (smallX = srcXrounded + 1; smallX <= (srcXdetailed + scaleS >> 10) - 1; ++smallX) {
            tmp = ImageUtil.mixPixelIn(tmp, src[Y_srcWidth + smallX], yIntenstiy, destPixelItensityMinimum);
        }
        tmp = smallX < srcWidth ? ImageUtil.mixPixelIn(tmp, src[Y_srcWidth + smallX], xIntensityEnd * yIntenstiy >> 10, destPixelItensityMinimum) : ImageUtil.mixPixelIn(tmp, 0, xIntensityEnd * yIntenstiy >> 10, destPixelItensityMinimum);
        return tmp;
    }

    private static int[] mixPixelIn(int[] current, int add, int intensity, int destPixelItensityMinimum) {
        if (add == 0) {
            return current;
        }
        if (intensity < destPixelItensityMinimum >> 3) {
            return current;
        }
        int alpha = add >>> 24;
        current[0] = current[0] + intensity;
        current[1] = current[1] + (add >>> 24 & 0xFF) * intensity;
        current[2] = current[2] + (add >>> 16 & 0xFF) * intensity * alpha;
        current[3] = current[3] + (add >>> 8 & 0xFF) * intensity * alpha;
        current[4] = current[4] + (add & 0xFF) * intensity * alpha;
        return current;
    }

    public static void perspectiveShear(int[] src, int[] dest, int originalWidth, int newWidth, int leftHeight, int rightHeight, int opacity, int EDGEDETECTION_MAP) {
        int destPointer;
        int h;
        int largeHeight;
        int smallHeight;
        int originalHeight = src.length / originalWidth;
        if (leftHeight > rightHeight) {
            smallHeight = rightHeight;
            largeHeight = leftHeight;
        } else {
            smallHeight = leftHeight;
            largeHeight = rightHeight;
        }
        if (largeHeight > originalHeight || newWidth > originalWidth) {
            throw new IllegalArgumentException("just downscaling possible");
        }
        long t = System.currentTimeMillis();
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = 0;
        }
        int srcX = 0;
        int srcY = 0;
        int srcYdetailed = 0;
        int shrinkY = 1024 * (largeHeight - smallHeight) / originalWidth / 2;
        int[] tmp = new int[5];
        for (srcX = 0; srcX < originalWidth; ++srcX) {
            h = leftHeight > rightHeight ? (originalHeight - largeHeight) / 2 + (shrinkY * srcX >> 10) : (originalHeight - smallHeight) / 2 - (shrinkY * srcX >> 10);
            int scaleY = 1024 * originalHeight / (originalHeight - (h << 1));
            for (int destY = 0; destY < originalHeight - (h << 1); ++destY) {
                int smallY;
                srcYdetailed = scaleY * destY;
                srcY = srcYdetailed >> 10;
                destPointer = (destY + h) * originalWidth + srcX;
                int srcY_width = srcY * originalWidth;
                if (EDGEDETECTION_MAP != -1 && srcY != originalHeight - 1 && ((src[srcY_width + srcX] ^ src[(srcY + 1) * originalWidth + srcX]) & EDGEDETECTION_MAP) == 0) {
                    dest[destPointer] = src[srcY_width + srcX];
                    dest[destPointer] = dest[destPointer] & 0xFFFFFF | opacity * (dest[destPointer] >>> 24) / 255 << 24;
                    continue;
                }
                tmp[0] = 0;
                tmp[1] = 0;
                tmp[2] = 0;
                tmp[3] = 0;
                tmp[4] = 0;
                int yIntensityStart = 1024 - (srcYdetailed & 0x3FF);
                int yIntensityEnd = srcYdetailed + scaleY & 0x3FF;
                if (yIntensityEnd == 0) {
                    yIntensityEnd = 1024;
                }
                tmp = ImageUtil.mixPixelIn(tmp, src[srcY_width + srcX], yIntensityStart, 0);
                for (smallY = srcY + 1; smallY <= (srcYdetailed + scaleY >> 10) - 1; ++smallY) {
                    tmp = ImageUtil.mixPixelIn(tmp, src[smallY * originalWidth + srcX], 1024, 0);
                }
                tmp = smallY < originalHeight ? ImageUtil.mixPixelIn(tmp, src[smallY * originalWidth + srcX], yIntensityEnd, 0) : ImageUtil.mixPixelIn(tmp, 0, yIntensityEnd, 0);
                dest[destPointer] = tmp[1] == 0 ? 0 : tmp[1] * opacity / (255 * tmp[0]) << 24 | tmp[2] / tmp[1] << 16 | tmp[3] / tmp[1] << 8 | tmp[4] / tmp[1];
            }
        }
        int scaleX = 1024 * originalWidth / newWidth;
        if (scaleX != 1) {
            for (int y = h = (originalHeight - largeHeight) / 2; y < originalHeight - h; ++y) {
                int y_width = y * originalWidth;
                for (int destX = 0; destX < newWidth; ++destX) {
                    int smallX;
                    int srcXdetailed = scaleX * destX;
                    srcX = srcXdetailed >> 10;
                    destPointer = y_width + destX;
                    if (EDGEDETECTION_MAP != -1 && y != originalHeight - 1 && ((dest[y_width + srcX] ^ dest[y_width + srcX + 1]) & EDGEDETECTION_MAP) == 0) {
                        dest[destPointer] = dest[y_width + srcX];
                        continue;
                    }
                    tmp[0] = 0;
                    tmp[1] = 0;
                    tmp[2] = 0;
                    tmp[3] = 0;
                    tmp[4] = 0;
                    int xIntensityStart = 1024 - (srcXdetailed & 0x3FF);
                    int xIntensityEnd = srcXdetailed + scaleX & 0x3FF;
                    if (xIntensityEnd == 0) {
                        xIntensityEnd = 1024;
                    }
                    tmp = ImageUtil.mixPixelIn(tmp, dest[y_width + srcX], xIntensityStart, 0);
                    for (smallX = srcX + 1; smallX <= (srcXdetailed + scaleX >> 10) - 1; ++smallX) {
                        tmp = ImageUtil.mixPixelIn(tmp, dest[y_width + smallX], 1024, 0);
                    }
                    tmp = smallX < originalWidth ? ImageUtil.mixPixelIn(tmp, dest[y_width + smallX], xIntensityEnd, 0) : ImageUtil.mixPixelIn(tmp, 0, xIntensityEnd, 0);
                    dest[destPointer] = tmp[1] == 0 ? 0 : tmp[1] / tmp[0] << 24 | tmp[2] / tmp[1] << 16 | tmp[3] / tmp[1] << 8 | tmp[4] / tmp[1];
                }
                for (int x = newWidth; x < originalWidth; ++x) {
                    dest[y_width + x] = 0;
                }
            }
        }
    }

    public static void rotate(RgbImage image, int angle) {
        ImageUtil.rotate(image, angle, image.getWidth() / 2, image.getHeight() / 2);
    }

    public static void rotate(RgbImage image, int angle, int referenceX, int referenceY) {
        int[] rgbData = image.getRgbData();
        int width = image.getWidth();
        int height = image.getHeight();
        double degreeCos = Math.cos(Math.PI * (double)angle / 180.0);
        double degreeSin = Math.sin(Math.PI * (double)angle / 180.0);
        int rotatedWidth = ImageUtil.getRotatedWidth(angle, width, height, degreeCos, degreeSin);
        int rotatedHeight = ImageUtil.getRotatedHeight(angle, width, height, degreeCos, degreeSin);
        int[] rotatedRgbData = new int[rotatedWidth * rotatedHeight];
        ImageUtil.rotate(rgbData, width, height, referenceX, referenceY, 0xFFFFFF, degreeCos, degreeSin, rotatedRgbData, rotatedWidth, rotatedHeight);
        image.setRgbData(rotatedRgbData, rotatedWidth);
        image.setWidth(rotatedWidth);
        image.setHeight(rotatedHeight);
    }

    public static final int[] rotate(int[] argbArray, int width, int height, int degree, int backgroundColor) {
        return ImageUtil.rotate(argbArray, width, height, degree, width / 2, height / 2, backgroundColor);
    }

    public static final int[] rotate(int[] sourceRgbData, int width, int height, int degree, int referenceX, int referenceY, int backgroundColor) {
        double degreeCos = Math.cos(Math.PI * (double)degree / 180.0);
        double degreeSin = Math.sin(Math.PI * (double)degree / 180.0);
        int rotatedWidth = ImageUtil.getRotatedWidth(degree, width, height, degreeCos, degreeSin);
        int rotatedHeight = ImageUtil.getRotatedHeight(degree, width, height, degreeCos, degreeSin);
        int[] rotatedRgb = new int[rotatedHeight * rotatedWidth];
        ImageUtil.rotate(sourceRgbData, width, height, referenceX, referenceY, backgroundColor, degreeCos, degreeSin, rotatedRgb, rotatedWidth, rotatedHeight);
        return rotatedRgb;
    }

    public static void rotate(int[] sourceRgbData, int width, int height, int referenceX, int referenceY, int backgroundColor, double degreeCos, double degreeSin, int[] rotatedRGB, int rotatedWidth, int rotatedHeight) {
        int halfOfWidth = width / 2;
        int halfOfHeigth = height / 2;
        for (int x = 0; x < rotatedWidth; ++x) {
            for (int y = 0; y < rotatedHeight; ++y) {
                int refX = x - referenceX;
                int refY = y - referenceY;
                int newX = (int)((double)refX * degreeCos + (double)refY * degreeSin);
                int newY = (int)((double)refY * degreeCos - (double)refX * degreeSin);
                if ((newX += halfOfWidth) >= 0 && newX < width && (newY += halfOfHeigth) >= 0 && newY < height) {
                    int sumXY = newX + newY * width;
                    rotatedRGB[x + y * rotatedWidth] = sourceRgbData[sumXY];
                    continue;
                }
                rotatedRGB[x + y * rotatedWidth] = backgroundColor;
            }
        }
    }

    public static final int getRotatedHeight(int degree, int width, int heigth, double degreeCos, double degreeSin) {
        long maxY;
        if (degree == -90 || degree == 90 || degree == 270 || degree == -270) {
            return width;
        }
        if (degree == 360 || degree == 180 || degree == 0) {
            return heigth;
        }
        long pointY1 = MathUtil.round(0.0 * degreeSin + 0.0 * degreeCos);
        long pointY2 = MathUtil.round((double)width * degreeSin + 0.0 * degreeCos);
        long pointY3 = MathUtil.round(0.0 * degreeSin + (double)heigth * degreeCos);
        long pointY4 = MathUtil.round((double)width * degreeSin + (double)heigth * degreeCos);
        long minY = pointY1;
        if (pointY2 < minY) {
            minY = pointY2;
        }
        if (pointY3 < minY) {
            minY = pointY3;
        }
        if (pointY4 < minY) {
            minY = pointY4;
        }
        if (pointY2 > (maxY = pointY1)) {
            maxY = pointY2;
        }
        if (pointY3 > maxY) {
            maxY = pointY3;
        }
        if (pointY4 > maxY) {
            maxY = pointY4;
        }
        return (int)(maxY - minY);
    }

    public static final int getRotatedWidth(int degree, int width, int heigth, double degreeCos, double degreeSin) {
        long maxX;
        if (degree == -90 || degree == 90 || degree == 270 || degree == -270) {
            return heigth;
        }
        if (degree == 360 || degree == 180 || degree == 0) {
            return width;
        }
        long pointX1 = 0L;
        long pointX2 = MathUtil.round((double)width * degreeCos);
        long pointX3 = MathUtil.round((double)(-heigth) * degreeSin);
        long pointX4 = MathUtil.round((double)width * degreeCos - (double)heigth * degreeSin);
        long minX = pointX1;
        if (pointX2 < minX) {
            minX = pointX2;
        }
        if (pointX3 < minX) {
            minX = pointX3;
        }
        if (pointX4 < minX) {
            minX = pointX4;
        }
        if (pointX2 > (maxX = pointX1)) {
            maxX = pointX2;
        }
        if (pointX3 > maxX) {
            maxX = pointX3;
        }
        if (pointX4 > maxX) {
            maxX = pointX4;
        }
        return (int)(maxX - minX);
    }

    public static void rotateSimple(int[] source, int[] target, int w, int h, int degrees) {
        if (degrees == 90) {
            for (int row = 0; row < h; ++row) {
                for (int col = 0; col < w; ++col) {
                    target[col * h + (h - 1 - row)] = source[row * w + col];
                }
            }
        } else if (degrees == 180) {
            for (int row = 0; row < h; ++row) {
                for (int col = 0; col < w; ++col) {
                    target[(h - 1 - row) * w + (w - 1 - col)] = source[row * w + col];
                }
            }
        } else if (degrees == 270) {
            for (int row = 0; row < h; ++row) {
                for (int col = 0; col < w; ++col) {
                    target[(w - 1 - col) * h + row] = source[row * w + col];
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static final int[] scale(int opacity, int[] rgbData, int newWidth, int newHeight, int oldWidth, int oldHeight) {
        int[] newrgbData = new int[newWidth * newHeight];
        ImageUtil.scale(opacity, rgbData, newWidth, newHeight, oldWidth, oldHeight, newrgbData);
        return newrgbData;
    }

    public static final int[] scale(int[] rgbData, int newWidth, int newHeight, int oldWidth, int oldHeight) {
        int[] newRgbData = new int[newWidth * newHeight];
        ImageUtil.scale(rgbData, newWidth, newHeight, oldWidth, oldHeight, newRgbData);
        return newRgbData;
    }

    public static final int[] stretchVertical(int[] argbArray, int topStrechFactor, int bottomStrechFactor, int width, int heigth) {
        int biggerWidth;
        int procentualScalingHeight;
        int newWidthTop = width * topStrechFactor / 100;
        int newWidthBottom = width * bottomStrechFactor / 100;
        if (newWidthTop < newWidthBottom) {
            procentualScalingHeight = (newWidthBottom - newWidthTop) / heigth;
            biggerWidth = newWidthBottom;
        } else {
            procentualScalingHeight = (newWidthTop - newWidthBottom) / heigth;
            biggerWidth = newWidthTop;
        }
        int[] newArgbArray = new int[biggerWidth * heigth];
        return ImageUtil.stretchVertical(argbArray, newWidthTop, newWidthBottom, biggerWidth, width, heigth, procentualScalingHeight, newArgbArray);
    }

    public static final int[] stretchVertical(int[] argbArray, int newWidthTop, int newWidthBottom, int biggerWidth, int width, int heigth, int procentualScalingHeight, int[] newArgbArray) {
        if (procentualScalingHeight == 0) {
            ++procentualScalingHeight;
        }
        int length = newArgbArray.length;
        int oldLength = argbArray.length;
        int insideCurrentY = 0;
        int insideCurrentX = 0;
        int outsideCurrentX = 0;
        int sum1 = (biggerWidth - newWidthTop) / 2;
        int sum2 = biggerWidth - (biggerWidth - newWidthTop) / 2;
        for (int i = 0; i < length; ++i) {
            if ((outsideCurrentX = (outsideCurrentX + 1) % biggerWidth) == 0) {
                if (newWidthTop < newWidthBottom) {
                    sum1 = (biggerWidth - (newWidthTop += procentualScalingHeight)) / 2;
                    sum2 = biggerWidth - (biggerWidth - newWidthTop) / 2;
                } else if (newWidthTop > newWidthBottom) {
                    sum1 = (biggerWidth - (newWidthTop -= procentualScalingHeight)) / 2;
                    sum2 = biggerWidth - (biggerWidth - newWidthTop) / 2;
                }
                ++insideCurrentY;
                insideCurrentX = 0;
            }
            if (outsideCurrentX >= sum1 && outsideCurrentX < sum2) {
                insideCurrentX = (insideCurrentX + 1) % newWidthTop;
                newArgbArray[i] = argbArray[ImageUtil.scaledPixel(oldLength, width, heigth, newWidthTop, heigth, insideCurrentX, insideCurrentY)];
                continue;
            }
            newArgbArray[i] = 0;
        }
        return newArgbArray;
    }

    public static final int scaledPixel(int oldLength, int oldWidth, int oldHeigth, int newWidth, int newHeigth, int currentX, int currentY) {
        int horizontalScaleFactorPercent = newWidth * 100 / oldWidth;
        int verticalShrinkFactorPercent = newHeigth * 100 / oldHeigth;
        int targetArrayIndex = currentX * 100 / horizontalScaleFactorPercent + oldWidth * (currentY * 100 / verticalShrinkFactorPercent);
        if (targetArrayIndex >= oldLength) {
            targetArrayIndex = oldLength - 1;
        }
        if (targetArrayIndex < 0) {
            targetArrayIndex = 0;
        }
        return targetArrayIndex;
    }

    public static final int[] stretchHorizontal(int[] argbArray, int leftStrechFactor, int rightStrechFactor, int width, int heigth) {
        int biggerHeigth;
        int procentualScalingWidth;
        int newHeigthLeft = heigth * leftStrechFactor / 100;
        int newHeigthRight = heigth * rightStrechFactor / 100;
        if (newHeigthLeft < newHeigthRight) {
            procentualScalingWidth = (newHeigthRight - newHeigthLeft) / width;
            biggerHeigth = newHeigthRight;
        } else {
            procentualScalingWidth = (newHeigthLeft - newHeigthRight) / width;
            biggerHeigth = newHeigthLeft;
        }
        int[] newArgbArray = new int[biggerHeigth * width];
        return ImageUtil.stretchHorizontal(argbArray, newHeigthLeft, newHeigthRight, biggerHeigth, width, heigth, procentualScalingWidth, newArgbArray);
    }

    public static final int[] stretchHorizontal(int[] argbArray, int newLeftHeigth, int newRigthHeigth, int biggerHeigth, int width, int heigth, int procentualScalingHeight, int[] newArgbArray) {
        if (procentualScalingHeight == 0) {
            ++procentualScalingHeight;
        }
        int length = newArgbArray.length;
        int oldLength = argbArray.length;
        int idX = 0;
        int idY = 0;
        int x = 0;
        int y = 0;
        int whereIamAt = 0;
        int newHeigth = newLeftHeigth;
        int startColumn = (biggerHeigth - newHeigth) / 2;
        int endColumn = biggerHeigth - (biggerHeigth - newHeigth) / 2;
        for (int i = 0; i < length; ++i) {
            if (startColumn <= idY && endColumn >= idY) {
                newArgbArray[whereIamAt] = argbArray[ImageUtil.scaledPixel(oldLength, width, heigth, width, newHeigth, x, y)];
                y = (y + 1) % newHeigth;
            } else {
                newArgbArray[whereIamAt] = 0;
            }
            idY = (idY + 1) % biggerHeigth;
            whereIamAt = idX + idY * width;
            if (idY != 0) continue;
            ++idX;
            ++x;
            y = 0;
            if (newLeftHeigth < newRigthHeigth) {
                newHeigth += procentualScalingHeight;
            } else if (newLeftHeigth > newRigthHeigth) {
                newHeigth -= procentualScalingHeight;
            }
            startColumn = (biggerHeigth - newHeigth) / 2;
            endColumn = biggerHeigth - (biggerHeigth - newHeigth) / 2;
        }
        return newArgbArray;
    }

    public static final void scale(int[] rgbData, int newWidth, int newHeight, int oldWidth, int oldHeight, int[] newRgbData) {
        int currentX = 0;
        int currentY = 0;
        int oldLenght = rgbData.length;
        int newLength = newRgbData.length;
        int verticalShrinkFactorPercent = newHeight * 100 / oldHeight;
        int horizontalScaleFactorPercent = newWidth * 100 / oldWidth;
        for (int i = 0; i < newLength; ++i) {
            int targetArrayIndex;
            if ((currentX = (currentX + 1) % newWidth) == 0) {
                ++currentY;
            }
            if ((targetArrayIndex = currentX * 100 / horizontalScaleFactorPercent + oldWidth * (currentY * 100 / verticalShrinkFactorPercent)) >= oldLenght) {
                targetArrayIndex = oldLenght - 1;
            }
            if (targetArrayIndex < 0) {
                targetArrayIndex = 0;
            }
            newRgbData[i] = rgbData[targetArrayIndex];
        }
    }

    public static final void scale(int opacity, int[] rgbData, int newWidth, int newHeight, int oldWidth, int oldHeight, int[] newRgbData) {
        int currentX = 0;
        int currentY = 0;
        int oldLenght = rgbData.length;
        int newLength = newRgbData.length;
        int verticalShrinkFactorPercent = newHeight * 100 / oldHeight;
        int horizontalScaleFactorPercent = newWidth * 100 / oldWidth;
        int alpha = opacity << 24;
        for (int i = 0; i < newLength; ++i) {
            int pixelAlpha;
            int targetArrayIndex;
            if ((currentX = (currentX + 1) % newWidth) == 0) {
                ++currentY;
            }
            if ((targetArrayIndex = currentX * 100 / horizontalScaleFactorPercent + oldWidth * (currentY * 100 / verticalShrinkFactorPercent)) >= oldLenght) {
                targetArrayIndex = oldLenght - 1;
            }
            if (targetArrayIndex < 0) {
                targetArrayIndex = 0;
            }
            int pixel = rgbData[targetArrayIndex];
            if (opacity != 255 && (pixelAlpha = (pixel & 0xFF000000) >>> 24) > opacity) {
                pixel = pixel & 0xFFFFFF | alpha;
            }
            newRgbData[i] = pixel;
        }
    }

    public static void setTransparency(int transparency, int[] data) {
        transparency <<= 24;
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i] & 0xFFFFFF | transparency;
        }
    }

    public static void setTransparencyOnlyForOpaque(int transparency, int[] data) {
        transparency <<= 24;
        for (int i = 0; i < data.length; ++i) {
            int pixel = data[i];
            if ((pixel & 0xFF000000) == 0) continue;
            data[i] = pixel & 0xFFFFFF | transparency;
        }
    }

    public static void setTransparencyOnlyForOpaque(int transparency, int[] data, boolean onlyForPixelsWithGreaterAlphas) {
        int alpha = transparency << 24;
        for (int i = 0; i < data.length; ++i) {
            int pixel = data[i];
            int pixelApha = (pixel & 0xFF000000) >>> 24;
            if (pixelApha <= transparency && (onlyForPixelsWithGreaterAlphas || pixelApha == 0)) continue;
            data[i] = pixel & 0xFFFFFF | alpha;
        }
    }

    public static int getDeviceColor(int color) {
        Image imageBuffer = Image.createImage((int)1, (int)1);
        Graphics graphicsBuffer = imageBuffer.getGraphics();
        graphicsBuffer.setColor(color);
        graphicsBuffer.fillRect(0, 0, 1, 1);
        int[] rgbData = new int[1];
        imageBuffer.getRGB(rgbData, 0, 1, 0, 0, 1, 1);
        return rgbData[0];
    }
}

