/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;

public class ScreenHistory {
    private final ArrayList history;
    private final int maxStep;

    public ScreenHistory() {
        this(-1);
    }

    public ScreenHistory(int maxStep) {
        this.maxStep = maxStep;
        this.history = new ArrayList();
    }

    public synchronized void show(Displayable screen, Display display) {
        Object[] internal = this.history.getInternalArray();
        int currentIndex = this.history.size() - 1;
        int maxCount = this.maxStep;
        boolean foundPrevious = false;
        for (int count = 0; currentIndex >= 0 && (count < maxCount || maxCount == -1); --currentIndex, ++count) {
            if (screen != internal[currentIndex]) continue;
            for (int i = this.history.size() - 1; i > currentIndex; --i) {
                this.history.remove(i);
            }
            foundPrevious = true;
            break;
        }
        if (!foundPrevious) {
            this.history.add(screen);
        }
        MasterCanvas.setCurrent(display, screen);
    }

    public synchronized boolean hasPrevious() {
        return this.history.size() > 1;
    }

    public synchronized boolean showPrevious(Display display) {
        if (this.history.size() > 1) {
            this.history.remove(this.history.size() - 1);
            Displayable screen = (Displayable)this.history.get(this.history.size() - 1);
            MasterCanvas.setCurrent(display, screen);
            return true;
        }
        return false;
    }

    public synchronized Displayable getPrevious() {
        if (this.history.size() > 1) {
            Displayable screen = (Displayable)this.history.get(this.history.size() - 2);
            return screen;
        }
        return null;
    }

    public synchronized Displayable getCurrent() {
        if (this.history.size() > 0) {
            return (Displayable)this.history.get(this.history.size() - 1);
        }
        return null;
    }

    public synchronized int getHistorySize() {
        return this.history.size();
    }

    public synchronized void clearHistory() {
        this.history.clear();
    }

    public synchronized void popHistory() {
        if (this.history.size() > 0) {
            this.history.remove(this.history.size() - 1);
        }
    }
}

