/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TableData
implements Externalizable {
    private static final int VERSION = 90;
    private int numberOfColumns;
    private int numberOfRows;
    private Object[][] data;

    public TableData() {
        this(0, 0);
    }

    public TableData(int columns, int rows) {
        this.setDimension(columns, rows);
    }

    public void setDimension(int columns, int rows) {
        this.data = new Object[columns][rows];
        this.numberOfColumns = columns;
        this.numberOfRows = rows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int addColumn() {
        Object[][] previousData = this.data;
        int cols = this.numberOfColumns;
        this.setDimension(cols + 1, this.numberOfRows);
        Object[][] currentData = this.data;
        for (int col = 0; col < cols; ++col) {
            currentData[col] = previousData[col];
        }
        this.numberOfColumns = cols + 1;
        return cols;
    }

    public void insertColumn(int index) {
        if (index < 0 || index > this.numberOfColumns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (index == this.numberOfColumns) {
            this.addColumn();
            return;
        }
        int cols = this.numberOfColumns;
        Object[][] newData = new Object[cols + 1][];
        Object[][] previousData = this.data;
        int source = 0;
        for (int col = 0; col < newData.length; ++col) {
            if (col == index) {
                newData[col] = new Object[this.numberOfRows];
                ++col;
            }
            newData[col] = previousData[source];
            ++source;
        }
        this.numberOfColumns = cols + 1;
        this.data = newData;
    }

    public void removeColumn(int index) {
        if (index < 0 || index > this.numberOfColumns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int cols = this.numberOfColumns;
        Object[][] newData = new Object[cols - 1][this.numberOfRows];
        Object[][] previousData = this.data;
        int target = 0;
        for (int col = 0; col < newData.length; ++col) {
            if (target == index) {
                ++target;
            }
            newData[col] = previousData[target];
            ++target;
        }
        this.numberOfColumns = cols - 1;
        this.data = newData;
    }

    public int addRow() {
        Object[][] previousData = this.data;
        int rows = this.numberOfRows;
        for (int col = 0; col < previousData.length; ++col) {
            Object[] previousRow = previousData[col];
            Object[] newRow = new Object[rows + 1];
            System.arraycopy(previousRow, 0, newRow, 0, rows);
            previousData[col] = newRow;
        }
        this.numberOfRows = rows + 1;
        return rows;
    }

    public void insertRow(int index) {
        if (index < 0 || index > this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (index == this.numberOfRows) {
            this.addRow();
            return;
        }
        int cols = this.numberOfColumns;
        int rows = this.numberOfRows + 1;
        Object[][] newData = new Object[cols][rows];
        Object[][] currentData = this.data;
        int source = 0;
        for (int col = 0; col < cols; ++col) {
            Object[] currentColumn = currentData[col];
            Object[] newColumn = newData[col];
            source = 0;
            for (int row = 0; row < rows; ++row) {
                if (row == index) {
                    ++row;
                }
                newColumn[row] = currentColumn[source];
                ++source;
            }
        }
        this.numberOfRows = rows;
        this.data = newData;
    }

    public void removeRow(int index) {
        if (index < 0 || index > this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int rows = this.numberOfRows - 1;
        Object[][] currentData = this.data;
        for (int col = 0; col < this.numberOfColumns; ++col) {
            Object[] previousColumn = currentData[col];
            Object[] newColumn = new Object[rows];
            int target = 0;
            for (int row = 0; row < rows; ++row) {
                if (target == index) {
                    ++target;
                }
                newColumn[row] = previousColumn[target];
                ++target;
            }
            currentData[col] = newColumn;
        }
        this.numberOfRows = rows;
    }

    public void set(int column, int row, Object value) {
        this.data[column][row] = value;
    }

    public Object get(int column, int row) {
        return this.data[column][row];
    }

    public Object[][] getInternalData() {
        return this.data;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(90);
        int columns = this.numberOfColumns;
        int rows = this.numberOfRows;
        out.writeInt(columns);
        out.writeInt(rows);
        Object[][] currentData = this.data;
        for (int col = 0; col < columns; ++col) {
            for (int row = 0; row < rows; ++row) {
                Serializer.serialize(currentData[col][row], out);
            }
        }
    }

    public void read(DataInputStream in) throws IOException {
        int version = in.readInt();
        int columns = in.readInt();
        int rows = in.readInt();
        this.setDimension(columns, rows);
        Object[][] currentData = this.data;
        for (int col = 0; col < columns; ++col) {
            for (int row = 0; row < rows; ++row) {
                currentData[col][row] = Serializer.deserialize(in);
            }
        }
    }
}

