/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.utils;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.SystemProperties;
import java.io.IOException;

public class Configuration {
    public static final String PRELOADED_CONTENT_XML = "/preloadedContent.xml";
    public static final String TEAM_LIST_XML = "/newsteamslinks.xml";
    public static final String CONF_LINKS_XML = "/confLinks.xml";
    public static final String RECORDSTORE_NAME_FIFA = "/fifa_config";
    private static String preloadedImagesDirectory;
    private static int phonePlatform;
    public static final int MINIMUN_FS_FOR_UPDATE = 250000;
    public static final int MINIMUN_STORAGE_FOR_UPDATE = 15000;
    public static final int OSE_PLATFORM = 0;
    public static final int SYMBIAN_PLATFORM = 1;
    public static final int EMULATOR_PLATFORM = 2;
    public static final String OSE_PICTURES_FOLDER = "/img_wqvga/";
    public static final String SYMBIAN_PICTURES_FOLDER = "/img_nhd/";
    public static final String EMULATOR_PICTURES_FOLDER = "/img_wqvga/";
    public static final String MOBILE_OSE_DOWNLOAD_IMAGES_DIRECTORY;
    public static final String MOBILE_SYMBIAN_DOWNLOAD_IMAGES_DIRECTORY;
    public static final String MOBILE_MEMORYCARD_FOLDER;
    public static final String MOBILE_VIDEOS_FOLDER;
    public static final String MOBILE_SYMBIAN_VIDEOS_FOLDER_NAME = "Videos/";
    public static final String MOBILE_OSE_VIDEOS_FOLDER_NAME = "video/";
    public static final String FIFA_DEFAULT_FOLDER = "fifa";
    public static final String EMULATOR_VIDEOS_FOLDER = "/video/";
    public static final String EMULATOR_DOWNLOAD_IMAGES_DIRECTORY = "file:///c:/image/";
    public static final String THUMB_FILE_PREFIX = "thumb_";
    public static final boolean avoidNetworkChecks = false;

    static {
        MOBILE_OSE_DOWNLOAD_IMAGES_DIRECTORY = System.getProperty("fileconn.dir.private");
        MOBILE_SYMBIAN_DOWNLOAD_IMAGES_DIRECTORY = String.valueOf(System.getProperty("fileconn.dir.graphics")) + "fifa/";
        MOBILE_MEMORYCARD_FOLDER = System.getProperty("fileconn.dir.memorycard");
        MOBILE_VIDEOS_FOLDER = System.getProperty("fileconn.dir.videos");
    }

    public static String getTeamCode(String teamName) {
        String code = null;
        return code;
    }

    public static String getFeedUrl(String teamCode) {
        String feedUrl = null;
        return feedUrl;
    }

    public static String getPreloadedImagesDirectory() {
        if (preloadedImagesDirectory == null) {
            if (Configuration.getPhonePlatform() == 2) {
                preloadedImagesDirectory = "/img_wqvga/";
            } else if (Configuration.getPhonePlatform() == 0) {
                preloadedImagesDirectory = "/img_wqvga/";
            } else if (Configuration.getPhonePlatform() == 1) {
                preloadedImagesDirectory = SYMBIAN_PICTURES_FOLDER;
            }
        }
        return preloadedImagesDirectory;
    }

    public static String getPreloadedVideosDirectory() {
        String directory = null;
        directory = Configuration.getPhonePlatform() == 2 ? EMULATOR_VIDEOS_FOLDER : MOBILE_VIDEOS_FOLDER;
        return directory;
    }

    public static String getPreloadedMemoryVideosDirectory() {
        String directory = null;
        if (Configuration.getPhonePlatform() == 2) {
            directory = EMULATOR_VIDEOS_FOLDER;
        } else if (Configuration.getPhonePlatform() == 0) {
            directory = String.valueOf(MOBILE_MEMORYCARD_FOLDER) + MOBILE_OSE_VIDEOS_FOLDER_NAME;
        } else if (Configuration.getPhonePlatform() == 1) {
            directory = String.valueOf(MOBILE_MEMORYCARD_FOLDER) + MOBILE_SYMBIAN_VIDEOS_FOLDER_NAME;
        }
        return directory;
    }

    public static int getPhonePlatform() {
        String platform = System.getProperty("microedition.platform");
        if (platform.indexOf("SDK") != -1) {
            phonePlatform = 2;
        } else {
            platform = System.getProperty("com.sonyericsson.java.platform");
            if (platform.indexOf("SJP") != -1) {
                phonePlatform = 1;
            } else if (platform.indexOf("JP") != -1) {
                phonePlatform = 0;
            }
        }
        return phonePlatform;
    }

    public static String getDownloadImageDirectory() {
        switch (Configuration.getPhonePlatform()) {
            case 2: {
                return EMULATOR_DOWNLOAD_IMAGES_DIRECTORY;
            }
            case 0: {
                return MOBILE_OSE_DOWNLOAD_IMAGES_DIRECTORY;
            }
            case 1: {
                try {
                    IOUtility.createDirectories(MOBILE_SYMBIAN_DOWNLOAD_IMAGES_DIRECTORY);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return MOBILE_SYMBIAN_DOWNLOAD_IMAGES_DIRECTORY;
            }
        }
        return Configuration.getPreloadedImagesDirectory();
    }

    public static String getFilePathForDownload(String httpAddress, String teamCode) {
        String filePath = String.valueOf(Configuration.getDownloadImageDirectory()) + teamCode + "/";
        try {
            IOUtility.createDirectories(filePath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int beginIndex = httpAddress.lastIndexOf(47);
        String httpAddressString = SystemProperties.removeTrashCharacters(httpAddress.substring(beginIndex + 1));
        filePath = String.valueOf(filePath) + httpAddressString;
        return filePath;
    }

    public static String getFilePathForThumbnail(String enclosurePath) {
        int beginIndex = enclosurePath.lastIndexOf(47);
        String fileName = enclosurePath.substring(beginIndex + 1);
        String folder = enclosurePath.substring(0, beginIndex + 1);
        String filePath = String.valueOf(folder) + THUMB_FILE_PREFIX + fileName;
        return filePath;
    }
}

