/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.player;

import com.nokia.mid.ui.DeviceControl;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.AbstractView;
import com.sonyericsson.fifa.view.VideoPlayerHB209;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.exceptions.VideoPlayerException;
import com.sonyericsson.fifa.view.player.VideoPlayerGuiHB209;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;

public class VideoPlayerViewHB209
extends AbstractView
implements com.sonyericsson.fifa.view.components.BackAction {
    private VideoPlayerGuiHB209 gui = null;
    private VideoPlayerHB209 videoPlayer = null;
    private LightsOn thread = null;

    public VideoPlayerViewHB209(int name, Model model) {
        super(name, model);
    }

    public void startVideo(String videoPath) throws IOException, VideoPlayerException {
        this.gui = new VideoPlayerGuiHB209(this);
        this.videoPlayer = new VideoPlayerHB209();
        this.gui.setPlayer(this.videoPlayer, videoPath, SystemProperties.getFilename(videoPath));
        this.gui.playVideo();
    }

    public int getViewId() {
        return 0;
    }

    public void hide() {
        try {
            this.gui.stopVideo();
            this.gui.close();
        }
        catch (VideoPlayerException e) {
            e.printStackTrace();
        }
    }

    public void show() throws ViewException {
        Display lcdui = SystemProperties.getLCDUIDisplay();
        this.keepLightsOn();
        lcdui.setCurrent((Displayable)this.gui);
    }

    public void back() {
        BackAction b = new BackAction();
        this.turnLightsOff();
        this.fireViewActionPerformed(b);
    }

    private void keepLightsOn() {
        this.thread = new LightsOn();
        new Thread(this.thread).start();
    }

    private void turnLightsOff() {
        this.thread.stop();
    }

    public void showNotify() {
    }

    public void pausedNotify() {
        this.back();
    }

    public void notifyMoveTabLeft() {
    }

    public void notifyMoveTabRigth() {
    }

    public void notifyRigthSoftKeySelected() {
    }

    public void onKeyPressed(int keyCode) {
    }

    public void onKeyReleased(int keyCode) {
    }

    public void onLongKeyPressed(int keyCode) {
    }

    public void onLongTouchPressed(int valX, int ValY) {
    }

    public void onTouchDragged(int valX, int valY) {
    }

    public void onTouchPressed(int valX, int ValY) {
    }

    public void onTouchReleased(int valX, int ValY) {
    }

    public void selectedItem(int item) {
    }

    static class LightsOn
    implements Runnable {
        private boolean running = false;

        LightsOn() {
        }

        public void stop() {
            this.running = false;
        }

        public void run() {
            this.running = true;
            while (this.running) {
                Thread.yield();
                DeviceControl.setLights((int)0, (int)100);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

