/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.Squad;
import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.data.TeamComponent;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.teamList.SquadListener;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.PlayerAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.components.forms.SquadForm;
import com.sun.lwuit.Image;
import java.io.IOException;
import java.util.Vector;

public class SquadView
extends FifaAbstractView
implements SquadListener {
    private String teamCode;
    private Team team;
    private Squad squad;
    private SquadForm squadForm;
    private String[] playerNames;
    private boolean isFirstSquadShow;
    private static final int MAX_NUMBER_TEAM_PLAYERS = 30;

    public SquadView(Model model, String teamCode) {
        super(9, model);
        this.teamCode = teamCode;
        this.team = model.getTeam(teamCode);
        this.squad = this.team.getSquad();
        this.playerNames = new String[30];
        this.squadForm = ViewFactory.getSquadForm();
        this.isFirstSquadShow = true;
    }

    private void addPlayerList() {
        Vector linksList = this.getSquadData();
        if (linksList != null && !linksList.isEmpty()) {
            this.addListItems(linksList);
        }
    }

    private Vector getSquadData() {
        if (this.squad == null) {
            this.squad = this.team.getSquad();
        }
        if (this.squad != null) {
            return this.squad.getComponents();
        }
        return null;
    }

    private void addListItems(Vector linksList) {
        if (linksList != null && linksList.size() > 0) {
            int count = linksList.size();
            int i = 0;
            while (i < count) {
                TeamComponent content = (TeamComponent)linksList.elementAt(i);
                this.squadForm.addItem(content.getName(), content.getTitle(), content.getNumber());
                this.playerNames[i] = content.getName();
                ++i;
            }
        }
        this.squadForm.removeWaitIndicator();
    }

    private void addComponents() {
        Vector<Image> countryFlag = new Vector<Image>();
        try {
            countryFlag.addElement(Image.createImage(IOUtility.openFileInputStream(String.valueOf(FifaResources.getImageFolder()) + this.teamCode + "_SQUAD" + ".png")));
        }
        catch (IOException e) {
            Logger.logError(this.getClass(), "Exception to read image " + FifaResources.getImageFolder() + this.teamCode + "_SQUAD" + ".png");
        }
        this.squadForm.setHeadline(countryFlag);
        this.squadForm.setCrossfadePosition();
        this.squadForm.addCountryDataItem(this.getTeamGroup(this.teamCode));
        this.addPlayerList();
        this.squadForm.focusFirstItem();
    }

    protected void doShow() throws ViewException {
        this.viewId = 9;
        this.model.addSquadListener(this.teamCode, this);
        if (this.isFirstSquadShow) {
            this.updateView();
        }
        this.squadForm.setKeyListener(this);
        this.squadForm.setTouchListener(this);
        this.squadForm.setSelectableItemListener(this);
        this.squadForm.show();
    }

    protected void doHide() {
        this.squadForm.setSelectableItemListener(null);
        this.squadForm.setKeyListener(null);
        this.squadForm.setTouchListener(null);
        this.model.removeSquadListener(this.teamCode, this);
    }

    public void selectedItem(int index, int subGroup) {
        PlayerAction action = new PlayerAction(this.teamCode, this.squad, this.playerNames[index], this.team.getLatestNews());
        this.fireViewActionPerformed(action);
    }

    public void squadUpdated() {
        this.updateView();
    }

    public void onKeyPressed(int keyCode) {
        this.performSoftkey();
    }

    public void onTouchPressed(int valX, int valY) {
        this.performSoftkey();
    }

    public void performSoftkey() {
        if (-7 == this.squadForm.getSelectedSoftkey()) {
            this.getLanguage().removeLanguageListener(this);
            BackAction backAction = new BackAction();
            this.fireViewActionPerformed(backAction);
        }
    }

    protected void doUpdateView() {
        this.squadForm.removeAll();
        if (this.isFirstSquadShow) {
            this.squadForm.showWaitIndicator();
            this.isFirstSquadShow = false;
        }
        this.addComponents();
        this.squadForm.revalidate();
    }

    protected void doClearFormText() {
        if (!this.squadForm.isSquadItems()) {
            this.squadForm.refreshAll();
            this.updateView();
        } else {
            this.squadForm.refreshAll();
        }
    }

    public void squadUpdateFailed(byte reason) {
        boolean viewDisplayable = false;
        if (this.team.getSquad() != null && !this.team.getSquad().getComponents().isEmpty()) {
            viewDisplayable = true;
        }
        this.fireViewActionPerformed(new UpdateFailureAction(reason, viewDisplayable));
    }
}

