/*
 * Decompiled with CFR 0.152.
 */
package com.mgie.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class EncodeUtil {
    private static final byte[] BASE64ENCODECHAR = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] BASE64ENCODECHAR_URL = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 95, 45};
    private static byte[] BASE64DECODECHAR = null;
    private static byte[] BASE64DECODECHAR_URL = null;

    public static String base64Encode(String string) {
        return EncodeUtil.base64Encode(string, BASE64ENCODECHAR);
    }

    public static byte[] base64Encode(byte[] byArray) {
        return EncodeUtil.base64Encode(byArray, BASE64ENCODECHAR);
    }

    public static String base64EncodeURL(String string) {
        return EncodeUtil.base64Encode(string, BASE64ENCODECHAR_URL);
    }

    public static byte[] base64EncodeURL(byte[] byArray) {
        return EncodeUtil.base64Encode(byArray, BASE64ENCODECHAR_URL);
    }

    private static String base64Encode(String string, byte[] byArray) {
        String string2 = null;
        try {
            byte[] byArray2 = EncodeUtil.convertStringToUTF8(string);
            byte[] byArray3 = EncodeUtil.base64Encode(byArray2, byArray);
            string2 = EncodeUtil.getAsciiString(byArray3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String base64Decode(String string) {
        if (BASE64DECODECHAR == null) {
            EncodeUtil.initBase64Char();
        }
        return EncodeUtil.base64Decode(string, BASE64DECODECHAR);
    }

    public static byte[] base64Decode(byte[] byArray) {
        if (BASE64DECODECHAR == null) {
            EncodeUtil.initBase64Char();
        }
        return EncodeUtil.base64Decode(byArray, BASE64DECODECHAR);
    }

    public static String base64DecodeURL(String string) {
        if (BASE64DECODECHAR_URL == null) {
            EncodeUtil.initBase64Char();
        }
        return EncodeUtil.base64Decode(string, BASE64DECODECHAR_URL);
    }

    public static byte[] base64DecodeURL(byte[] byArray) {
        if (BASE64DECODECHAR_URL == null) {
            EncodeUtil.initBase64Char();
        }
        return EncodeUtil.base64Decode(byArray, BASE64DECODECHAR_URL);
    }

    private static String base64Decode(String string, byte[] byArray) {
        String string2 = null;
        try {
            byte[] byArray2 = EncodeUtil.getAsciiByte(string);
            byte[] byArray3 = EncodeUtil.base64Decode(byArray2, byArray);
            string2 = EncodeUtil.convertUTF8toString(byArray3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static String getAsciiString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)byArray[i];
        }
        String string = new String(cArray);
        return string;
    }

    public static byte[] getAsciiByte(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    private static byte[] base64Encode(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        byte[] byArray3 = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = 0;
        int[] nArray = new int[3];
        try {
            n = byArray.length;
            int n2 = n % 3;
            if (n2 != 0) {
                n += 3 - n2;
            }
            n = n * 4 / 3;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            boolean bl = false;
            while (!bl && (nArray[0] = byteArrayInputStream.read()) != -1) {
                nArray[1] = byteArrayInputStream.read();
                nArray[2] = byteArrayInputStream.read();
                byteArrayOutputStream.write(byArray2[nArray[0] >> 2]);
                if (nArray[1] != -1) {
                    byteArrayOutputStream.write(byArray2[nArray[0] << 4 & 0x30 | nArray[1] >> 4]);
                    if (nArray[2] != -1) {
                        byteArrayOutputStream.write(byArray2[nArray[1] << 2 & 0x3C | nArray[2] >> 6]);
                        byteArrayOutputStream.write(byArray2[nArray[2] & 0x3F]);
                        continue;
                    }
                    byteArrayOutputStream.write(byArray2[nArray[1] << 2 & 0x3C]);
                    byteArrayOutputStream.write(42);
                    bl = true;
                    continue;
                }
                byteArrayOutputStream.write(byArray2[nArray[0] << 4 & 0x30]);
                byteArrayOutputStream.write(42);
                byteArrayOutputStream.write(42);
                bl = true;
            }
            byteArrayOutputStream.flush();
            byArray3 = byteArrayOutputStream.toByteArray();
            byteArrayInputStream.close();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray3;
    }

    private static byte[] base64Decode(byte[] byArray, byte[] byArray2) {
        int n = 0;
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        n = byArray.length;
        int n2 = n % 4;
        if (n2 != 0) {
            n += 4 - n2;
        }
        n = n * 3 / 4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        try {
            int[] nArray = new int[4];
            boolean bl = false;
            while (!bl && (nArray[0] = EncodeUtil.readBase64(byteArrayInputStream, byArray2)) != -1 && (nArray[1] = EncodeUtil.readBase64(byteArrayInputStream, byArray2)) != -1) {
                nArray[2] = EncodeUtil.readBase64(byteArrayInputStream, byArray2);
                nArray[3] = EncodeUtil.readBase64(byteArrayInputStream, byArray2);
                byteArrayOutputStream.write(nArray[0] << 2 | nArray[1] >> 4);
                if (nArray[2] != -1) {
                    byteArrayOutputStream.write(nArray[1] << 4 | nArray[2] >> 2);
                    if (nArray[3] != -1) {
                        byteArrayOutputStream.write(nArray[2] << 6 | nArray[3]);
                        continue;
                    }
                    bl = true;
                    continue;
                }
                bl = true;
            }
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void initBase64Char() {
        int n;
        BASE64DECODECHAR = new byte[127];
        BASE64DECODECHAR_URL = new byte[127];
        for (n = 0; n < BASE64DECODECHAR.length; ++n) {
            EncodeUtil.BASE64DECODECHAR[n] = -1;
            EncodeUtil.BASE64DECODECHAR_URL[n] = -1;
        }
        for (n = 0; n < BASE64ENCODECHAR.length; ++n) {
            EncodeUtil.BASE64DECODECHAR[EncodeUtil.BASE64ENCODECHAR[n]] = (byte)n;
            EncodeUtil.BASE64DECODECHAR_URL[EncodeUtil.BASE64ENCODECHAR_URL[n]] = (byte)n;
        }
        EncodeUtil.BASE64DECODECHAR[32] = -2;
        EncodeUtil.BASE64DECODECHAR[10] = -2;
        EncodeUtil.BASE64DECODECHAR[13] = -2;
        EncodeUtil.BASE64DECODECHAR[9] = -2;
        EncodeUtil.BASE64DECODECHAR[12] = -2;
        EncodeUtil.BASE64DECODECHAR[61] = -3;
        EncodeUtil.BASE64DECODECHAR[42] = -3;
        EncodeUtil.BASE64DECODECHAR_URL[32] = -2;
        EncodeUtil.BASE64DECODECHAR_URL[10] = -2;
        EncodeUtil.BASE64DECODECHAR_URL[13] = -2;
        EncodeUtil.BASE64DECODECHAR_URL[9] = -2;
        EncodeUtil.BASE64DECODECHAR_URL[12] = -2;
        EncodeUtil.BASE64DECODECHAR_URL[61] = -3;
        EncodeUtil.BASE64DECODECHAR_URL[42] = -3;
    }

    private static int readBase64(InputStream inputStream, byte[] byArray) {
        int n;
        int n2 = 0;
        do {
            try {
                n = inputStream.read();
            }
            catch (Exception exception) {
                n = -1;
            }
            if (n == -1) {
                return -1;
            }
            if ((n = byArray[(byte)n]) == -1 || n2 <= 0 || n > -1) {
                // empty if block
            }
            if (n != -3) continue;
            ++n2;
        } while (n <= -1);
        return n;
    }

    public static String convertUTF8toString(byte[] byArray) {
        StringBuffer stringBuffer = null;
        char c = '\u0000';
        if (byArray == null) {
            return "";
        }
        stringBuffer = new StringBuffer(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & 0xFFFFFF80) == 0) {
                c = (char)byArray[i];
                stringBuffer.append(new Character(c));
                continue;
            }
            if ((byArray[i] & 0xFFFFFFE0) == -64) {
                if (byArray.length <= i + 1 || (byArray[i + 1] & 0xFFFFFFC0) != -128) {
                    stringBuffer.append("?");
                    continue;
                }
                c = (char)((char)(byArray[i] & 0x1F) << 6 | (char)(byArray[i + 1] & 0x3F));
                stringBuffer.append(new Character(c));
                ++i;
                continue;
            }
            if ((byArray[i] & 0xFFFFFFF0) == -32) {
                if (byArray.length <= i + 2 || (byArray[i + 1] & 0xFFFFFFC0) != -128 || (byArray[i + 2] & 0xFFFFFFC0) != -128) {
                    stringBuffer.append("?");
                    continue;
                }
                c = (char)((char)(byArray[i] & 0xF) << 12 | (char)(byArray[i + 1] & 0x3F) << 6 | (char)(byArray[i + 2] & 0x3F));
                stringBuffer.append(new Character(c));
                i += 2;
                continue;
            }
            if ((byArray[i] & 0xFFFFFFF8) == -16) {
                if (byArray.length <= i + 3 || (byArray[i + 1] & 0xFFFFFFC0) != -128 || (byArray[i + 2] & 0xFFFFFFC0) != -128 || (byArray[i + 3] & 0xFFFFFFC0) != -128) {
                    stringBuffer.append("?");
                    continue;
                }
                c = (char)((char)(byArray[i] & 7) << 18 | (char)(byArray[i + 1] & 0x3F) << 12 | (char)(byArray[i + 2] & 0x3F) << 6 | (char)(byArray[i + 3] & 0x3F));
                stringBuffer.append(new Character(c));
                i += 3;
                continue;
            }
            if ((byArray[i] & 0xFFFFFFFC) == -8) {
                if (byArray.length <= i + 4 || (byArray[i + 1] & 0xFFFFFFC0) != -128 || (byArray[i + 2] & 0xFFFFFFC0) != -128 || (byArray[i + 3] & 0xFFFFFFC0) != -128 || (byArray[i + 4] & 0xFFFFFFC0) != -128) {
                    stringBuffer.append("?");
                    continue;
                }
                c = (char)((char)(byArray[i] & 3) << 24 | (char)(byArray[i + 1] & 0x3F) << 18 | (char)(byArray[i + 2] & 0x3F) << 12 | (char)(byArray[i + 3] & 0x3F) << 6 | (char)(byArray[i + 4] & 0x3F));
                stringBuffer.append(new Character(c));
                i += 4;
                continue;
            }
            if ((byArray[i] & 0xFFFFFFFE) == -4) {
                if (byArray.length <= i + 5 || (byArray[i + 1] & 0xFFFFFFC0) != -128 || (byArray[i + 2] & 0xFFFFFFC0) != -128 || (byArray[i + 3] & 0xFFFFFFC0) != -128 || (byArray[i + 4] & 0xFFFFFFC0) != -128 || (byArray[i + 5] & 0xFFFFFFC0) != -128) {
                    stringBuffer.append("?");
                    continue;
                }
                c = (char)((char)(byArray[i] & 3) << 30 | (char)(byArray[i + 1] & 0x3F) << 24 | (char)(byArray[i + 2] & 0x3F) << 18 | (char)(byArray[i + 3] & 0x3F) << 12 | (char)(byArray[i + 4] & 0x3F) << 6 | (char)(byArray[i + 5] & 0x3F));
                stringBuffer.append(new Character(c));
                i += 5;
                continue;
            }
            stringBuffer.append("?");
        }
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static byte[] convertStringToUTF8(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n = 0;
        if (cArray == null) {
            return null;
        }
        byArray = new byte[cArray.length * 6];
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >> 7 == 0) {
                byArray[n] = (byte)(cArray[i] & 0x7F);
                ++n;
                continue;
            }
            if (cArray[i] >> 11 == 0) {
                byArray[n] = (byte)(0xC0 | cArray[i] >> 6 & 0x1F);
                byArray[n + 1] = (byte)(0x80 | cArray[i] & 0xC0);
                n += 2;
                continue;
            }
            if (cArray[i] >> 16 == 0) {
                byArray[n] = (byte)(0xE0 | cArray[i] >> 12 & 0xF);
                byArray[n + 1] = (byte)(0x80 | cArray[i] >> 6 & 0x3F);
                byArray[n + 2] = (byte)(0x80 | cArray[i] & 0x3F);
                n += 3;
                continue;
            }
            if (cArray[i] >> 21 == 0) {
                byArray[n] = (byte)(0xF0 | cArray[i] >> 18 & 7);
                byArray[n + 1] = (byte)(0x80 | cArray[i] >> 12 & 0x3F);
                byArray[n + 2] = (byte)(0x80 | cArray[i] >> 6 & 0x3F);
                byArray[n + 3] = (byte)(0x80 | cArray[i] & 0x3F);
                n += 4;
                continue;
            }
            if (cArray[i] >> 26 == 0) {
                byArray[n] = (byte)(0xF8 | cArray[i] >> 24 & 3);
                byArray[n + 1] = (byte)(0x80 | cArray[i] >> 18 & 0x3F);
                byArray[n + 2] = (byte)(0x80 | cArray[i] >> 12 & 0x3F);
                byArray[n + 3] = (byte)(0x80 | cArray[i] >> 6 & 0x3F);
                byArray[n + 4] = (byte)(0x80 | cArray[i] & 0x3F);
                n += 5;
                continue;
            }
            if (cArray[i] >> 31 != 0) continue;
            byArray[n] = (byte)(0xFC | cArray[i] >> 30 & 1);
            byArray[n + 1] = (byte)(0x80 | cArray[i] >> 24 & 0x3F);
            byArray[n + 2] = (byte)(0x80 | cArray[i] >> 18 & 0x3F);
            byArray[n + 3] = (byte)(0x80 | cArray[i] >> 12 & 0x3F);
            byArray[n + 4] = (byte)(0x80 | cArray[i] >> 6 & 0x3F);
            byArray[n + 5] = (byte)(0x80 | cArray[i] & 0x3F);
            n += 6;
        }
        byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray = null;
        return byArray2;
    }
}

