/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.kbox.common.StringTool;

public class RestaurantList
extends Canvas {
    private String[] nameList;
    private Image[] logoList;
    private Image banner;
    private int selectedIndex;

    protected void paint(Graphics g) {
        g.setColor(-1);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.banner, 0, 0, 20);
        int startFixed = this.banner.getHeight();
        int colSize = 38;
        int rowSize = this.getWidth();
        Font font = Font.getFont((int)0, (int)0, (int)8);
        g.setFont(font);
        boolean isOdd = false;
        int i = 0;
        while (i < this.nameList.length) {
            g.setColor(isOdd ? -1 : -928551);
            isOdd = !isOdd;
            g.fillRect(0, startFixed + i * colSize, this.getWidth(), colSize);
            g.setColor(-16777216);
            g.drawImage(this.logoList[i], 3, startFixed + colSize * i + 3, 20);
            int leftWidth = rowSize - this.logoList[i].getWidth();
            if (leftWidth >= 0) {
                String[] nameParts = StringTool.split(this.nameList[i], " ");
                int j = 0;
                while (j < nameParts.length) {
                    g.drawString(nameParts[j], this.logoList[i].getWidth() + 6, startFixed + 15 * j + i * colSize + 3, 20);
                    ++j;
                }
            }
            ++i;
        }
        g.setColor(-16777216);
        g.drawRect(0, startFixed + this.selectedIndex * colSize, this.getWidth() - 1, colSize - 1);
    }

    public RestaurantList(String[] nameList, Image[] logoList, Image banner) {
        this.nameList = nameList;
        this.logoList = logoList;
        this.banner = banner;
    }

    protected void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        int listLength = this.nameList.length;
        switch (gameAction) {
            case 1: {
                this.selectedIndex = (this.selectedIndex - 1 + listLength) % listLength;
                break;
            }
            case 6: {
                this.selectedIndex = (this.selectedIndex + 1) % listLength;
            }
        }
        this.repaint();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }
}

