/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.io;

import com.fw.j2me.io.CntHttpConnection;
import com.fw.j2me.io.MultipartPostArgItem;
import com.fw.j2me.io.ProgressListener;
import com.fw.j2me.util.MiscUtil;
import com.fw.j2me.util.log.CntLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;

public abstract class HttpMultipartPost {
    private static CntLog log = new CntLog("HttpMultipartPost");
    protected static final String L_BOUNDARY = "---------------------------4664151417711";
    protected static final String BOUNDARY = "-----------------------------4664151417711";
    public static final String MULTIPART_BOUNDRY = "-----------------------------4664151417711\r\n";
    public static final String MULTIPART_BOUNDRY_END = "-----------------------------4664151417711--\r\n";
    public static final String CONTENT_DISPOSITION_HEADER_PART1 = "Content-Disposition: form-data; name=\"";
    public static final String CONTENT_DISPOSITION_HEADER_PART2 = "\"\r\n\r\n";
    public static final String CONTENT_DISPOSITION_HEADER_BINARY_PART1 = "Content-Disposition: form-data; filename=\"";
    public static final String CONTENT_DISPOSITION_HEADER_BINARY_PART2 = "\"\r\nContent-Type: ";
    public static final String CONTENT_DISPOSITION_HEADER_BINARY_PART3 = "\r\n\r\n";
    public static final int BINARY_MULTIPART_CHUNK_SIZE = 2048;
    public static final int BUFFER_SIZE = 2048;
    protected ProgressListener listener = null;
    protected HttpConnection connection = null;
    protected CntHttpConnection cntConnection = null;
    protected byte[][] data;
    protected Hashtable multipartBinaryData = new Hashtable();
    protected long multipartBinarySize = 0L;
    protected long bytesSent = 0L;
    protected int responseCode = 0;
    protected long responseLength = 0L;
    protected String responseMessage = "";
    protected boolean doCancel = false;

    public HttpMultipartPost(HttpConnection connection) {
        this.connection = connection;
    }

    public HttpMultipartPost(CntHttpConnection connection) {
        this.cntConnection = connection;
    }

    public void setListener(ProgressListener listener) {
        this.listener = listener;
    }

    public void cancel() {
        this.doCancel = true;
    }

    public boolean prepareBinaryData(Hashtable binaryData) {
        if (binaryData.size() == 0) {
            return false;
        }
        Enumeration keys = binaryData.keys();
        this.multipartBinarySize = 0L;
        while (keys.hasMoreElements()) {
            String filePath = (String)keys.nextElement();
            String mime = (String)binaryData.get(filePath);
            try {
                FileConnection fc = (FileConnection)Connector.open((String)filePath);
                long fileSize = fc.fileSize();
                if (fileSize == -1L) {
                    fc.close();
                    return false;
                }
                this.multipartBinaryData.put(fc, mime);
                this.multipartBinarySize += this.getBinarySize(fc.getName(), mime, fileSize);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        this.multipartBinarySize += (long)MULTIPART_BOUNDRY_END.length();
        return true;
    }

    protected long getBinarySize(String filename, String mime, long fileSize) {
        return (long)(MULTIPART_BOUNDRY.length() + CONTENT_DISPOSITION_HEADER_BINARY_PART1.length() + filename.length() + CONTENT_DISPOSITION_HEADER_BINARY_PART2.length() + mime.length() + CONTENT_DISPOSITION_HEADER_BINARY_PART3.length()) + fileSize + (long)"\r\n".length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] send() {
        if (null == this.data || 0 == this.data.length) {
            return null;
        }
        long tmp = 0L;
        for (int i = 0; i < this.data.length; ++i) {
            tmp += (long)this.data[i].length;
        }
        long contentLength = tmp + this.multipartBinarySize;
        if (this.listener != null) {
            this.listener.progressStarted(contentLength);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream os = null;
        byte[] response = null;
        try {
            String contentType = "multipart/form-data; boundary=---------------------------4664151417711";
            if (this.connection != null) {
                this.connection.setRequestProperty("Connection", "close");
                this.connection.setRequestProperty("Content-Type", contentType);
                this.connection.setRequestProperty("Content-Length", String.valueOf(contentLength));
                if (this.multipartBinarySize > 0L) {
                    this.connection.setRequestProperty("MIME-version", "1.0");
                }
                this.connection.setRequestMethod("POST");
                os = this.connection.openOutputStream();
            } else {
                this.cntConnection.setRequestProperty("Connection", "close");
                this.cntConnection.setRequestProperty("Content-Type", contentType);
                this.cntConnection.setRequestProperty("Content-Length", String.valueOf(contentLength));
                if (this.multipartBinarySize > 0L) {
                    this.cntConnection.setRequestProperty("MIME-version", "1.0");
                }
                this.cntConnection.setRequestMethod("POST");
                os = this.cntConnection.openOutputStream();
            }
            for (int i = 0; i < this.data.length; ++i) {
                os.write(this.data[i]);
            }
            this.bytesSent = tmp;
            if (this.listener != null) {
                this.listener.progress(tmp);
            }
            if (this.multipartBinarySize > 0L) {
                this.writeBinaryData(os);
            }
            this.writeEnd(os);
            if (!this.doCancel) {
                response = this.getResponse();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            if (this.listener != null) {
                this.listener.progressError();
            }
            byte[] byArray = response;
            return byArray;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.doCancel) {
            return null;
        }
        if (this.listener != null) {
            this.listener.progressFinished();
        }
        return response;
    }

    private void writeEnd(OutputStream os) throws IOException {
        log.debug("Writing multipart boundry end.");
        os.write(MULTIPART_BOUNDRY_END.getBytes());
        this.bytesSent += (long)MULTIPART_BOUNDRY_END.getBytes().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getResponse() {
        byte[] ret = null;
        InputStream is = null;
        try {
            is = this.requestResponseStream();
            log.debug("HttpMultipartPost.send(): Server responded with response code: " + this.responseCode);
            ret = this.responseLength != -1L ? this.getBytes(is, (int)this.responseLength) : this.getBytes(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.debug("HttpMultipartPost.send(): Could not close stream: " + e);
            }
        }
        return ret;
    }

    private InputStream requestResponseStream() throws IOException {
        if (this.connection != null) {
            this.responseCode = this.connection.getResponseCode();
            this.responseMessage = this.connection.getResponseMessage();
            this.responseLength = this.connection.getLength();
            if (this.responseCode != 200) {
                throw new IOException("HTTP connection to URL: '" + this.connection.getURL() + "' returned response: " + this.responseCode + " " + this.responseMessage);
            }
            return this.connection.openInputStream();
        }
        this.responseCode = this.cntConnection.getResponseCode();
        this.responseMessage = this.cntConnection.getResponseMessage();
        this.responseLength = this.cntConnection.getLength();
        if (this.responseCode != 200) {
            this.cntConnection.read();
            throw new IOException("HTTP connection to URL: '" + this.cntConnection.getURL() + "' returned response: " + this.responseCode + " " + this.responseMessage);
        }
        return this.cntConnection.openInputStream();
    }

    private byte[] getBytes(InputStream in, int length) throws IOException {
        byte[] ret = new byte[length];
        for (int offset = 0; offset < length && !this.doCancel; offset += in.read(ret, offset, length - offset)) {
        }
        if (this.doCancel) {
            return null;
        }
        return ret;
    }

    private byte[] getBytes(InputStream in) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        while (!this.doCancel && (bytesRead = in.read(buffer)) != -1) {
            bytes.write(buffer, 0, bytesRead);
        }
        bytes.flush();
        byte[] ret = bytes.toByteArray();
        bytes.close();
        this.responseLength = ret.length;
        if (this.doCancel) {
            return null;
        }
        return ret;
    }

    protected void writeBinaryData(OutputStream os) throws IOException {
        byte[] buffer = new byte[2048];
        Enumeration e = this.multipartBinaryData.keys();
        while (e.hasMoreElements()) {
            FileConnection fc = (FileConnection)e.nextElement();
            InputStream is = fc.openInputStream();
            String mime = (String)this.multipartBinaryData.get(fc);
            StringBuffer headerBuffer = this.getBinaryHeader(fc.getName(), mime);
            log.debug("Writing content-disposition header for file: " + fc.getName());
            os.write(headerBuffer.toString().getBytes());
            this.bytesSent += (long)headerBuffer.toString().getBytes().length;
            if (this.listener != null) {
                this.listener.progress(headerBuffer.length());
            }
            long bytesToWrite = fc.fileSize();
            int totalBytesRead = 0;
            while (bytesToWrite > 0L && !this.doCancel) {
                int bytesToRead = (int)Math.min(2048L, bytesToWrite);
                int bytesRead = is.read(buffer, 0, bytesToRead);
                log.debug(bytesRead + " bytes read from file.");
                if (bytesRead < 0) {
                    throw new IOException("HttpMultipartPost.writeBinaryData(): read requested(" + bytesToRead + ") != actually read(" + bytesRead + ").");
                }
                if (bytesRead <= 0) continue;
                totalBytesRead += bytesRead;
                os.write(buffer, 0, bytesRead);
                bytesToWrite -= (long)bytesRead;
                this.bytesSent += (long)bytesRead;
                if (this.listener == null) continue;
                this.listener.progress(bytesRead);
            }
            if (this.doCancel) {
                log.debug("Upload cancelled!");
                return;
            }
            log.debug("Writing multipart package end.");
            os.write("\r\n".getBytes());
            this.bytesSent += (long)"\r\n".getBytes().length;
        }
    }

    protected StringBuffer getBinaryHeader(String filename, String mime) {
        StringBuffer headerBuffer = new StringBuffer("");
        headerBuffer.append(MULTIPART_BOUNDRY);
        headerBuffer.append(CONTENT_DISPOSITION_HEADER_BINARY_PART1);
        headerBuffer.append(filename);
        headerBuffer.append(CONTENT_DISPOSITION_HEADER_BINARY_PART2);
        headerBuffer.append(mime);
        headerBuffer.append(CONTENT_DISPOSITION_HEADER_BINARY_PART3);
        return headerBuffer;
    }

    public void preparePostData(Vector args) {
        if (null == args || args.size() == 0) {
            return;
        }
        this.data = new byte[args.size() * 3][];
        Enumeration enu = args.elements();
        int i = 0;
        while (enu.hasMoreElements()) {
            MultipartPostArgItem tmp = (MultipartPostArgItem)enu.nextElement();
            String multipartPostData = "-----------------------------4664151417711\r\nContent-Disposition: form-data; name=\"" + tmp.getName() + CONTENT_DISPOSITION_HEADER_PART2;
            this.data[i * 3] = multipartPostData.getBytes();
            multipartPostData = tmp.getData();
            if (MiscUtil.isEmpty(tmp.getEncoding())) {
                this.data[i * 3 + 1] = multipartPostData.getBytes();
            } else {
                try {
                    this.data[i * 3 + 1] = multipartPostData.getBytes(tmp.getEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    log.debug("preparePostData()", e);
                    this.data[i * 3 + 1] = multipartPostData.getBytes();
                }
            }
            multipartPostData = "\r\n";
            this.data[i * 3 + 2] = multipartPostData.getBytes();
            ++i;
        }
    }
}

