/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

import com.fw.j2me.util.SyncQueue;
import com.fw.j2me.util.log.CntLog;
import java.util.Vector;

public class LoopSyncQueue
extends SyncQueue {
    private static CntLog log = new CntLog("LoopSyncQueue");
    private int[] maxSize;

    public LoopSyncQueue(int[] maxSize) {
        super(maxSize.length);
        this.maxSize = maxSize;
        for (int i = 0; i < maxSize.length; ++i) {
            if (0 < maxSize[i]) continue;
            this.maxSize[i] = Integer.MAX_VALUE;
        }
        this.printMaxSizes();
    }

    private void printMaxSizes() {
        String ret = "// wyxp : in LoopSyncQueue.printMaxSizes() ";
        for (int i = 0; i < this.maxSize.length; ++i) {
            ret = ret + " " + i + "=" + this.maxSize[i];
        }
        log.debug(ret);
    }

    private synchronized void removeOldest(int level) {
        if (this.getLevels() <= level) {
            return;
        }
        Vector queue = this.getQueue()[level];
        if (0 < queue.size()) {
            queue.removeElementAt(0);
            this.reduceSize();
        }
    }

    private void limitSize(int level) {
        while (this.getQueue()[level].size() > this.maxSize[level]) {
            this.removeOldest(level);
        }
        this.printMaxSizes();
    }

    public synchronized void put(Object obj) {
        super.put(obj);
        int level = this.getLevels() - 1;
        this.limitSize(level);
    }

    public synchronized void put(Object obj, boolean addToFront, boolean notify) {
        super.put(obj, addToFront, notify);
        this.limitSize(addToFront ? 0 : this.getLevels() - 1);
    }

    public synchronized void put2Tail(Object obj, int level) {
        super.put2Tail(obj, level);
        this.limitSize(level);
        this.printMaxSizes();
    }

    public synchronized void put2Head(Object obj, int level) {
        super.put2Head(obj, level);
        this.limitSize(level);
        this.printMaxSizes();
    }

    public synchronized void setMaxSize(int level, int size) {
        if (0 > level) {
            level = 0;
        }
        if (this.getLevels() <= level) {
            level = this.getLevels() - 1;
        }
        if (size > 0) {
            this.maxSize[level] = size;
            this.limitSize(level);
        }
        this.printMaxSizes();
    }
}

