/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

import com.fw.j2me.util.Deserializable;
import com.fw.j2me.util.Http;
import com.fw.j2me.util.IoUtil;
import com.fw.j2me.util.StringUtil;
import com.fw.j2me.util.log.CntLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Date;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.PushRegistry;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessagePart;
import javax.wireless.messaging.MultipartMessage;
import javax.wireless.messaging.TextMessage;

public class MeUtil {
    private static CntLog log = new CntLog("MeUtil");

    private MeUtil() {
    }

    public static long registerAlarm(MIDlet midlet, int delay) throws ClassNotFoundException, ConnectionNotFoundException {
        return MeUtil.registerAlarm(midlet, System.currentTimeMillis() + (long)(delay * 1000));
    }

    public static long registerAlarm(MIDlet midlet, long time) throws ClassNotFoundException, ConnectionNotFoundException {
        log.debug("MidletUtil.registerAlarm: time = " + new Date(time));
        return PushRegistry.registerAlarm((String)midlet.getClass().getName(), (long)time);
    }

    public static long cancelRegisterAlarm(MIDlet midlet) throws ClassNotFoundException, ConnectionNotFoundException {
        log.debug("MidletUtil.cancelRegisterAlarm: Entering...");
        return PushRegistry.registerAlarm((String)midlet.getClass().getName(), (long)0L);
    }

    public static boolean cancelRequset(MIDlet midlet) throws ConnectionNotFoundException {
        return midlet.platformRequest("");
    }

    public static boolean openBrowser(MIDlet midlet, String url) throws ConnectionNotFoundException, Exception {
        log.debug("MidletUtil.openBrowser: url=" + url);
        if (!url.startsWith("http://")) {
            if (url.indexOf("://") >= 0) {
                throw new Exception("Invalid url: " + url);
            }
            url = "http://" + url;
        }
        return midlet.platformRequest(url);
    }

    public static boolean voiceCall(MIDlet midlet, String msisdn) throws ConnectionNotFoundException, Exception {
        log.debug("MidletUtil.voiceCall: msisdn=" + msisdn);
        String str = msisdn.trim();
        String subStr = null;
        subStr = str.startsWith("+") ? str.substring(1) : str;
        if (!StringUtil.isDigit(subStr)) {
            throw new Exception("Invalid msisdn: " + msisdn);
        }
        return midlet.platformRequest("tel:" + str);
    }

    public static byte[] getImageByteArrayFromUrl(String imageUrl) throws IOException {
        HttpConnection hc = (HttpConnection)Connector.open((String)imageUrl);
        InputStream is = hc.openInputStream();
        log.debug("IoUtil.getImageFromUrl: length=" + hc.getLength());
        byte[] b = IoUtil.readInputStream(is, hc.getLength());
        is.close();
        hc.close();
        return b;
    }

    public static Image getImageFromUrl(String imageUrl) throws Exception {
        byte[] b = MeUtil.getImageByteArrayFromUrl(imageUrl);
        return Image.createImage((byte[])b, (int)0, (int)b.length);
    }

    public static Image getImage(byte[] buf) {
        if (buf == null || buf.length == 0) {
            return null;
        }
        log.debug("MeUtil.getImage:[buf.length=" + buf.length + "]");
        return Image.createImage((byte[])buf, (int)0, (int)buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendTextSms(String msisdn, String msg) throws IOException, InterruptedIOException {
        String addr = msisdn;
        if (!msisdn.startsWith("sms://")) {
            addr = "sms://" + msisdn;
        }
        log.info("=> IoUtil.sendTextSms(" + addr + ", " + msg + ")");
        MessageConnection con = null;
        try {
            con = (MessageConnection)Connector.open((String)addr);
            TextMessage tm = (TextMessage)con.newMessage("text");
            tm.setPayloadText(msg);
            con.send((Message)tm);
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message receiveTextMessage(String addr) throws IOException, InterruptedIOException {
        MessageConnection con = null;
        try {
            con = (MessageConnection)Connector.open((String)addr);
            Message message = con.receive();
            return message;
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMms(String msisdn, String subject, String msg, byte[] bImg) throws IOException {
        String addr = msisdn;
        if (!msisdn.startsWith("mms://")) {
            addr = "mms://" + msisdn;
        }
        log.debug("IoUtil.sendMms: addr=" + addr);
        MessageConnection c = (MessageConnection)Connector.open((String)addr);
        try {
            String enc = "UTF-8";
            MessagePart txt = new MessagePart(msg.getBytes("UTF-8"), "text/plain", "<c01>", "msg.txt", "UTF-8");
            MessagePart png = new MessagePart(bImg, 0, bImg.length, "image/png", "<c02>", "location", null);
            MultipartMessage mms = (MultipartMessage)c.newMessage("multipart");
            mms.setSubject(subject);
            mms.addMessagePart(txt);
            mms.addMessagePart(png);
            c.send((Message)mms);
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromFile(Deserializable data, String fileUrl) throws Exception {
        FileConnection fc = (FileConnection)Connector.open((String)fileUrl);
        if (!fc.exists()) {
            throw new RuntimeException(fileUrl + " not found");
        }
        InputStream is = null;
        try {
            is = fc.openInputStream();
            data.deserialize(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
            fc.close();
        }
    }

    public static void loadFromUrl(Deserializable data, String url) throws Exception {
        String MIME_BINSTREAM = "application/octet-stream";
        Http http = new Http();
        http.setReplyData(data);
        http.setThrowIfNotOk(true);
        http.setExpectedType("application/octet-stream");
        http.get(url);
    }
}

