/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util;

import com.fw.j2me.util.Comparator;
import com.fw.j2me.util.log.CntLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Timer;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.rms.RecordStore;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public class MiscUtil {
    private static CntLog log;
    public static Timer globalTimer;
    public static boolean supportCustomUTF8;
    public static boolean removeHTTPHeaders;
    public static boolean enableLongDate;
    public static boolean applyTimeZone;
    private static char[] map1;
    private static byte[] map2;
    private static final char[] CRYPTKEY;
    public static boolean stopAddressbook;
    public static final int SCALE_RULER_DST_1 = 40000;
    public static final int SCALE_RULER_DST_2 = 400;
    public static final int SCALE_RULER_SRC_1 = 10000;
    public static final int SCALE_RULER_SRC_2 = 90000;
    private static final char[] HEX_CHARS;

    private MiscUtil() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmpty(Vector vec) {
        return vec == null || vec.isEmpty();
    }

    public static String removeWVFromContactID(String contactID) {
        int idx = contactID.indexOf("wv:");
        if (idx != -1) {
            return contactID.substring(idx + 3);
        }
        return contactID;
    }

    public static String removeWVFromPublicChatRoom(String roomName) {
        if (MiscUtil.isEmpty(roomName)) {
            return "";
        }
        int idx = roomName.indexOf("wv:/");
        if (idx != -1) {
            return roomName.substring(idx + 4);
        }
        idx = roomName.indexOf("wv:");
        if (idx != -1) {
            return roomName.substring(idx + 3);
        }
        return roomName;
    }

    public static String removePrivateChatRoomWVandSuffix(String roomName) {
        String name = roomName;
        if (MiscUtil.isEmpty(name)) {
            return "";
        }
        int idx = name.indexOf("wv:");
        if (idx != -1) {
            name = name.substring(idx + 3);
        }
        if ((idx = name.indexOf("/")) != -1) {
            name = name.substring(0, idx);
        }
        return name;
    }

    public static boolean hasPattern(String str, String pattern) {
        return str.indexOf(pattern) != -1;
    }

    public static int parseInt(String intStr, int defaultValue) {
        try {
            return Integer.parseInt(intStr);
        }
        catch (Exception e) {
            log.warn("Invalid intStr=" + intStr);
            return defaultValue;
        }
    }

    public static String replaceString(String oldStr, String pattern, String replacement) {
        if (oldStr == null) {
            return oldStr;
        }
        StringBuffer sb = new StringBuffer();
        int iStart = 0;
        int idx = 0;
        while ((idx = oldStr.indexOf(pattern, iStart)) != -1) {
            sb.append(oldStr.substring(iStart, idx)).append(replacement);
            iStart = idx + pattern.length();
        }
        sb.append(oldStr.substring(iStart));
        return sb.toString();
    }

    public static String[] splitStringList(String str, char sep) {
        if (str == null) {
            return null;
        }
        if (MiscUtil.isEmpty(str)) {
            return new String[0];
        }
        Object[] strary = null;
        try {
            int cur = -1;
            Vector<String> vec = new Vector<String>();
            while (str.length() > 0) {
                String token;
                cur = str.indexOf(sep);
                if (cur == -1) {
                    cur = str.length();
                }
                if ((token = str.substring(0, cur)).equals("NULL")) {
                    token = null;
                }
                vec.addElement(token);
                str = cur < str.length() - 1 ? str.substring(cur + 1) : "";
            }
            if (vec.size() > 0) {
                strary = new String[vec.size()];
                vec.copyInto(strary);
            }
        }
        catch (Exception e) {
            log.error("splitStringList failed", e);
        }
        return strary;
    }

    public static String assembleStringList(String[] strList) {
        String str = "";
        for (int i = 0; i < strList.length; ++i) {
            String value = strList[i];
            if (value == null) {
                value = "NULL";
            }
            str = i == 0 ? value : str + '\t' + value;
        }
        return str;
    }

    public static int hasSameValue(Vector v) {
        if (v.size() < 1) {
            return -1;
        }
        for (int i = 0; i < v.size() - 1; ++i) {
            String value = (String)v.elementAt(i);
            for (int j = i + 1; j < v.size(); ++j) {
                if (!value.equals((String)v.elementAt(j))) continue;
                return j;
            }
        }
        return -1;
    }

    public static boolean sendSMS(String phoneNumber, String msg) {
        MessageConnection smsconn = null;
        try {
            for (int i = 1; i < phoneNumber.length(); ++i) {
                if (phoneNumber.charAt(i) >= '0' && phoneNumber.charAt(i) <= '9') continue;
                phoneNumber = phoneNumber.substring(0, i) + phoneNumber.substring(i + 1);
            }
            String address = "sms://" + phoneNumber + ":50000";
            log.debug(address);
            smsconn = (MessageConnection)Connector.open((String)address);
            TextMessage txtmessage = (TextMessage)smsconn.newMessage("text");
            txtmessage.setAddress(address);
            txtmessage.setPayloadText(msg);
            smsconn.send((Message)txtmessage);
        }
        catch (Exception e) {
            log.debug("Send caught: ", e);
        }
        MiscUtil.close(smsconn);
        return true;
    }

    public static String encodeString(String s) {
        return new String(MiscUtil.encode(s.getBytes(), s.getBytes().length));
    }

    public static char[] encode(byte[] in, int iLen) {
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iLen ? in[ip++] & 0xFF : 0;
            int i2 = ip < iLen ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : 61;
            int n = ++op < oDataLen ? map1[o3] : 61;
            out[op] = n;
            ++op;
        }
        return out;
    }

    public static String getClientTime() {
        return MiscUtil.changeDateToString(Calendar.getInstance().getTime());
    }

    public static String changeDateToString(Date date) {
        if (enableLongDate) {
            return date == null ? null : date.toString().substring(4, 19);
        }
        return date == null ? null : date.toString().substring(11, 19);
    }

    public static int getColor(int r, int g, int b) {
        return (r << 16) + (g << 8) + b;
    }

    public static boolean checkEmail(String str) {
        char at = '@';
        char dot = '.';
        int lat = str.indexOf(at);
        int lstr = str.length();
        int ldot = str.indexOf(dot);
        if (lat == -1 || lat == 0 || str.charAt(lstr - 1) == at) {
            return false;
        }
        if (ldot == -1 || ldot == 0 || str.charAt(lstr - 1) == dot) {
            return false;
        }
        if (str.indexOf(at, lat + 1) != -1) {
            return false;
        }
        if (str.charAt(lat - 1) == dot || str.charAt(lat + 1) == dot) {
            return false;
        }
        if (str.indexOf(dot, lat + 2) == -1) {
            return false;
        }
        if (str.indexOf(" ") != -1) {
            return false;
        }
        return str.indexOf("..") == -1;
    }

    public static String parseDateTime(String dt) {
        if (enableLongDate) {
            return dt.substring(6, 8) + "/" + dt.substring(4, 6) + "/" + dt.substring(0, 4) + " " + dt.substring(9, 11) + ":" + dt.substring(11, 13);
        }
        return dt.substring(9, 11) + ":" + dt.substring(11, 13) + ":" + dt.substring(13, 15);
    }

    public static Vector vectorize(Hashtable hash) {
        Vector res = new Vector();
        Enumeration enu = hash.elements();
        while (enu.hasMoreElements()) {
            res.addElement(enu.nextElement());
        }
        return res;
    }

    public static void addElements(Vector into, Vector from) {
        for (int i = 0; i < from.size(); ++i) {
            if (into.contains(from.elementAt(i))) continue;
            into.addElement(from.elementAt(i));
        }
    }

    public static final String parseServerDate(String date) {
        int foundIndex;
        long clientCurrentTime = System.currentTimeMillis();
        if (applyTimeZone) {
            clientCurrentTime += (long)Calendar.getInstance().getTimeZone().getRawOffset();
        }
        long clientmsgTime = clientCurrentTime;
        if (date != null && (foundIndex = date.indexOf(45)) > -1) {
            long serverCurrentTime = Long.parseLong(date.substring(0, foundIndex)) * 1000L;
            long serverMsgTime = Long.parseLong(date.substring(foundIndex + 1)) * 1000L;
            long diff = serverCurrentTime - serverMsgTime;
            clientmsgTime = clientCurrentTime - diff;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(clientmsgTime));
        int hour = calendar.get(11);
        int second = calendar.get(13);
        int minute = calendar.get(12);
        int dayOfMonth = calendar.get(5);
        int month = calendar.get(2) + 1;
        if (enableLongDate) {
            return (dayOfMonth < 10 ? "0" : "") + dayOfMonth + "/" + (month < 10 ? "0" : "") + month + "/" + calendar.get(1) + " " + (hour < 10 ? "0" : "") + hour + ":" + (minute < 10 ? "0" : "") + minute;
        }
        return (hour < 10 ? "0" : "") + hour + ":" + (minute < 10 ? "0" : "") + minute + ":" + (second < 10 ? "0" : "") + second;
    }

    public static final String getClientTimes() {
        long timeL = System.currentTimeMillis();
        if (applyTimeZone) {
            timeL += (long)Calendar.getInstance().getTimeZone().getRawOffset();
        }
        String time = "" + (timeL /= 1000L) + "-" + timeL;
        return time;
    }

    public static String getCurrentTime() {
        return MiscUtil.parseServerDate(MiscUtil.getClientTimes());
    }

    public static void closeRecordStore(RecordStore rs) {
        try {
            if (rs != null) {
                rs.closeRecordStore();
            }
        }
        catch (Exception e) {
            log.error("Failed to close record store ", e);
        }
    }

    public static String boolean2String(boolean bValue) {
        return bValue ? "T" : "F";
    }

    public static boolean string2Boolean(String sValue) {
        return sValue.equals("T") || sValue.equals("t");
    }

    public static void sleep(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (Exception e) {
            log.debug("sleep ", e);
        }
    }

    public static byte[] getUTF8Bytes(String str) {
        if (supportCustomUTF8) {
            char[] chars = new char[str.length()];
            str.getChars(0, str.length(), chars, 0);
            return MiscUtil.convertToBytes(chars);
        }
        try {
            return str.getBytes("UTF-8");
        }
        catch (Throwable e) {
            log.error("connection.Session#getUTF8Bytes()", e);
            return str.getBytes();
        }
    }

    public static String getUTF8String(byte[] buf) {
        if (supportCustomUTF8) {
            String res = null;
            try {
                res = new String(MiscUtil.convertToChars(buf));
            }
            catch (Exception ex) {
                log.error("connection.Session#getUTF8String()1", ex);
                res = new String(buf);
            }
            if (removeHTTPHeaders && res != null) {
                res = MiscUtil.removeHttpHeaders(res);
            }
            return res;
        }
        try {
            return new String(buf, "UTF-8");
        }
        catch (Exception e) {
            log.error("connection.Session#getUTF8String()2", e);
            return new String(buf);
        }
    }

    private static byte[] convertToBytes(char[] buf) {
        int bufOffset = 0;
        int len = buf.length;
        int blen = MiscUtil.bytesInCharArray(buf);
        byte[] bbuf = new byte[blen];
        int bbufOffset = 0;
        for (int i = bufOffset; i < bufOffset + len; ++i) {
            if (buf[i] <= '\u007f') {
                bbuf[bbufOffset] = (byte)(buf[i] & 0xFF);
                ++bbufOffset;
                continue;
            }
            if (buf[i] <= '\u07ff') {
                bbuf[bbufOffset] = (byte)(0xC0 | buf[i] >> 6 & 0x3F);
                bbuf[++bbufOffset] = (byte)(0x80 | buf[i] & 0x3F);
                ++bbufOffset;
                continue;
            }
            bbuf[bbufOffset] = (byte)(0xE0 | buf[i] >> 12 & 0xF);
            bbuf[++bbufOffset] = (byte)(0x80 | buf[i] >> 6 & 0x3F);
            bbuf[++bbufOffset] = (byte)(0x80 | buf[i] & 0x3F);
            ++bbufOffset;
        }
        return bbuf;
    }

    private static char[] convertToChars(byte[] buf) throws Exception {
        int bufOffset = 0;
        int len = buf.length;
        int clen = MiscUtil.charsInByteArray(buf);
        char[] cbuf = new char[clen];
        int cbufOffset = 0;
        for (int i = bufOffset; i < bufOffset + len; ++i) {
            int val;
            if ((buf[i] & 0xE0) == 224) {
                if (i + 2 >= buf.length) {
                    throw new Exception("Incomplete input");
                }
                val = (buf[i] & 0xF) << 12;
                if ((buf[++i] & 0x80) != 128) {
                    throw new Exception("Bad input byte: " + buf[i]);
                }
                val |= (buf[i] & 0x3F) << 6;
                if ((buf[++i] & 0x80) != 128) {
                    throw new Exception("Bad input byte: " + buf[i]);
                }
                val |= buf[i] & 0x3F;
            } else if ((buf[i] & 0xC0) == 192) {
                if (i + 1 >= buf.length) {
                    throw new Exception("Incomplete input");
                }
                val = (buf[i] & 0x1F) << 6;
                if ((buf[++i] & 0x80) != 128) {
                    throw new Exception("Bad input byte: " + buf[i]);
                }
                val |= buf[i] & 0x3F;
            } else if ((buf[i] & 0xFF) < 128) {
                val = buf[i];
            } else {
                throw new Exception("Bad input encountered: " + buf[i]);
            }
            cbuf[cbufOffset] = (char)val;
            ++cbufOffset;
        }
        return cbuf;
    }

    private static int charsInByteArray(byte[] buf) throws Exception {
        int offset = 0;
        int len = buf.length;
        int numChars = 0;
        for (int i = offset; i < offset + len; ++i) {
            if ((buf[i] & 0xE0) == 224) {
                if ((i += 2) >= buf.length) {
                    throw new Exception("Incomplete input");
                }
                ++numChars;
                continue;
            }
            if ((buf[i] & 0xC0) == 192) {
                if (++i >= buf.length) {
                    throw new Exception("Incomplete input");
                }
                ++numChars;
                continue;
            }
            if ((buf[i] & 0xFF) < 128) {
                ++numChars;
                continue;
            }
            throw new Exception("Bad input encountered: " + buf[i]);
        }
        return numChars;
    }

    private static int bytesInCharArray(char[] buf) {
        int offset = 0;
        int len = buf.length;
        int numBytes = 0;
        for (int i = offset; i < offset + len; ++i) {
            if (buf[i] <= '\u007f') {
                ++numBytes;
                continue;
            }
            if (buf[i] <= '\u07ff') {
                numBytes += 2;
                continue;
            }
            numBytes += 3;
        }
        return numBytes;
    }

    private static String removeHttpHeaders(String headers) {
        int idx = headers.indexOf("\\r\\n\\r\\n");
        if (idx != -1) {
            headers = (idx += 4) >= headers.length() ? "" : headers.substring(idx);
        }
        return headers.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable t) {
            log.debug("close ", t);
        }
        finally {
            is = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(OutputStream os) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (Throwable t) {
            log.debug("close ", t);
        }
        finally {
            os = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            if (conn instanceof MessageConnection) {
                ((MessageConnection)conn).setMessageListener(null);
            }
            conn.close();
        }
        catch (Throwable t) {
            log.debug("close ", t);
        }
        finally {
            conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized byte[] makeHttp(String url, String content, String contentType) {
        HttpConnection conn;
        InputStream in;
        byte[] res;
        block13: {
            if (url == null) {
                return new byte[0];
            }
            log.debug("make http URL = " + url + " contentType = " + contentType);
            res = null;
            in = null;
            conn = null;
            try {
                log.debug("url=" + url);
                conn = (HttpConnection)Connector.open((String)url, (int)1);
                conn.setRequestMethod("GET");
                if (conn.getResponseCode() == 200) {
                    boolean contentTestSucceed = true;
                    if (contentType != null) {
                        String receivedContentType = conn.getHeaderField("Content-Type");
                        if (MiscUtil.isEmpty(receivedContentType)) {
                            receivedContentType = conn.getHeaderField("content-type");
                        }
                        if (receivedContentType != null && receivedContentType.length() > 0 && receivedContentType.indexOf(contentType) == -1) {
                            contentTestSucceed = false;
                        }
                    }
                    if (contentTestSucceed) {
                        in = conn.openInputStream();
                        res = new byte[(int)conn.getLength()];
                        for (int k = 0; k < res.length; ++k) {
                            res[k] = (byte)(0xFF & in.read());
                        }
                    } else {
                        res = null;
                    }
                    break block13;
                }
                res = null;
            }
            catch (Throwable e) {
                try {
                    log.debug("Throwable in FHTTPConnection.post()", e);
                    res = null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    MiscUtil.close(in);
                    MiscUtil.close(conn);
                }
            }
        }
        MiscUtil.close(in);
        MiscUtil.close((Connection)conn);
        return res;
    }

    public static void insertionSort(Enumeration e, Vector results) {
        Comparator tmp = null;
        while (e.hasMoreElements()) {
            tmp = (Comparator)e.nextElement();
            MiscUtil.insertionSort(tmp, results, 0);
        }
    }

    public static void insertionSort(Comparator o, Vector results, int strategy) {
        Object tempO;
        if (null == o || null == results) {
            return;
        }
        int i = 0;
        Enumeration enu = results.elements();
        while (enu.hasMoreElements() && o.compareTo(tempO = enu.nextElement(), strategy) > 0) {
            ++i;
        }
        results.insertElementAt(o, i);
    }

    public static String readLine(InputStream is) throws IOException {
        int count = 0;
        int c = 0;
        byte[] line = new byte[512000];
        while ((c = is.read()) != -1 && c != 10) {
            line[count++] = (byte)(c & 0xFF);
        }
        return new String(line, 0, count).trim();
    }

    public static String read(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int offset = 0;
        byte[] buf = new byte[16384];
        while ((len = is.read(buf)) != -1) {
            bos.write(buf, 0, len);
            offset += len;
            if (buf[len - 1] == 10) break;
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                log.debug("read() sleep ", e);
            }
        }
        return bos.toString();
    }

    public static void writeLine(String line, OutputStream os) throws IOException {
        log.debug("OS is :" + os);
        if (os != null) {
            os.write(MiscUtil.getUTF8Bytes(line));
            os.flush();
        }
    }

    public static String randomize(long num, long fact) {
        int n;
        String randomed = new String("");
        long oldnum = num = num < 0L ? -num : num;
        int count = 26;
        Random r = new Random();
        int n2 = r.nextInt();
        int n3 = n = n2 > 0 ? n2 : -n2;
        while (num > 0L) {
            int i = (int)(num % 10L);
            num /= 10L;
            int j = (int)(fact % 10L);
            fact /= 10L;
            if (r.nextInt() % 3 != 0) {
                char c;
                char ch = '$';
                switch (i * j % 3) {
                    case 0: {
                        ch = (char)((i + 1) * (j + 1) * c % count + 65);
                        break;
                    }
                    case 1: {
                        ch = (char)((i + 1) * (j + 1) * c % count + 97);
                        break;
                    }
                    case 2: {
                        ch = (char)((i + 1) * c % count + 97);
                        break;
                    }
                }
                c = ch;
                if (!(ch > 'a' && ch <= 'z' || ch > 'A' && ch <= 'Z')) {
                    ch = 'o';
                }
                randomed = randomed.concat(String.valueOf(ch));
                continue;
            }
            randomed = randomed.concat(String.valueOf(i));
        }
        return randomed.equals("") ? String.valueOf(oldnum) : randomed;
    }

    public static String encrypt(String pwd) {
        if (MiscUtil.isEmpty(pwd)) {
            return "";
        }
        byte[] by = pwd.getBytes();
        for (int i = 0; i < by.length; ++i) {
            if (by[i] == 32) {
                by[i] = 47;
            }
            by[i] = (byte)(by[i] ^ CRYPTKEY[i % CRYPTKEY.length]);
            if (by[i] != 47) continue;
            by[i] = 32;
        }
        return new String(by);
    }

    public static int min(int[] x) {
        int ret = Integer.MAX_VALUE;
        for (int i = 1; i < x.length; ++i) {
            ret = ret < x[i] ? ret : x[i];
        }
        return ret;
    }

    public static int max(int[] x) {
        int ret = Integer.MIN_VALUE;
        for (int i = 0; i < x.length; ++i) {
            ret = ret > x[i] ? ret : x[i];
        }
        return ret;
    }

    public static boolean isNumeric(String intStr) {
        int i = intStr.length();
        while (--i >= 0) {
            char chr = intStr.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static String removeDomain(String id) {
        if (id.indexOf("@") != -1) {
            return id.substring(0, id.indexOf("@"));
        }
        return id;
    }

    public static String getDomain(String id) {
        if (id.indexOf("@") != -1) {
            return id.substring(id.indexOf("@") + 1, id.length() - 1);
        }
        return "";
    }

    public static int nextRandomInt(int maxValue) {
        if (maxValue <= 1) {
            return 0;
        }
        int ran = new Random(System.currentTimeMillis()).nextInt();
        if (ran < 0) {
            ran = -ran;
        }
        return ran % maxValue;
    }

    public static String[][] readAddressbook(int type) {
        Vector<String> vector2;
        Vector<String> vector;
        block31: {
            vector = new Vector<String>();
            Vector<String> vectorLowerCase = new Vector<String>();
            vector2 = new Vector<String>();
            ContactList contactlist = null;
            PIM pim = PIM.getInstance();
            stopAddressbook = false;
            try {
                String[] as1 = pim.listPIMLists(1);
                if (as1.length > 0) {
                    contactlist = (ContactList)pim.openPIMList(1, 1, as1[0]);
                }
                if (contactlist == null || !contactlist.isSupportedField(type)) break block31;
                Enumeration enumeration = contactlist.items();
                while (enumeration.hasMoreElements()) {
                    int index;
                    if (stopAddressbook) {
                        stopAddressbook = false;
                        break;
                    }
                    Contact contact = (Contact)enumeration.nextElement();
                    int j = contact.countValues(type);
                    String s = "";
                    for (int k = 0; k < j; ++k) {
                        try {
                            String s1 = contact.getString(type, k);
                            if (null != s1) {
                                s = s1;
                            }
                        }
                        catch (Throwable t) {
                            log.debug("readAddressbook ", t);
                        }
                        if (115 == type) {
                            if (s.startsWith("+")) {
                                s = s.substring(1);
                            }
                            while (s.startsWith("0")) {
                                s = s.substring(1);
                            }
                        }
                        if (s != null && s.length() > 0 && contact.getAttributes(type, k) == 16) break;
                    }
                    if (s == null || s.length() <= 0) continue;
                    StringBuffer s2 = new StringBuffer();
                    String firstName = "";
                    String lastName = "";
                    if (contactlist.isSupportedField(106)) {
                        j = contact.countValues(106);
                        for (int l = 0; l < j; ++l) {
                            try {
                                String[] as3 = contact.getStringArray(106, l);
                                if (null == as3) continue;
                                if (as3.length > 0 && as3[0] != null) {
                                    firstName = as3[0];
                                }
                                if (as3.length > 1 && as3[1] != null) {
                                    lastName = as3[1];
                                }
                                if (firstName.length() > 0) {
                                    s2.append(firstName);
                                }
                                if (lastName.length() <= 0) continue;
                                if (s2.length() > 0) {
                                    s2.append(" ");
                                }
                                s2.append(lastName);
                                continue;
                            }
                            catch (Throwable t) {
                                log.debug("readAddressbook ", t);
                            }
                        }
                    }
                    boolean formattedNameSupport = contactlist.isSupportedField(105);
                    if (s2.length() == 0 && formattedNameSupport) {
                        j = contact.countValues(105);
                        for (int i1 = 0; i1 < j; ++i1) {
                            try {
                                String s3 = contact.getString(105, i1);
                                if (null == s3 || s3.length() <= 0) continue;
                                s2.append(s3);
                                continue;
                            }
                            catch (Exception t) {
                                log.debug("readAddressbook ", t);
                            }
                        }
                    }
                    if (s2.length() == 0 && contactlist.isSupportedField(107)) {
                        try {
                            j = contact.countValues(107);
                        }
                        catch (Throwable t) {
                            log.debug("readAddressbook ", t);
                        }
                        for (int j1 = 0; j1 < j; ++j1) {
                            try {
                                String s4 = contact.getString(107, j1);
                                if (null == s4 || s4.length() <= 0) continue;
                                s2.append(" " + s4);
                                continue;
                            }
                            catch (Throwable t) {
                                log.debug("readAddressbook ", t);
                            }
                        }
                    }
                    s = s.trim();
                    String s2Str = s2.toString().trim();
                    if (s2Str.length() <= 0) continue;
                    String s2StrLower = s2Str.toLowerCase();
                    for (index = vector.size() - 1; index >= 0; --index) {
                        String strLower = (String)vectorLowerCase.elementAt(index);
                        String str = (String)vector.elementAt(index);
                        int test = s2StrLower.compareTo(strLower);
                        if (test > 0 || test == 0 && s2Str.compareTo(str) > 0) break;
                    }
                    vector2.insertElementAt(s, ++index);
                    vectorLowerCase.insertElementAt(s2Str.toLowerCase(), index);
                    vector.insertElementAt(s2Str, index);
                }
            }
            catch (Throwable t) {
                log.debug("readAddressbook ", t);
            }
        }
        String[][] resStr = new String[2][vector.size()];
        vector.copyInto(resStr[0]);
        vector2.copyInto(resStr[1]);
        return resStr;
    }

    public static int countCharInString(String str, char ch) {
        int iRtn = 0;
        char[] chArr = str.toCharArray();
        for (int i = 0; i < chArr.length; ++i) {
            if (chArr[i] != ch) continue;
            ++iRtn;
        }
        return iRtn;
    }

    public static int searchIndex(String[] strings, String key, int offSet, boolean next, boolean self) {
        if (strings == null || strings.length < 1) {
            return -1;
        }
        int len = strings.length;
        if (offSet >= len || offSet < 0) {
            offSet = 0;
        }
        if (self && strings[offSet].toLowerCase().indexOf(key.toLowerCase()) >= 0) {
            return offSet;
        }
        int val = len + (next ? 1 : -1);
        int i = (offSet + val) % len;
        while (i != offSet) {
            if (strings[i].toLowerCase().indexOf(key.toLowerCase()) >= 0) {
                return i;
            }
            i = (i + val) % len;
        }
        return -1;
    }

    public static Date parseStringToDate(String dateStr) {
        Date date;
        Calendar cal = Calendar.getInstance();
        try {
            cal.set(11, Integer.valueOf(dateStr.substring(0, 2)));
            cal.set(12, Integer.valueOf(dateStr.substring(3, 5)));
            cal.set(13, Integer.valueOf(dateStr.substring(6)));
            date = cal.getTime();
        }
        catch (Exception e) {
            log.error("Time string format is incorrect. Expected: YYYYMMDDTHHMMSS. Actual:" + dateStr);
            date = new Date();
        }
        return date;
    }

    public static String timeToString(long time) {
        if (time < 1L) {
            return "";
        }
        String date = new Date(time).toString();
        String res = date.substring(11, 19);
        return res;
    }

    public static String duratioin2String(long duration) {
        String strTime = "" + (duration /= 1000000L) % 10L;
        strTime = (duration /= 10L) % 6L + strTime;
        strTime = (duration /= 6L) % 10L + ":" + strTime;
        strTime = (duration /= 10L) % 6L + strTime;
        if ((duration /= 6L) > 0L) {
            strTime = duration % 10L + ":" + strTime;
            strTime = (duration /= 10L) % 6L + strTime;
            duration /= 6L;
        }
        return strTime;
    }

    public static long string2Duration(String strTime) {
        long duration = 0L;
        int sec = 0;
        int min = 0;
        int hour = 0;
        try {
            int index = strTime.lastIndexOf(58);
            if (index != -1) {
                sec = Integer.parseInt(strTime.substring(index + 1));
                strTime = strTime.substring(0, index);
            } else {
                sec = Integer.parseInt(strTime);
            }
            if (index > 0) {
                index = strTime.lastIndexOf(58);
                if (index != -1) {
                    min = Integer.parseInt(strTime.substring(index + 1));
                    strTime = strTime.substring(0, index);
                } else {
                    min = Integer.parseInt(strTime);
                }
            }
            if (index > 0) {
                hour = Integer.parseInt(strTime);
            }
            duration = (hour * 3600 + min * 60 + sec) * 1000000;
        }
        catch (RuntimeException e) {
            log.error("bad format: " + strTime);
        }
        return duration;
    }

    public static String[] explode(String separator, String str) {
        if (str == null) {
            return null;
        }
        Vector arr = MiscUtil.explodeVector(separator, str);
        Object[] res = new String[arr.size()];
        arr.copyInto(res);
        return res;
    }

    public static Vector explodeVector(String separator, String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        int indexS = str.indexOf(separator);
        Vector<String> arr = new Vector<String>();
        while (indexS >= 0 && str.length() > 0) {
            if (indexS == 0) {
                str = str.substring(1);
            } else {
                arr.addElement(str.substring(0, indexS).trim());
                str = str.substring(indexS);
            }
            indexS = str.indexOf(separator);
        }
        if ((str = str.trim()).length() > 0) {
            arr.addElement(str);
        }
        return arr;
    }

    public static boolean isInArea(int xAreaA, int yAreaA, int widthAreaA, int heightAreaA, int xAreaB, int yAreaB, int widthAreaB, int heightAreaB) {
        return xAreaA >= xAreaB && yAreaA >= yAreaB && xAreaA + widthAreaA <= xAreaB + widthAreaB && yAreaA + heightAreaA <= yAreaB + heightAreaB;
    }

    public static int lastIndexOf(String str, String subString) {
        int index = str.indexOf(subString);
        int subStrLen = subString.length();
        int lastIndex = index;
        while (index != -1) {
            lastIndex = index;
            index = str.indexOf(subString, index + subStrLen);
        }
        return lastIndex;
    }

    public static String getLoginIdFromSessionId(String sessionid) {
        if (!MiscUtil.isEmpty(sessionid) && sessionid.indexOf("#") != -1) {
            return MiscUtil.removeWVFromContactID(sessionid.substring(0, sessionid.indexOf("#")));
        }
        return "";
    }

    public static int summate(int[] data) {
        int ret = 0;
        for (int i = 0; i < data.length; ++i) {
            ret += data[i];
        }
        return ret;
    }

    public static int mod(int number, int mod) {
        return 0 == mod ? 0 : (number >= 0 ? number % mod : number % mod + mod);
    }

    public static Image scaleImg(int maxW, int maxH, Image src) {
        int dstH;
        int srcW = src.getWidth();
        int dstW = maxW;
        int srcH = src.getHeight();
        if (dstW * srcH != (dstH = maxH) * srcW) {
            if (dstW * srcH / srcW < dstH) {
                dstW = dstH * srcW / srcH;
            } else {
                dstH = dstW * srcH / srcW;
            }
        }
        return MiscUtil.scaleImg(src, srcW, dstH);
    }

    public static Image scaleImg(Image src, int dstW, int dstH) {
        int dstSize;
        int srcSize = src.getWidth() * src.getHeight();
        if (srcSize < (dstSize = dstW * dstH)) {
            if (dstSize < 40000) {
                return MiscUtil.scaleImg1(src, dstW, dstH);
            }
            return MiscUtil.scaleImg2(src, dstW, dstH);
        }
        if (srcSize < 10000) {
            return MiscUtil.scaleImg1(src, dstW, dstH);
        }
        if (srcSize < 90000) {
            if (dstSize < 400) {
                return MiscUtil.scaleImg22(src, dstW, dstH);
            }
            return MiscUtil.scaleImg1(src, dstW, dstH);
        }
        return MiscUtil.scaleImg22(src, dstW, dstH);
    }

    public static Image scaleImg1(Image src, int dstW, int dstH) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (width == dstW && height == dstH) {
            return src;
        }
        int[] pixels = new int[width * height];
        src.getRGB(pixels, 0, width, 0, 0, width, height);
        int[] target = new int[dstW * dstH];
        int[] w = new int[dstW];
        for (int i = 0; i < dstW; ++i) {
            w[i] = width * i / dstW;
        }
        int lineHead = 0;
        int index = 0;
        for (int i = 0; i < dstH; ++i) {
            lineHead = height * i / dstH * width;
            for (int j = 0; j < dstW; ++j) {
                target[index++] = pixels[lineHead + w[j]];
            }
        }
        Image ret = Image.createRGBImage((int[])target, (int)dstW, (int)dstH, (boolean)true);
        return ret;
    }

    public static Image scaleImg2(Image src, int dstW, int dstH) {
        return MiscUtil.getScaleH(MiscUtil.getScaleW(src, dstW), dstH);
    }

    public static Image scaleImg22(Image src, int dstW, int dstH) {
        return MiscUtil.getScaleW(MiscUtil.getScaleH(src, dstH), dstW);
    }

    private static Image getScaleW(Image src, int dstW) {
        int srcW = src.getWidth();
        if (dstW == srcW) {
            return src;
        }
        int srcH = src.getHeight();
        Image buf1 = Image.createImage((int)dstW, (int)srcH);
        Graphics bg = buf1.getGraphics();
        for (int x = 0; x < dstW; ++x) {
            bg.setClip(x, 0, 1, srcH);
            bg.drawImage(src, x - x * srcW / dstW, 0, 0);
        }
        return buf1;
    }

    private static Image getScaleH(Image src, int dstH) {
        int srcH = src.getHeight();
        if (dstH == srcH) {
            return src;
        }
        int srcW = src.getWidth();
        Image buf2 = Image.createImage((int)srcW, (int)dstH);
        Graphics bg = buf2.getGraphics();
        for (int y = 0; y < dstH; ++y) {
            bg.setClip(0, y, srcW, 1);
            bg.drawImage(src, 0, y - y * srcH / dstH, 0);
        }
        return buf2;
    }

    public static String toHexString(byte b) {
        int value = b & 0xFF;
        StringBuffer buffer = new StringBuffer("");
        buffer.append(HEX_CHARS[value >> 4]);
        buffer.append(HEX_CHARS[value & 0xF]);
        return buffer.toString();
    }

    public static String toHexString(byte[] array) {
        return MiscUtil.toHexString(array, 0, array.length);
    }

    public static String toHexString(byte[] array, int offset, int length) {
        if (array == null || array.length == 0 || length > array.length || offset + length > array.length) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(2 * length);
        for (int i = offset; i < length; ++i) {
            buffer.append(MiscUtil.toHexString(array[i]));
        }
        return buffer.toString();
    }

    public static String encodeUrl(String url) {
        StringBuffer buffer = new StringBuffer();
        int length = url.length();
        for (int i = 0; i < length; ++i) {
            char c = url.charAt(i);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '-' || c == '_' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')') {
                buffer.append(c);
                continue;
            }
            if (c == '.') {
                buffer.append("%2E");
                continue;
            }
            if (c == ' ') {
                buffer.append('+');
                continue;
            }
            if (c <= '\u007f') {
                buffer.append("%" + MiscUtil.toHexString((byte)c));
                continue;
            }
            if (c <= '\u07ff') {
                buffer.append("%" + MiscUtil.toHexString((byte)(0xC0 | c >> 6)));
                buffer.append("%" + MiscUtil.toHexString((byte)(0x80 | c & 0x3F)));
                continue;
            }
            buffer.append("%" + MiscUtil.toHexString((byte)(0xE0 | c >> 12)));
            buffer.append("%" + MiscUtil.toHexString((byte)(0x80 | c >> 6 & 0x3F)));
            buffer.append("%" + MiscUtil.toHexString((byte)(0x80 | c & 0x3F)));
        }
        return buffer.toString();
    }

    public static String decodeUrl(String url) {
        try {
            byte[] tmp = new byte[url.length()];
            char[] cs = url.toCharArray();
            int j = 0;
            int i = 0;
            while (i < cs.length) {
                if ('%' == cs[i]) {
                    tmp[j] = (byte)Integer.parseInt(url.substring(i + 1, i + 3), 16);
                    i += 2;
                } else {
                    tmp[j] = (byte)cs[i];
                }
                ++i;
                ++j;
            }
            return new String(tmp, 0, j, "UTF-8");
        }
        catch (Exception e) {
            log.debug("decodeUrl ", e);
            return url;
        }
    }

    public static boolean isEmpty(String[] strs) {
        return null == strs || strs.length <= 0;
    }

    public static String getSizeStr(long size) {
        int index;
        String ret = "";
        String suf = "";
        if (size >= 0L) {
            if (size < 1024L) {
                ret = "" + size;
                suf = "B";
            } else if (size < 0x100000L) {
                ret = "" + (size >> 10) + "." + (int)(size % 1024L * 100L / 1024L);
                suf = "KB";
            } else if (size < 0x40000000L) {
                ret = "" + ((size >>= 10) >> 10) + "." + (int)(size % 1024L * 100L / 1024L);
                suf = "MB";
            } else {
                ret = "" + ((size >>= 20) >> 10) + "." + (int)(size % 1024L * 100L / 1024L);
                suf = "GB";
            }
        }
        if (0 < (index = ret.indexOf(46))) {
            if (index > 2) {
                ret = ret.substring(0, index);
            } else if (ret.length() > 4) {
                ret = ret.substring(0, 4);
            }
        }
        return ret + suf;
    }

    public static String guessContentType(String url) throws Exception {
        String ext = "";
        String ct = "";
        int lastDot = url.lastIndexOf(46);
        if (lastDot >= 0) {
            ext = url.substring(lastDot + 1).toLowerCase();
        }
        if (ext.equals("mpg") || ext.equals("avi")) {
            ct = "video/mpeg";
        } else if (ext.equals("mid") || ext.equals("kar")) {
            ct = "audio/midi";
        } else if (ext.equals("wav")) {
            ct = "audio/x-wav";
        } else if (ext.equals("jts")) {
            ct = "audio/x-tone-seq";
        } else if (ext.equals("txt")) {
            ct = "audio/x-txt";
        } else if (ext.equals("amr")) {
            ct = "audio/amr";
        } else if (ext.equals("awb")) {
            ct = "audio/amr-wb";
        } else if (ext.equals("gif")) {
            ct = "image/gif";
        } else if (ext.equals("3gp")) {
            ct = "video/3gpp";
        } else if (ext.equals("mp4")) {
            ct = "video/mp4";
        }
        return ct;
    }

    public static String getFileNameFromUrl(String url) {
        int begin;
        String ret = "";
        if (MiscUtil.isEmpty(url)) {
            return ret;
        }
        if (url.indexOf("?") > 0) {
            url = url.substring(0, url.indexOf("?"));
        }
        if ((begin = url.lastIndexOf(47)) < 0) {
            begin = 0;
        } else {
            if (url.length() == begin + 1) {
                return "";
            }
            ++begin;
        }
        ret = url.substring(begin);
        return ret;
    }

    public static boolean isEmpty(Object[] array) {
        return null == array || 0 == array.length;
    }

    public static boolean isEmpty(byte[] b) {
        return null == b || 0 == b.length;
    }

    static {
        int c;
        log = new CntLog("MiscUtil");
        supportCustomUTF8 = false;
        removeHTTPHeaders = false;
        enableLongDate = false;
        applyTimeZone = false;
        map1 = new char[64];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            MiscUtil.map1[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            MiscUtil.map1[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            MiscUtil.map1[i++] = c;
        }
        MiscUtil.map1[i++] = 43;
        MiscUtil.map1[i++] = 47;
        map2 = new byte[128];
        for (i = 0; i < map2.length; ++i) {
            MiscUtil.map2[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            MiscUtil.map2[MiscUtil.map1[i]] = (byte)i;
        }
        CRYPTKEY = new char[]{'\u0002', '\u0001'};
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

