/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util.log;

import com.fw.j2me.util.MiscUtil;
import com.fw.j2me.util.log.Logger;
import javax.microedition.rms.RecordStore;

public class CntLog {
    public static final int LOGGER_TYPE_SIMPLE = 0;
    public static final int LOGGER_TYPE_BLUETOOTH = 1;
    public static final int LOGGER_TYPE_FILE = 2;
    public static final int LEVEL_OFF = 0;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_DEBUG = 4;
    public static final int LEVEL_TRACE = 5;
    private String className;
    public static String logPath = null;
    public static String logNameInRMS = "logger";

    public CntLog(String className) {
        int idx = className.lastIndexOf(46);
        idx = className.lastIndexOf(46, idx - 1);
        this.className = className.substring(idx + 1);
    }

    public void trace(Object obj) {
        this.output(5, obj);
    }

    public void trace(Object obj, Throwable t) {
        this.output(5, obj, t);
    }

    public void debug(Object obj) {
        this.output(4, obj);
    }

    public void debug(Object obj, Throwable t) {
        this.output(4, obj, t);
    }

    public void info(Object obj) {
        this.output(3, obj);
    }

    public void info(Object obj, Throwable t) {
        this.output(3, obj, t);
    }

    public void warn(Object obj) {
        this.output(2, obj);
    }

    public void warn(Object obj, Throwable t) {
        this.output(2, obj, t);
    }

    public void error(Object obj) {
        this.output(1, obj);
    }

    public void error(Object obj, Throwable t) {
        this.output(1, obj, t);
    }

    private void output(int level, Object obj) {
        if (level > Logger.level) {
            return;
        }
        Logger.getLogger().preLog(this.getHeader(level) + obj.toString());
    }

    private void output(int level, Object obj, Throwable t) {
        if (level > Logger.level) {
            return;
        }
        Logger.getLogger().preLog(this.getHeader(level) + obj.toString() + " exception=" + t + " message=" + t.getMessage());
        t.printStackTrace();
    }

    private String getHeader(int level) {
        String lvl = null;
        switch (level) {
            case 1: {
                lvl = "ERROR";
                break;
            }
            case 2: {
                lvl = "WARN";
                break;
            }
            case 3: {
                lvl = "INFO";
                break;
            }
            case 4: {
                lvl = "DEBUG";
                break;
            }
            case 5: {
                lvl = "TRACE";
                break;
            }
        }
        String therName = "";
        return "[" + therName + lvl + " " + this.className + " " + MiscUtil.getClientTime() + "] ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void log(String txt) {
        if (logPath == null) {
            return;
        }
        System.out.println("in logger");
        RecordStore store = null;
        byte[] data = txt.getBytes();
        try {
            store = RecordStore.openRecordStore((String)logNameInRMS, (boolean)true);
            byte[] prevData = new byte[]{};
            System.out.println("record store opened: " + store);
            if (store.getNumRecords() > 0) {
                try {
                    prevData = store.getRecord(1);
                }
                catch (Exception e) {
                    System.out.println("e - " + e);
                    e.printStackTrace();
                }
            }
            try {
                System.out.println("Stored all");
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (Exception e) {
                System.out.println("e - " + e);
                e.printStackTrace();
            }
            RecordStore.deleteRecordStore((String)logNameInRMS);
            store = RecordStore.openRecordStore((String)logNameInRMS, (boolean)true);
            byte[] newData = txt.getBytes();
            System.out.println("calculate size");
            int newSize = prevData.length + newData.length;
            data = new byte[newSize];
            System.out.println("new size allocated");
            System.arraycopy(prevData, 0, data, 0, prevData.length);
            System.arraycopy(newData, 0, data, prevData.length, newData.length);
            store.addRecord(data, 0, data.length);
            System.out.println("data copied");
        }
        catch (Exception e) {
            System.out.println("Exception in RMS " + e);
            e.printStackTrace();
        }
        finally {
            try {
                System.out.println("Stored all");
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (Exception e) {
                System.out.println("e - " + e);
                e.printStackTrace();
            }
        }
    }

    public static void removeLog() {
        try {
            RecordStore.deleteRecordStore((String)logNameInRMS);
        }
        catch (Exception e) {
            System.out.println("e - " + e);
            e.printStackTrace();
        }
    }
}

