/*
 * Decompiled with CFR 0.152.
 */
package com.fw.j2me.util.log;

import com.fw.j2me.util.log.Logger;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class FileLogger
extends Logger {
    private static FileLogger instance = null;
    private String fileName = "file:///c:/other/YouKuLog.txt";
    private boolean toFile = true;
    private boolean output = true;
    private FileConnection fc = null;
    private OutputStream os = null;

    FileLogger(int level) {
        super(level);
        instance = this;
    }

    private static FileLogger getInstance() {
        if (instance == null) {
            instance = new FileLogger(10);
        }
        return instance;
    }

    public static void println(String message) {
        FileLogger.getInstance().log(message);
    }

    synchronized void log(String message) {
        if (!FileLogger.getInstance().output) {
            return;
        }
        if (this.toFile && this.fc == null) {
            this.openFileForLogging();
        }
        if (this.toFile) {
            this.writeToFile(message);
        } else {
            System.out.println(message);
        }
    }

    private void writeToFile(String message) {
        try {
            this.os.write(message.getBytes());
            this.os.flush();
        }
        catch (IOException e) {
            System.err.println("Could not write message to file. Switching to STDOUT logging.\n" + e.toString());
            this.closeFile();
            this.toFile = false;
        }
        System.out.println(message.substring(0, message.length() - 2));
    }

    private void openFileForLogging() {
        try {
            this.fc = (FileConnection)Connector.open((String)this.fileName, (int)3, (boolean)true);
            if (this.fc.exists()) {
                this.fc.truncate(0L);
            } else {
                this.fc.create();
            }
            this.os = this.fc.openOutputStream();
        }
        catch (IOException e) {
            System.err.println("Could not open log file. Switching to STDOUT logging.\n" + e.toString());
            this.closeFile();
            this.toFile = false;
        }
    }

    public void release() {
        this.closeFile();
    }

    private void closeFile() {
        try {
            if (this.os != null) {
                this.os.close();
            }
            if (this.fc != null) {
                this.fc.close();
            }
        }
        catch (IOException ce) {
            System.err.println("in catch close fail.\n" + ce.toString());
        }
        this.os = null;
        this.fc = null;
    }
}

