/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui;

import com.fw.j2me.uiimpl.UiContext;
import com.fw.j2me.util.SoundPlayer;
import com.fw.j2me.util.log.CntLog;
import com.sonyericsson.ykjc.engine.Engine;
import com.sonyericsson.ykjc.engine.SimEngine;
import com.sonyericsson.ykjc.proxy.IYkProxy;
import com.sonyericsson.ykjc.ui.ImageManager;
import com.sonyericsson.ykjc.ui.StringManager;
import com.sonyericsson.ykjc.ui.YkUiConfig;
import com.sonyericsson.ykjc.ui.YkUiController;
import com.sun.lwuit.Font;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.Resources;
import java.util.Hashtable;

public class YkUiContext
extends UiContext {
    private static CntLog log = new CntLog("UiContext");
    private static boolean simEngine = false;
    private static boolean initiated = false;
    public static ImageManager imgMgr;
    public static StringManager strMgr;
    public static YkUiConfig uiConfig;
    public static IYkProxy proxy;
    private static String sendFile;
    private static boolean uploadingFlag;
    private static boolean mainPageShown;

    private YkUiContext() {
    }

    public static synchronized void init() {
        if (!initiated) {
            YkUiContext.initResource();
            UiContext.controller = new YkUiController();
            uiConfig = new YkUiConfig();
            UiContext.controller.start();
            proxy = simEngine ? new SimEngine(UiContext.controller) : new Engine(UiContext.controller);
            SoundPlayer.getInstance();
            initiated = true;
        }
    }

    private static void initResource() {
        try {
            Resources r = Resources.open("/theme.res");
            Hashtable theme = r.getTheme(r.getThemeResourceNames()[0]);
            Font font = Font.createSystemFont(32, 0, 8);
            theme.put("font", font);
            UIManager.getInstance().setThemeProps(theme);
            imgMgr = new ImageManager("/images.res");
            strMgr = new StringManager("/strings.res");
            UIManager.getInstance().setResourceBundle(strMgr.getStringTable());
        }
        catch (Exception e) {
            log.error("initResource: ", e);
        }
    }

    public static String getSendFile() {
        return sendFile;
    }

    public static void setSendFile(String sendFile) {
        YkUiContext.sendFile = sendFile;
    }

    public static void removeSendFile() {
        sendFile = null;
    }

    public static void setUploadingFlag(boolean flag) {
        uploadingFlag = flag;
    }

    public static boolean getUploadingFlag() {
        return uploadingFlag;
    }

    public static boolean isMainPageShown() {
        return mainPageShown;
    }

    public static void setMainPageShown(boolean mainPageShown) {
        YkUiContext.mainPageShown = mainPageShown;
    }
}

