/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import java.util.Vector;

public class AutoFixLabel
extends Component {
    private static final int DEFAULT_WIDTH = Display.getInstance().getDisplayWidth() / 4;
    private static final int DEFAULT_MARGIN = 2;
    private static final int MAX_LINES = 2;
    private int width;
    private Vector strings;
    private Image icon;
    private int rows;
    private String text;
    private int textAlignment = 1;
    private static Font defaultFont = Font.createSystemFont(0, 0, 8);

    public AutoFixLabel(String text) {
        this(text, DEFAULT_WIDTH, null);
    }

    public AutoFixLabel(String text, int width) {
        this(text, width, null);
    }

    public AutoFixLabel(String text, int width, Image icon) {
        this(text, width, icon, 2);
    }

    public AutoFixLabel(String text, int width, Image icon, int rows) {
        this.width = width;
        this.text = text;
        this.rows = rows;
        this.getStyle().setMargin(2, 2, 2, 2);
        this.getStyle().setPadding(2, 2, 2, 2);
        this.setIcon(icon);
        this.setFocusable(false);
    }

    private void splitText() {
        int margin = this.getStyle().getMargin(1);
        int padding = this.getStyle().getPadding(1);
        this.strings = new Vector();
        int w = this.width - margin * 2 - padding * 2;
        if (this.icon != null) {
            w -= this.icon.getHeight() + margin;
        }
        int h = margin + padding * 2;
        int tempW = 0;
        int end = 0;
        for (int lines = 0; lines < this.rows && end <= this.text.length() - 1; ++lines) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.text.charAt(end));
            tempW = defaultFont.stringWidth(sb.toString());
            while (tempW <= w && end < this.text.length() - 1) {
                sb.append(this.text.charAt(++end));
                tempW = defaultFont.stringWidth(sb.toString());
            }
            if (tempW > w) {
                sb.deleteCharAt(sb.length() - 1);
                this.strings.addElement(sb.toString());
                continue;
            }
            this.strings.addElement(sb.toString());
            ++lines;
            break;
        }
        if (end < this.text.length() - 1) {
            String lastString = (String)this.strings.elementAt(this.rows - 1);
            this.strings.removeElementAt(this.rows - 1);
            tempW = defaultFont.stringWidth("..." + lastString);
            end = lastString.length() - 1;
            while (tempW > w) {
                lastString = lastString.substring(0, end--);
                tempW = defaultFont.stringWidth("..." + lastString);
            }
            this.strings.addElement(lastString + "...");
        }
        this.setPreferredSize(new Dimension(this.width, h += this.strings.size() * (defaultFont.getHeight() + margin)));
    }

    public void setRows(int rows) {
        if (rows >= 0) {
            this.rows = rows;
            this.splitText();
        }
    }

    public void setIcon(Image icon) {
        this.icon = icon;
        if (icon != null) {
            int fontH = defaultFont.getHeight();
            if (icon.getHeight() > fontH) {
                this.icon = icon.scaledHeight(fontH);
            }
        }
        this.splitText();
    }

    public void setFont(Font font) {
        defaultFont = font;
        this.setIcon(this.icon);
    }

    public void paint(Graphics g) {
        int margin = this.getStyle().getMargin(1);
        int padding = this.getStyle().getPadding(1);
        int x = this.getX() + margin + padding;
        int y = this.getY();
        int yPos = y + this.getStyle().getMargin(0) + this.getStyle().getPadding(0);
        if (this.icon != null) {
            g.drawImage(this.icon, x, yPos + (defaultFont.getHeight() - this.icon.getHeight()) / 2);
            x += this.icon.getWidth() + margin;
        }
        g.setFont(defaultFont);
        g.setColor(0);
        for (int i = 0; i < this.strings.size(); ++i) {
            if (i == this.strings.size() - 1 && this.textAlignment == 4) {
                String str = (String)this.strings.elementAt(i);
                int stringWidth = defaultFont.stringWidth(str);
                int xPos = this.getX() + (this.width - margin * 2 - padding * 2 - stringWidth) / 2;
                g.drawString(str, xPos, yPos);
                yPos += defaultFont.getHeight() + margin;
                continue;
            }
            g.drawString((String)this.strings.elementAt(i), x, yPos);
            yPos += defaultFont.getHeight() + margin;
        }
    }

    public void setTextAlignment(int alignment) {
        this.textAlignment = alignment;
    }
}

