/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sun.lwuit.Container;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import java.util.Timer;
import java.util.TimerTask;

public class ClipInformationItem
extends Container {
    private String title = null;
    private String timeLen = null;
    private String videoSize = null;
    private String playTimes = null;
    private String upTimes = null;
    private String downTimes = null;
    private Image clipImage = null;
    private String[] labels = new String[4];
    private Image[] icons = new Image[4];
    private int titleColor = 0;
    private boolean showClipImage = false;
    private int contentColor = 26265;
    private static final int SPACE_X = 5;
    private static final int SPACE_Y = 5;
    private static final int INTERVAL = 2;
    private static final int SPACE = 10;
    private static final int STAY_TIME = 1000;
    private static final int MS_PER_PIXEL = 50;
    private String line;
    private int titleX = 10;
    private static final Font FONT = Font.createSystemFont(32, 0, 8);
    private static final Image redTriangle = YkUiContext.imgMgr.getImage("redTriangle");
    private long scrollStartTime;
    private boolean focused = false;
    private Timer timer = new Timer();
    private boolean inited;

    public ClipInformationItem(Dimension preferredSize) {
        String label;
        this.labels[0] = label = YkUiContext.strMgr.getString("videosize");
        this.labels[1] = label = YkUiContext.strMgr.getString("times");
        this.labels[2] = label = YkUiContext.strMgr.getString("up");
        this.labels[3] = label = YkUiContext.strMgr.getString("down");
        this.icons[0] = YkUiContext.imgMgr.getImage("icon1");
        this.icons[1] = YkUiContext.imgMgr.getImage("icon2");
        this.icons[2] = YkUiContext.imgMgr.getImage("icon3");
        this.icons[3] = YkUiContext.imgMgr.getImage("icon4");
        this.setPreferredSize(preferredSize);
        this.setFocusable(false);
        this.setColor(0, 0);
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (ClipInformationItem.this.focused && ClipInformationItem.this.inited) {
                    ClipInformationItem.this.repaint();
                }
            }
        }, 200L, 200L);
    }

    public void setClipInformation(String title, String timeLen, int playTimes, int upTimes, int downTimes, Image clipImage) {
        int t;
        this.title = title;
        this.timeLen = timeLen;
        if (playTimes > 1000000) {
            t = playTimes / 1000;
            this.playTimes = String.valueOf(t) + "K";
        } else {
            this.playTimes = String.valueOf(playTimes);
        }
        if (upTimes > 1000000) {
            t = upTimes / 1000;
            this.upTimes = String.valueOf(t) + "K";
        } else {
            this.upTimes = String.valueOf(upTimes);
        }
        if (downTimes > 1000000) {
            t = downTimes / 1000;
            this.downTimes = String.valueOf(t) + "K";
        } else {
            this.downTimes = String.valueOf(downTimes);
        }
        this.clipImage = clipImage;
        this.initScroll();
    }

    public void setColor(int aTitleColor, int aContentColor) {
        this.titleColor = aTitleColor;
        this.contentColor = aContentColor;
    }

    public void paint(Graphics g) {
        this.paint0(g);
    }

    public void setFocus(boolean focused) {
        this.focused = focused;
        if (focused) {
            this.initScroll();
        }
        this.repaint();
    }

    private void initScroll() {
        int w;
        int i;
        this.scrollStartTime = System.currentTimeMillis();
        this.line = this.title;
        int lineWidth = this.getPreferredW() - (redTriangle.getWidth() + 2) - 20 - FONT.stringWidth("...");
        for (i = 0; i < this.title.length() && (w = FONT.substringWidth(this.title, 0, i)) <= lineWidth; ++i) {
        }
        if (i < this.title.length()) {
            this.line = --i < 0 ? "..." : this.title.substring(0, i) + "...";
        }
        int width = FONT.stringWidth(this.line) + redTriangle.getWidth() + 2;
        this.titleX = (this.getPreferredW() - width) / 2;
        this.inited = true;
    }

    private void paint0(Graphics g) {
        int baseY;
        if (this.title == null) {
            return;
        }
        g.setFont(FONT);
        int topPadding = 5;
        int titleY = baseY = this.getY() + topPadding;
        g.setColor(this.titleColor);
        if (this.focused && null != this.title && this.line != null && !this.title.equals(this.line)) {
            g.setClip(10, titleY, this.getWidth() - 20, FONT.getHeight());
            int scrollXOffset = this.getScrollXOffset(this.getWidth() - 20, FONT.stringWidth(this.title));
            g.drawImage(redTriangle, this.titleX + scrollXOffset, titleY + (g.getFont().getHeight() - redTriangle.getHeight()) / 2);
            g.drawString(this.title, this.titleX + (scrollXOffset += redTriangle.getWidth() + 2), titleY);
            g.setClip(this.getX(), this.getY(), this.getPreferredW(), this.getPreferredH());
        } else {
            g.drawImage(redTriangle, this.titleX, titleY + (g.getFont().getHeight() - redTriangle.getHeight()) / 2);
            g.drawString(this.line, this.titleX + redTriangle.getWidth() + 2, titleY);
        }
        int cellWidth = this.getWidth() * 11 / 24;
        int cellNumPerLine = 2;
        int itemSpaceX = (this.getWidth() - cellNumPerLine * cellWidth) / (cellNumPerLine + 1);
        g.setColor(this.contentColor);
        int x1 = this.getX() + itemSpaceX;
        int y1 = titleY + g.getFont().getHeight() + 5;
        String itemStr = this.labels[0];
        if (this.timeLen != null) {
            itemStr = itemStr + this.timeLen;
        }
        g.drawString(itemStr, x1 + 5, y1 + (this.icons[0].getHeight() - g.getFont().getHeight()) / 2);
        int x2 = x1 + cellWidth + itemSpaceX + 5;
        int y2 = y1;
        g.drawImage(this.icons[2], x2, y2);
        itemStr = this.labels[2];
        if (this.upTimes != null) {
            itemStr = itemStr + this.upTimes;
        }
        g.drawString(itemStr, x2 + this.icons[2].getWidth() + 5, y2 + (this.icons[2].getHeight() - g.getFont().getHeight()) / 2);
        int x3 = x1;
        int y3 = y1 + g.getFont().getHeight() + 5;
        itemStr = this.labels[1];
        if (this.playTimes != null) {
            itemStr = itemStr + this.playTimes;
        }
        g.drawString(itemStr, x3 + 5, y3 + (this.icons[1].getHeight() - g.getFont().getHeight()) / 2);
        int x4 = x3 + cellWidth + itemSpaceX + 5;
        int y4 = y3;
        g.drawImage(this.icons[3], x4, y4);
        itemStr = this.labels[3];
        if (this.downTimes != null) {
            itemStr = itemStr + this.downTimes;
        }
        g.drawString(itemStr, x4 + this.icons[3].getWidth() + 5, y4 + (this.icons[3].getHeight() - g.getFont().getHeight()) / 2);
    }

    private int getScrollXOffset(int width, int strWidth) {
        int ret = (int)(System.currentTimeMillis() - this.scrollStartTime - 1000L) / 50;
        if (0 > ret) {
            ret = 0;
        }
        ret = (ret %= width + strWidth) > strWidth ? width + strWidth - ret : -ret;
        return ret;
    }

    public void setType(int type) {
        this.showClipImage = type != 0;
    }
}

