/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.fw.j2me.util.log.CntLog;
import com.sonyericsson.ykjc.ui.IndependentComponent;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.IndependentComponentCreator;
import com.sonyericsson.ykjc.ui.component.KeyConsumer;
import com.sonyericsson.ykjc.ui.component.SearchBoxListener;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import java.util.Timer;
import java.util.TimerTask;

public class SearchBox2
extends Container
implements ActionListener,
IndependentComponentCreator,
KeyConsumer,
FocusListener {
    private static final int CURSOR_PERIOD = 500;
    private static final int SEARCH_BOX_WIDTH = 198;
    private CntLog log = new CntLog("SearchBox2");
    public static final int ITEM_TYPE_EDITOR = 0;
    public static final int ITEM_TYPE_KEYWORD = 1;
    public static final int STATE_COLLAPSE = 0;
    public static final int STATE_EXPAND = 1;
    private final int colorDisable;
    private static String keyWord = "";
    private String[] candidateKeyWords = new String[0];
    private Image focusBg;
    private Image unFocusBg;
    private Image buttonBg;
    private SearchBoxListener listener;
    private int rectHeight;
    private boolean disable = false;
    private SearchTextArea editor;
    private static int focusedIndex = 0;
    private static int state;
    private static boolean isCursorVisible;
    private static Timer timer;
    private Font font = Font.createSystemFont(32, 0, 8);

    public SearchBox2(Dimension preferredSize, String[] words) {
        this(preferredSize, YkUiContext.proxy.getLatestSearchWord(), words);
    }

    public SearchBox2(Dimension preferredSize, String text, String[] words) {
        this.colorDisable = 0x8C8C8C;
        state = 0;
        focusedIndex = 0;
        this.candidateKeyWords = words;
        this.focusBg = YkUiContext.imgMgr.getImage("searchBg1");
        this.unFocusBg = YkUiContext.imgMgr.getImage("searchBg0");
        this.buttonBg = YkUiContext.imgMgr.getImage("searchbar");
        keyWord = text;
        boolean resetKeyWord = false;
        if (keyWord == null) {
            resetKeyWord = true;
        } else if (keyWord.length() == 0) {
            resetKeyWord = true;
        }
        if (resetKeyWord && words != null && words.length > 0) {
            keyWord = words[0];
        }
        this.editor = new SearchTextArea();
        this.editor.addActionListener(this);
        this.addComponent(this.editor);
        this.editor.setVisible(false);
        this.editor.setFocusable(false);
        this.rectHeight = this.buttonBg.getHeight() * words.length;
        this.setPreferredSize(new Dimension(preferredSize.getWidth(), this.focusBg.getHeight()));
        this.addFocusListener(this);
        this.setFocusable(true);
    }

    public int getCollapsedHeight() {
        return this.focusBg.getHeight();
    }

    public void setListener(SearchBoxListener l) {
        this.listener = l;
    }

    protected boolean isSelectableInteraction() {
        return true;
    }

    protected void fireClicked() {
        if (state == 0) {
            this.expand();
        } else if (focusedIndex == 0) {
            this.editor.fireClicked();
        }
    }

    public void setDisabled() {
        this.disable = true;
    }

    public boolean consumeKey(int keyCode) {
        boolean consumed = false;
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (state == 1) {
            if (gameAction == 6) {
                if (++focusedIndex == 1 + this.candidateKeyWords.length) {
                    focusedIndex = 0;
                }
                this.listener.handleSearchBoxEvent(1003, new Integer(focusedIndex == 0 ? 0 : 1));
            } else if (gameAction == 1) {
                if (--focusedIndex == -1) {
                    focusedIndex = this.candidateKeyWords.length;
                }
                this.listener.handleSearchBoxEvent(1003, new Integer(focusedIndex == 0 ? 0 : 1));
            }
            consumed = true;
        }
        if (gameAction == 1 || gameAction == 2 || gameAction == 5) {
            consumed = true;
        }
        if (consumed) {
            this.repaint();
        }
        return consumed;
    }

    public void executeCommand(int id) {
        switch (id) {
            case 1000: {
                this.listener.handleSearchBoxEvent(1002, null);
                this.collapse();
                break;
            }
            case 1001: {
                this.editor.fireClicked();
                break;
            }
            case 1002: {
                this.listener.handleSearchBoxEvent(1002, null);
                keyWord = focusedIndex == 0 ? keyWord : this.candidateKeyWords[focusedIndex - 1];
                this.doSearch();
                break;
            }
            case 1003: {
                this.expand();
                break;
            }
            default: {
                this.log.debug("unknown command " + id);
            }
        }
        this.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        this.log.debug(e);
        if (e == null) {
            return;
        }
        if (e.getSource() == this.editor && e.getKeyEvent() == -1) {
            keyWord = this.editor.getText();
            if (keyWord.length() <= 0) {
                this.listener.handleSearchBoxEvent(1003, new Integer(0));
            }
            this.log.debug(keyWord);
            if (this.listener != null && keyWord.length() > 0) {
                this.doSearch();
            }
        }
    }

    private void drawCursor(Graphics g, int x, int y) {
        if (isCursorVisible) {
            g.setColor(0);
            int cursorX = x + 12;
            g.drawLine(cursorX += this.font.stringWidth(keyWord), y + 8 + (this.focusBg.getHeight() - 8 - this.font.getHeight()) / 2, cursorX, y + 8 + (this.focusBg.getHeight() - 8 - this.font.getHeight()) / 2 + this.font.getHeight());
        }
    }

    public void paint(Graphics g) {
        int searchBoxWidth = YkUiContext.uiConfig.getIntProperty("search_box_width", 198);
        int x = this.getX();
        int y = this.getY();
        if (this.hasFocus()) {
            g.drawImage(this.focusBg, x, y);
            if (0 == focusedIndex) {
                this.drawCursor(g, x, y);
            }
        } else {
            g.drawImage(this.unFocusBg, x, y);
        }
        g.setFont(this.font);
        g.setClip(x += 6, y, searchBoxWidth, this.buttonBg.getHeight() * this.candidateKeyWords.length + this.focusBg.getHeight() + 4);
        if (keyWord != null && keyWord.length() > 0) {
            g.setColor(this.disable || !this.hasFocus() || this.hasFocus() && 0 != focusedIndex ? 0x8C8C8C : 0);
            g.drawString(keyWord, x + 5, y + 8 + (this.focusBg.getHeight() - 8 - this.font.getHeight()) / 2);
        }
        if (state == 1) {
            g.setClip(x, y += this.focusBg.getHeight() - 1, searchBoxWidth - 1, this.rectHeight - 1);
            g.setColor(-1);
            g.fillRect(x, y, searchBoxWidth - 2, this.rectHeight - 1);
            g.setColor(3251408);
            g.drawRect(x, y - 1, searchBoxWidth - 2, this.rectHeight - 1);
            g.setColor(0);
            for (int i = 0; i < this.candidateKeyWords.length; ++i) {
                if (focusedIndex - 1 == i) {
                    g.drawImage(this.buttonBg, x, y - 1);
                }
                g.drawString(this.candidateKeyWords[i], x + 5, y + (this.buttonBg.getHeight() - this.font.getHeight()) / 2);
                y += this.buttonBg.getHeight();
            }
            g.setClip(0, 0, this.getPreferredW(), this.getPreferredH());
        }
    }

    private void doSearch() {
        state = 0;
        this.stopTimer();
        focusedIndex = 0;
        this.listener.handleSearchBoxEvent(1001, keyWord);
    }

    private void expand() {
        this.editor.setText(keyWord);
        if (this.candidateKeyWords.length > 0) {
            state = 1;
            this.setPreferredSize(new Dimension(this.getPreferredW(), this.focusBg.getHeight() + this.rectHeight));
            this.listener.handleSearchBoxEvent(1003, new Integer(0));
        } else {
            this.editor.fireClicked();
        }
        this.repaint();
    }

    private void collapse() {
        state = 0;
        focusedIndex = 0;
        this.setPreferredSize(new Dimension(this.getPreferredW(), this.focusBg.getHeight()));
        this.getComponentForm().show();
    }

    public IndependentComponent genIndependentComponent() {
        int[] actions = new int[]{1, 6, 2, 5};
        IndependentComponent ic = new IndependentComponent(this, actions);
        return ic;
    }

    public void focusGained(final Component cmp) {
        this.stopTimer();
        timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                isCursorVisible = !isCursorVisible;
                cmp.repaint(cmp.getAbsoluteX(), cmp.getAbsoluteY(), SearchBox2.this.focusBg.getWidth(), SearchBox2.this.focusBg.getHeight());
            }
        }, 0L, 500L);
    }

    public void focusLost(Component cmp) {
        this.stopTimer();
        this.listener.handleSearchBoxEvent(1004, null);
    }

    public void refresh() {
        String text = YkUiContext.proxy.getLatestSearchWord();
        if (text != null && text.length() > 0) {
            keyWord = text;
        }
        this.repaint();
    }

    public static boolean hasKeyword() {
        return keyWord != null && keyWord.length() > 0;
    }

    public void stopTimer() {
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
    }

    private class SearchTextArea
    extends TextArea {
        public SearchTextArea() {
            this.setMaxSize(10);
        }

        protected void fireClicked() {
            super.fireClicked();
        }
    }
}

